/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Label the objects in a binary image.


ConnectedComponentImageFilter labels the objects in a binary image (non-zero pixels are considered
to be objects, zero-valued pixels are considered to be background).
Each distinct object is assigned a unique label. The filter
experiments with some improvements to the existing implementation, and
is based on run length encoding along raster lines. If the output
background value is set to zero (the default), the final object labels
start with 1 and are consecutive. If the output background is set to a
non-zero value (by calling the SetBackgroundValue() routine of the
filter), the final labels start at 0, and remain consecutive except
for skipping the background value as needed. Objects that are reached
earlier by a raster order scan have a lower label. This is different
to the behaviour of the original connected component image filter
which did not produce consecutive labels or impose any particular
ordering.

After the filter is executed, ObjectCount holds the number of
connected components.


See:
 ImageToImageFilter

 itk::simple::ConnectedComponent for the procedural interface

 itk::ConnectedComponentImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkConnectedComponentImageFilter.h
*/
public class ConnectedComponentImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ConnectedComponentImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ConnectedComponentImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ConnectedComponentImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ConnectedComponentImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ConnectedComponentImageFilter::~ConnectedComponentImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ConnectedComponentImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ConnectedComponentImageFilter::ConnectedComponentImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ConnectedComponentImageFilter() {
    this(SimpleITKJNI.new_ConnectedComponentImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ConnectedComponentImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.ConnectedComponentImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::ConnectedComponentImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.ConnectedComponentImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ConnectedComponentImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.ConnectedComponentImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::ConnectedComponentImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.ConnectedComponentImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
uint32_t itk::simple::ConnectedComponentImageFilter::GetObjectCount() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getObjectCount() {
    return SimpleITKJNI.ConnectedComponentImageFilter_getObjectCount(swigCPtr, this);
  }

  /**
std::string itk::simple::ConnectedComponentImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ConnectedComponentImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ConnectedComponentImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ConnectedComponentImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ConnectedComponentImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.ConnectedComponentImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  /**
Image itk::simple::ConnectedComponentImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image) {
    return new Image(SimpleITKJNI.ConnectedComponentImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image), true);
  }

}
