/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.Actuals_awtKt;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.PredefinedCursorsId;
import org.jetbrains.skiko.RenderFactory;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0006H\u0000\u001a\n\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0000\u001a!\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0013j\u0002`\u0018H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u001d\u0010\u001a\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u0019\u0010\u001c\u001a\u00060\u0013j\u0002`\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\u0010\u001f\"\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n*\n\u0010\u0012\"\u00020\u00132\u00020\u0013\u00a8\u0006 "}, d2={"setSystemLookAndFeel", "", "makeDefaultRenderFactory", "Lorg/jetbrains/skiko/RenderFactory;", "URIHandler_openUri", "uri", "", "systemClipboard", "Ljava/awt/datatransfer/Clipboard;", "getSystemClipboard", "()Ljava/awt/datatransfer/Clipboard;", "systemClipboard$delegate", "Lkotlin/Lazy;", "ClipboardManager_setText", "text", "ClipboardManager_getText", "ClipboardManager_hasText", "", "Cursor", "Ljava/awt/Cursor;", "CursorManager_setCursor", "component", "", "cursor", "Lorg/jetbrains/skiko/Cursor;", "(Ljava/lang/Object;Ljava/awt/Cursor;)V", "CursorManager_getCursor", "(Ljava/lang/Object;)Ljava/awt/Cursor;", "getCursorById", "id", "Lorg/jetbrains/skiko/PredefinedCursorsId;", "(Lorg/jetbrains/skiko/PredefinedCursorsId;)Ljava/awt/Cursor;", "skiko"})
public final class Actuals_awtKt {
    @NotNull
    private static final Lazy systemClipboard$delegate = LazyKt.lazy(Actuals_awtKt::systemClipboard_delegate$lambda$0);

    public static final void setSystemLookAndFeel() {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    @NotNull
    public static final RenderFactory makeDefaultRenderFactory() {
        return makeDefaultRenderFactory.1.INSTANCE;
    }

    public static final void URIHandler_openUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(uri));
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
                case 1: {
                    new URI(uri);
                    String[] stringArray = new String[]{"xdg-open", new URI(uri).toString()};
                    Runtime.getRuntime().exec(stringArray);
                    break;
                }
                case 2: 
                case 3: {
                    throw new UnsupportedOperationException("AWT doesn't support the BROWSE action on " + (Object)((Object)OsArch_jvmKt.getHostOs()));
                }
                default: {
                    throw new UnsupportedOperationException("AWT doesn't support " + (Object)((Object)OsArch_jvmKt.getHostOs()));
                }
            }
        }
    }

    private static final Clipboard getSystemClipboard() {
        Lazy lazy = systemClipboard$delegate;
        return (Clipboard)lazy.getValue();
    }

    public static final void ClipboardManager_setText(@NotNull String text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Clipboard clipboard = Actuals_awtKt.getSystemClipboard();
            if (clipboard == null) break block0;
            clipboard.setContents(new StringSelection(text), null);
        }
    }

    @Nullable
    public static final String ClipboardManager_getText() {
        String string;
        try {
            Clipboard clipboard = Actuals_awtKt.getSystemClipboard();
            string = (String)(clipboard != null ? clipboard.getData(DataFlavor.stringFlavor) : null);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            string = null;
        }
        catch (IllegalStateException illegalStateException) {
            string = null;
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    public static final boolean ClipboardManager_hasText() {
        CharSequence charSequence = Actuals_awtKt.ClipboardManager_getText();
        return !(charSequence == null || charSequence.length() == 0);
    }

    public static final void CursorManager_setCursor(@NotNull Object component, @NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        if (component instanceof Component) {
            ((Component)component).setCursor(cursor);
        }
    }

    @Nullable
    public static final Cursor CursorManager_getCursor(@NotNull Object component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component instanceof Component ? ((Component)component).getCursor() : null;
    }

    @NotNull
    public static final Cursor getCursorById(@NotNull PredefinedCursorsId id) {
        Cursor cursor;
        Intrinsics.checkNotNullParameter((Object)((Object)id), (String)"id");
        switch (WhenMappings.$EnumSwitchMapping$1[id.ordinal()]) {
            case 1: {
                cursor = new Cursor(0);
                break;
            }
            case 2: {
                cursor = new Cursor(1);
                break;
            }
            case 3: {
                cursor = new Cursor(12);
                break;
            }
            case 4: {
                cursor = new Cursor(2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cursor;
    }

    private static final Clipboard systemClipboard_delegate$lambda$0() {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException e) {
            clipboard = null;
        }
        return clipboard;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MacOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PredefinedCursorsId.values().length];
            try {
                nArray[PredefinedCursorsId.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedCursorsId.CROSSHAIR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedCursorsId.HAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedCursorsId.TEXT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

