from _typeshed import Unused
from typing import Any

from asgiref.typing import WebSocketConnectEvent, WebSocketDisconnectEvent, WebSocketReceiveEvent
from channels.consumer import AsyncConsumer, SyncConsumer

class WebsocketConsumer(SyncConsumer):
    groups: list[str]

    def __init__(self, *args: Unused, **kwargs: Unused) -> None: ...
    def websocket_connect(self, message: WebSocketConnectEvent) -> None: ...
    def connect(self) -> None: ...
    def accept(self, subprotocol: str | None = None, headers: list[tuple[str, str]] | None = None) -> None: ...
    def websocket_receive(self, message: WebSocketReceiveEvent) -> None: ...
    def receive(self, text_data: str | None = None, bytes_data: bytes | None = None) -> None: ...
    def send(  # type: ignore[override]
        self, text_data: str | None = None, bytes_data: bytes | None = None, close: bool = False
    ) -> None: ...
    def close(self, code: int | bool | None = None, reason: str | None = None) -> None: ...
    def websocket_disconnect(self, message: WebSocketDisconnectEvent) -> None: ...
    def disconnect(self, code: int) -> None: ...

class JsonWebsocketConsumer(WebsocketConsumer):
    def receive(self, text_data: str | None = None, bytes_data: bytes | None = None, **kwargs: Any) -> None: ...
    # content is typed as Any to match json.loads() return type - JSON can represent
    # various Python types (dict, list, str, int, float, bool, None)
    def receive_json(self, content: Any, **kwargs: Any) -> None: ...
    # content is typed as Any to match json.dumps() input type - accepts any JSON-serializable object
    def send_json(self, content: Any, close: bool = False) -> None: ...
    @classmethod
    def decode_json(cls, text_data: str) -> Any: ...  # Returns Any like json.loads()
    @classmethod
    def encode_json(cls, content: Any) -> str: ...  # Accepts Any like json.dumps()

class AsyncWebsocketConsumer(AsyncConsumer):
    groups: list[str]

    def __init__(self, *args: Unused, **kwargs: Unused) -> None: ...
    async def websocket_connect(self, message: WebSocketConnectEvent) -> None: ...
    async def connect(self) -> None: ...
    async def accept(self, subprotocol: str | None = None, headers: list[tuple[str, str]] | None = None) -> None: ...
    async def websocket_receive(self, message: WebSocketReceiveEvent) -> None: ...
    async def receive(self, text_data: str | None = None, bytes_data: bytes | None = None) -> None: ...
    async def send(  # type: ignore[override]
        self, text_data: str | None = None, bytes_data: bytes | None = None, close: bool = False
    ) -> None: ...
    async def close(self, code: int | bool | None = None, reason: str | None = None) -> None: ...
    async def websocket_disconnect(self, message: WebSocketDisconnectEvent) -> None: ...
    async def disconnect(self, code: int) -> None: ...

class AsyncJsonWebsocketConsumer(AsyncWebsocketConsumer):
    async def receive(self, text_data: str | None = None, bytes_data: bytes | None = None, **kwargs: Any) -> None: ...
    # content is typed as Any to match json.loads() return type - JSON can represent
    # various Python types (dict, list, str, int, float, bool, None)
    async def receive_json(self, content: Any, **kwargs: Any) -> None: ...
    # content is typed as Any to match json.dumps() input type - accepts any JSON-serializable object
    async def send_json(self, content: Any, close: bool = False) -> None: ...
    @classmethod
    async def decode_json(cls, text_data: str) -> Any: ...  # Returns Any like json.loads()
    @classmethod
    async def encode_json(cls, content: Any) -> str: ...  # Accepts Any like json.dumps()
