\name{GrayscaleGrindPeakImageFilter}
\alias{GrayscaleGrindPeakImageFilter}
\title{GrayscaleGrindPeakImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Remove local maxima not connected to the boundary of the image.
GrayscaleGrindPeakImageFilter}
\details{
GrayscaleGrindPeakImageFilter removes peaks in a grayscale image. Peaks are local maxima in the
grayscale topography that are not connected to boundaries of the
image. Gray level values adjacent to a peak are extrapolated through
the peak.
This filter is used to smooth over local maxima without affecting the
values of local minima. If you take the difference between the output
of this filter and the original image (and perhaps threshold the
difference above a small value), you'll obtain a map of the local
maxima.
This filter uses the GrayscaleGeodesicDilateImageFilter . It provides its own input as the "mask" input to the geodesic
erosion. The "marker" image for the geodesic erosion is constructed
such that boundary pixels match the boundary pixels of the input image
and the interior pixels are set to the minimum pixel value in the
input image.
This filter is the dual to the GrayscaleFillholeImageFilter which implements the Fillhole algorithm. Since it is a dual, it is
somewhat superfluous but is provided as a convenience.
Geodesic morphology and the Fillhole algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.
See:
GrayscaleGeodesicDilateImageFilter
MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
GrayscaleGrindPeak for the procedural interface
itk::GrayscaleGrindPeakImageFilter for the Doxygen on the original ITK class.
GrayscaleGrindPeakImageFilter}
%C++ includes: sitkGrayscaleGrindPeakImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ GrayscaleGrindPeakImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GrayscaleGrindPeakImageFilter():}{
Destructor
}
}
}
