/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.tools.api.impl;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSortedSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.internal.tools.api.impl.AccessibleMember;
import org.gradle.internal.tools.api.impl.AnnotationMember;
import org.jspecify.annotations.Nullable;

public abstract class AnnotatableMember
extends AccessibleMember {
    private final SortedSet<AnnotationMember> annotations = new TreeSet<AnnotationMember>();
    private final @Nullable String signature;

    public AnnotatableMember(int access, String name, @Nullable String signature) {
        super(access, name);
        this.signature = signature;
    }

    public SortedSet<AnnotationMember> getAnnotations() {
        return ImmutableSortedSet.copyOf(this.annotations);
    }

    public void addAnnotation(AnnotationMember annotationMember) {
        this.annotations.add(annotationMember);
    }

    public @Nullable String getSignature() {
        return this.signature;
    }

    protected ComparisonChain compare(AnnotatableMember o) {
        return super.compare(o).compare((Comparable)((Object)(this.signature == null ? "" : this.signature)), (Comparable)((Object)(o.signature == null ? "" : o.signature)));
    }
}

