/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jvm.analysis.quickFix.RenameQuickFix;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/execution/junit/codeInspection/RemoveAnnotationAndPrefixQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "annotation", "Lcom/intellij/lang/jvm/JvmAnnotation;", "prefix", "", "capitalize", "", "<init>", "(Lcom/intellij/lang/jvm/JvmAnnotation;Ljava/lang/String;Z)V", "annotationPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiAnnotation;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getAnnotationPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getFamilyName", "startInWriteAction", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyFix", "", "descriptor", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnitMixedFrameworkInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitMixedFrameworkInspection.kt\ncom/intellij/execution/junit/codeInspection/RemoveAnnotationAndPrefixQuickFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 4 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,185:1\n19#2:186\n171#3:187\n18#4:188\n66#5,2:189\n*S KotlinDebug\n*F\n+ 1 JUnitMixedFrameworkInspection.kt\ncom/intellij/execution/junit/codeInspection/RemoveAnnotationAndPrefixQuickFix\n*L\n151#1:186\n159#1:187\n160#1:188\n170#1:189,2\n*E\n"})
final class RemoveAnnotationAndPrefixQuickFix
implements LocalQuickFix {
    @NotNull
    private final String prefix;
    private final boolean capitalize;
    @NotNull
    private final SmartPsiElementPointer<PsiAnnotation> annotationPointer;

    public RemoveAnnotationAndPrefixQuickFix(@NotNull JvmAnnotation annotation, @NotNull String prefix, boolean capitalize) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.capitalize = capitalize;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)((PsiAnnotation)annotation)));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.annotationPointer = smartPsiElementPointer;
    }

    public /* synthetic */ RemoveAnnotationAndPrefixQuickFix(JvmAnnotation jvmAnnotation, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(jvmAnnotation, string, bl);
    }

    @NotNull
    public final SmartPsiElementPointer<PsiAnnotation> getAnnotationPointer() {
        return this.annotationPointer;
    }

    @NotNull
    public String getFamilyName() {
        Object object;
        Object[] objectArray = new Object[1];
        PsiElement $this$asSafely$iv = this.annotationPointer.getElement();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof JvmAnnotation)) {
            psiElement = null;
        }
        objectArray[0] = (object = (JvmAnnotation)psiElement) != null && (object = object.getQualifiedName()) != null ? StringsKt.substringAfterLast$default((String)object, (String)".", null, (int)2, null) : null;
        String string = CommonQuickFixBundle.message((String)"fix.remove.annotation.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        void $this$toUElementOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.annotationPointer.getElement();
        PsiElement psiElement = PsiTreeUtil.findSameElementInCopy((PsiElement)(psiAnnotation != null ? psiAnnotation.getNavigationElement() : null), (PsiFile)previewDescriptor.getPsiElement().getContainingFile());
        boolean $i$f$toUElementOfType = false;
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UAnnotation.class);
        if (uAnnotation == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        UAnnotation annotation = uAnnotation;
        UElement $this$getParentOfType_u24default$iv = (UElement)annotation;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
        Object object = method;
        boolean bl = object != null && (object = object.getName()) != null ? !StringsKt.startsWith$default((String)object, (String)this.prefix, (boolean)false, (int)2, null) : false;
        if (bl) {
            new RenameQuickFix((PsiElement)method.getJavaPsi(), this.prefix + this.capitalize(method.getName())).generatePreview(project, previewDescriptor);
        }
        PsiElement psiElement2 = annotation.getSourcePsi();
        if (psiElement2 != null) {
            psiElement2.delete();
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.annotationPointer.getElement();
        if (psiAnnotation == null) {
            return;
        }
        PsiAnnotation annotation = psiAnnotation;
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)annotation;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiMethod.class, (boolean)true);
        Object object = method;
        boolean bl = object != null && (object = object.getName()) != null ? !StringsKt.startsWith$default((String)object, (String)this.prefix, (boolean)false, (int)2, null) : false;
        if (bl) {
            PsiElement psiElement = (PsiElement)method;
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            new RenameQuickFix(psiElement, this.prefix + this.capitalize(string)).applyFix(project, descriptor);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)annotation)) {
            return;
        }
        ActionsKt.runWriteAction(() -> RemoveAnnotationAndPrefixQuickFix.applyFix$lambda$0(annotation));
    }

    /*
     * WARNING - void declaration
     */
    private final String capitalize(String $this$capitalize) {
        String string;
        if (this.capitalize) {
            String string2 = $this$capitalize;
            if (((CharSequence)string2).length() > 0) {
                String string3;
                void it;
                char c = string2.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string3 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string3 = String.valueOf((char)it);
                }
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                String string4 = string2;
                int n = 1;
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                string = stringBuilder2.append(string5).toString();
            } else {
                string = string2;
            }
        } else {
            string = $this$capitalize;
        }
        return string;
    }

    private static final Unit applyFix$lambda$0(PsiAnnotation $annotation) {
        $annotation.delete();
        return Unit.INSTANCE;
    }
}

