/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BlockClosed;
import jetbrains.buildServer.messages.serviceMessages.BlockOpened;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.CompilationFinished;
import jetbrains.buildServer.messages.serviceMessages.CompilationStarted;
import jetbrains.buildServer.messages.serviceMessages.InternalErrorMessage;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.RemoteArtifactMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestNavigationInfo;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceMessagesParser {
    private boolean myValidateRequiredAttributes = true;
    private final Map<String, Class<? extends ServiceMessage>> myServiceMessageTypes = SERVICE_MESSAGE_CLASSES;
    @NotNull
    private static final Map<String, Class<? extends ServiceMessage>> SERVICE_MESSAGE_CLASSES = new HashMap<String, Class<? extends ServiceMessage>>();

    public void setValidateRequiredAttributes(boolean validateRequiredAttributes) {
        this.myValidateRequiredAttributes = validateRequiredAttributes;
    }

    public void parse(@NotNull String text, @NotNull ServiceMessageParserCallback parserCallback) {
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(0);
        }
        if (parserCallback == null) {
            ServiceMessagesParser.$$$reportNull$$$0(1);
        }
        int idx = 0;
        while (idx < text.length()) {
            int messageBodyStartPos;
            int messageEndPos;
            int messageStartPos = text.indexOf("##teamcity[", idx);
            if (messageStartPos == -1) {
                parserCallback.regularText(text.substring(idx));
                return;
            }
            if (messageStartPos > idx) {
                parserCallback.regularText(text.substring(idx, messageStartPos));
            }
            if ((messageEndPos = ServiceMessagesParser.findUnescapedChar(text, ']', messageBodyStartPos = messageStartPos + "##teamcity[".length())) == -1) {
                String rest = text.substring(messageStartPos);
                parserCallback.parseException(new ParseException("The service message is invalid because it does not end with ] character: " + rest, 0), rest);
                return;
            }
            try {
                int nameEndIdx = ServiceMessagesParser.findWhiteSpaceChar(text, messageBodyStartPos, messageEndPos);
                String name = nameEndIdx == -1 ? text.substring(messageBodyStartPos, messageEndPos) : text.substring(messageBodyStartPos, nameEndIdx);
                String args = nameEndIdx == -1 ? null : text.substring(nameEndIdx + 1, messageEndPos).trim();
                parserCallback.serviceMessage(this.doParse(name, args));
            }
            catch (ParseException e2) {
                parserCallback.parseException(e2, text.substring(messageStartPos, messageEndPos + 1));
            }
            idx = messageEndPos + 1;
        }
    }

    private static int findUnescapedChar(@NotNull String text, char c, int startPos) {
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(2);
        }
        int pos = startPos;
        char escapeCharacter = MapSerializerUtil.STD_ESCAPER2.escapeCharacter();
        while ((pos = text.indexOf(c, pos + 1)) != -1 && text.charAt(pos - 1) == escapeCharacter) {
        }
        return pos;
    }

    @NotNull
    private ServiceMessage doParse(@NotNull String name, @Nullable String arguments) throws ParseException {
        ServiceMessage serviceMessage;
        if (name == null) {
            ServiceMessagesParser.$$$reportNull$$$0(3);
        }
        Class<? extends ServiceMessage> clazz = this.myServiceMessageTypes.get(name);
        try {
            ServiceMessage msg = clazz == null ? new ServiceMessage() : clazz.newInstance();
            msg.init(name, arguments);
            if (this.myValidateRequiredAttributes) {
                msg.validate();
            }
            serviceMessage = msg;
        }
        catch (InstantiationException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        if (serviceMessage == null) {
            ServiceMessagesParser.$$$reportNull$$$0(4);
        }
        return serviceMessage;
    }

    private static int findWhiteSpaceChar(@NotNull String text, int startPos, int endPos) {
        if (text == null) {
            ServiceMessagesParser.$$$reportNull$$$0(5);
        }
        for (int i2 = startPos; i2 < endPos; ++i2) {
            if (!Character.isWhitespace(text.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    static {
        SERVICE_MESSAGE_CLASSES.put("progressMessage", ProgressMessage.class);
        SERVICE_MESSAGE_CLASSES.put("progressStart", ProgressStart.class);
        SERVICE_MESSAGE_CLASSES.put("progressFinish", ProgressFinish.class);
        SERVICE_MESSAGE_CLASSES.put("publishArtifacts", PublishArtifacts.class);
        SERVICE_MESSAGE_CLASSES.put("remoteArtifact", RemoteArtifactMessage.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteStarted", TestSuiteStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteFinished", TestSuiteFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testStarted", TestStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testFailed", TestFailed.class);
        SERVICE_MESSAGE_CLASSES.put("testFinished", TestFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testIgnored", TestIgnored.class);
        SERVICE_MESSAGE_CLASSES.put("testStdOut", TestStdOut.class);
        SERVICE_MESSAGE_CLASSES.put("testStdErr", TestStdErr.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatus", BuildStatus.class);
        SERVICE_MESSAGE_CLASSES.put("buildNumber", BuildNumber.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatisticValue", BuildStatisticValue.class);
        SERVICE_MESSAGE_CLASSES.put("testNavigationInfo", TestNavigationInfo.class);
        SERVICE_MESSAGE_CLASSES.put("blockOpened", BlockOpened.class);
        SERVICE_MESSAGE_CLASSES.put("blockClosed", BlockClosed.class);
        SERVICE_MESSAGE_CLASSES.put("compilationStarted", CompilationStarted.class);
        SERVICE_MESSAGE_CLASSES.put("compilationFinished", CompilationFinished.class);
        SERVICE_MESSAGE_CLASSES.put("message", Message.class);
        SERVICE_MESSAGE_CLASSES.put("internalError", InternalErrorMessage.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUnescapedChar";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findWhiteSpaceChar";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

