/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public final class GrCopyStringConcatenationContentIntention
extends PsiBasedModCommandAction<GrExpression> {
    public GrCopyStringConcatenationContentIntention() {
        super(GrExpression.class);
    }

    protected boolean isElementApplicable(@NotNull GrExpression element, @NotNull ActionContext context) {
        GrLiteral literal;
        if (element == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(1);
        }
        if (element instanceof GrLiteral && (literal = (GrLiteral)element).getValue() instanceof String) {
            return true;
        }
        if (!(element instanceof GrBinaryExpression)) {
            return false;
        }
        GrBinaryExpression binOp = (GrBinaryExpression)element;
        if (binOp.getOperationTokenType() != GroovyTokenTypes.mPLUS) {
            return false;
        }
        GrExpression left = binOp.getLeftOperand();
        GrExpression right = binOp.getRightOperand();
        return right != null && this.isElementApplicable(left, context) && this.isElementApplicable(right, context);
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull GrExpression element) {
        if (context == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        GrCopyStringConcatenationContentIntention.getValue(element, buffer);
        ModCommand modCommand = ModCommand.copyToClipboard((String)buffer.toString());
        if (modCommand == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(4);
        }
        return modCommand;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull GrExpression element) {
        if (context == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(6);
        }
        if (element instanceof GrLiteral) {
            return Presentation.of((String)GroovyIntentionsBundle.message("gr.copy.string.literal.content.intention.text", new Object[0]));
        }
        return super.getPresentation(context, (PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("gr.copy.string.concatenation.content.intention.family.name", new Object[0]);
        if (string == null) {
            GrCopyStringConcatenationContentIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void getValue(PsiElement element, StringBuilder buffer) {
        if (element instanceof GrLiteral) {
            GrLiteral literal = (GrLiteral)element;
            buffer.append(literal.getValue());
        } else if (element instanceof GrBinaryExpression) {
            GrBinaryExpression binOp = (GrBinaryExpression)element;
            GrCopyStringConcatenationContentIntention.getValue(binOp.getLeftOperand(), buffer);
            GrCopyStringConcatenationContentIntention.getValue(binOp.getRightOperand(), buffer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/other/GrCopyStringConcatenationContentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/other/GrCopyStringConcatenationContentIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isElementApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

