/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.SingleColumnHeaderAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class RenameColumnAction
extends SingleColumnHeaderAction {
    public RenameColumnAction() {
        super(true);
    }

    @Override
    protected void update(AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        if (grid == null) {
            RenameColumnAction.$$$reportNull$$$0(0);
        }
        if (columnIdxs == null) {
            RenameColumnAction.$$$reportNull$$$0(1);
        }
        GridDataHookUp hookUp = grid.getDataHookup();
        e.getPresentation().setEnabledAndVisible(columnIdxs.size() == 1 && ((ModelIndex)columnIdxs.first()).isValid((CoreGrid)grid) && (grid.getDataSupport().isInsertedColumn((ModelIndex)columnIdxs.first()) || hookUp instanceof CsvDocumentDataHookUp));
    }

    @Override
    protected void actionPerformed(AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            RenameColumnAction.$$$reportNull$$$0(2);
        }
        if (columnIdx == null) {
            RenameColumnAction.$$$reportNull$$$0(3);
        }
        NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel();
        JTextField nameField = contentPanel.getTextField();
        GridColumn column = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        if (column == null) {
            return;
        }
        String name = column.getName();
        nameField.setText(name);
        nameField.selectAll();
        JBPopup popup = NewItemPopupUtil.createNewItemPopup((String)DataGridBundle.message((String)"action.Console.TableResult.RenameColumn.text", (Object[])new Object[0]), (JComponent)contentPanel, (JComponent)nameField);
        contentPanel.setApplyAction(event -> {
            String newName = nameField.getText();
            if (StringUtil.isEmptyOrSpaces((String)newName)) {
                return;
            }
            popup.closeOk(event);
            RenameColumnAction.renameColumn(grid, columnIdx, newName);
        });
        popup.showCenteredInCurrentWindow(grid.getProject());
    }

    private static void renameColumn(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> idx, @NotNull String name) {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
        if (grid == null) {
            RenameColumnAction.$$$reportNull$$$0(4);
        }
        if (idx == null) {
            RenameColumnAction.$$$reportNull$$$0(5);
        }
        if (name == null) {
            RenameColumnAction.$$$reportNull$$$0(6);
        }
        if ((mutator = GridUtil.getColumnsMutator(grid)) == null) {
            return;
        }
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid));
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.renameColumn(source, idx, name));
            return;
        }
        mutator.renameColumn(source, idx, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdxs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/RenameColumnAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "renameColumn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

