/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
final class SubCoverageManager {
    private static final Logger LOG = Logger.getInstance(SubCoverageManager.class);
    private boolean mySubCoverageIsActive;

    SubCoverageManager() {
    }

    public static SubCoverageManager getInstance(Project project) {
        return (SubCoverageManager)project.getService(SubCoverageManager.class);
    }

    public boolean isSubCoverageActive() {
        return this.mySubCoverageIsActive;
    }

    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            SubCoverageManager.$$$reportNull$$$0(0);
        }
        this.mySubCoverageIsActive = false;
        suite.restoreCoverageData();
    }

    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        if (suite == null) {
            SubCoverageManager.$$$reportNull$$$0(1);
        }
        suite.restoreCoverageData();
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        this.mySubCoverageIsActive = true;
        HashMap<String, Set<Integer>> executionTrace = new HashMap<String, Set<Integer>>();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            suite.getCoverageEngine().collectTestLines(testNames, coverageSuite, executionTrace);
        }
        ProjectData projectData = new ProjectData();
        for (Map.Entry entry : executionTrace.entrySet()) {
            String className = (String)entry.getKey();
            Set lineNumbers = (Set)entry.getValue();
            ClassData classData = projectData.getOrCreateClassData(className);
            ClassData oldData = data.getClassData(className);
            LOG.assertTrue(oldData != null, (Object)("missed className: \"" + className + "\""));
            Object[] oldLines = oldData.getLines();
            LOG.assertTrue(oldLines != null);
            int newLength = Math.max(oldLines.length, 1 + lineNumbers.stream().mapToInt(Integer::intValue).max().orElse(-1));
            LineData[] lines = new LineData[newLength];
            Iterator iterator = lineNumbers.iterator();
            while (iterator.hasNext()) {
                LineData oldLineData;
                int line = (Integer)iterator.next();
                String methodSig = null;
                if (line < oldLines.length && (oldLineData = oldData.getLineData(line)) != null) {
                    methodSig = oldLineData.getMethodSignature();
                }
                LineData lineData = new LineData(line, methodSig);
                if (methodSig != null) {
                    classData.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lines[line] = lineData;
            }
            classData.setLines(lines);
            classData.setFullyAnalysed(false);
        }
        suite.setCoverageData(projectData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "suite";
        objectArray2[1] = "com/intellij/coverage/SubCoverageManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreMergedCoverage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "selectSubCoverage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

