/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.infer.AttributeDecl;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.InferHandler;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.ParticleDumper;
import com.thaiopensource.xml.infer.Schema;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TestDriver {
    public static void main(String[] stringArray) throws SAXException, IOException {
        InferHandler inferHandler = new InferHandler(new DatatypeLibraryLoader());
        Jaxp11XMLReaderCreator jaxp11XMLReaderCreator = new Jaxp11XMLReaderCreator();
        XMLReader xMLReader = jaxp11XMLReaderCreator.createXMLReader();
        xMLReader.setContentHandler(inferHandler);
        int n = 0;
        while (n < stringArray.length) {
            xMLReader.parse(new InputSource(UriOrFile.toUri(stringArray[n])));
            ++n;
        }
        Schema schema = inferHandler.getSchema();
        Iterator iterator = schema.getElementDecls().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Name name = (Name)entry.getKey();
            String string = name.getNamespaceUri();
            if (!string.equals("")) {
                System.out.print("{" + string + "}");
            }
            System.out.print(name.getLocalName());
            System.out.print(" = ");
            ElementDecl elementDecl = (ElementDecl)entry.getValue();
            Particle particle = elementDecl.getContentModel();
            if (particle != null) {
                System.out.println(ParticleDumper.toString(particle, string));
            } else {
                System.out.println("xsd:" + elementDecl.getDatatype().getLocalName());
            }
            Iterator iterator2 = elementDecl.getAttributeDecls().entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                System.out.print("  @");
                AttributeDecl attributeDecl = (AttributeDecl)entry2.getValue();
                Name name2 = (Name)entry2.getKey();
                string = name2.getNamespaceUri();
                if (!string.equals("")) {
                    System.out.print("{" + string + "}");
                }
                System.out.print(name2.getLocalName());
                Name name3 = attributeDecl.getDatatype();
                if (name3 == null) {
                    System.out.print(" string");
                } else {
                    System.out.print(" xsd:" + name3.getLocalName());
                }
                if (attributeDecl.isOptional()) {
                    System.out.println(" optional");
                    continue;
                }
                System.out.println(" required");
            }
        }
    }
}

