/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.completion.engine;

import com.intellij.terminal.completion.engine.ShellCommandTreeNode;
import com.intellij.terminal.completion.spec.ShellCommandParserOptions;
import com.intellij.terminal.completion.spec.ShellCommandSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/terminal/completion/engine/ShellCommandNode;", "Lcom/intellij/terminal/completion/engine/ShellCommandTreeNode;", "Lcom/intellij/terminal/completion/spec/ShellCommandSpec;", "text", "", "spec", "parent", "<init>", "(Ljava/lang/String;Lcom/intellij/terminal/completion/spec/ShellCommandSpec;Lcom/intellij/terminal/completion/engine/ShellCommandTreeNode;)V", "getSpec", "()Lcom/intellij/terminal/completion/spec/ShellCommandSpec;", "getMergedParserOptions", "Lcom/intellij/terminal/completion/spec/ShellCommandParserOptions;", "mergeParserOptions", "base", "child", "intellij.terminal.completion"})
@SourceDebugExtension(value={"SMAP\nShellCommandTokenNodes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandTokenNodes.kt\ncom/intellij/terminal/completion/engine/ShellCommandNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n2783#2,7:58\n*S KotlinDebug\n*F\n+ 1 ShellCommandTokenNodes.kt\ncom/intellij/terminal/completion/engine/ShellCommandNode\n*L\n27#1:58,7\n*E\n"})
public final class ShellCommandNode
extends ShellCommandTreeNode<ShellCommandSpec> {
    @NotNull
    private final ShellCommandSpec spec;

    public ShellCommandNode(@NotNull String text, @NotNull ShellCommandSpec spec, @Nullable ShellCommandTreeNode<?> parent) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        super(text, spec, parent);
        this.spec = spec;
    }

    @Override
    @NotNull
    public ShellCommandSpec getSpec() {
        return this.spec;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShellCommandParserOptions getMergedParserOptions() {
        List directives = new ArrayList();
        directives.add(this.getSpec().getParserOptions());
        ShellCommandTreeNode<?> cur = this.getParent();
        while (cur instanceof ShellCommandNode) {
            directives.add(((ShellCommandNode)cur).getSpec().getParserOptions());
            cur = ((ShellCommandNode)cur).getParent();
        }
        Iterable $this$reduce$iv = CollectionsKt.asReversedMutable((List)directives);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void child;
            ShellCommandParserOptions shellCommandParserOptions = (ShellCommandParserOptions)iterator$iv.next();
            ShellCommandParserOptions base = (ShellCommandParserOptions)accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.mergeParserOptions(base, (ShellCommandParserOptions)child);
        }
        return (ShellCommandParserOptions)accumulator$iv;
    }

    private final ShellCommandParserOptions mergeParserOptions(ShellCommandParserOptions base, ShellCommandParserOptions child) {
        boolean flagsArePosixNonCompliant = child.getFlagsArePosixNonCompliant() ? true : base.getFlagsArePosixNonCompliant();
        boolean optionsMustPrecedeArguments = child.getOptionsMustPrecedeArguments() ? true : base.getOptionsMustPrecedeArguments();
        List optionArgSeparators = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)base.getOptionArgSeparators(), (Iterable)child.getOptionArgSeparators()));
        return ShellCommandParserOptions.Companion.create(flagsArePosixNonCompliant, optionsMustPrecedeArguments, optionArgSeparators);
    }
}

