/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.cache;

import java.io.File;
import java.util.ArrayList;
import tim.prune.fileutils.FileList;
import tim.prune.function.cache.RowInfo;
import tim.prune.function.cache.TileSet;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;

public class TileCacheModel {
    private final File _cacheDir;
    private ArrayList<TileSet> _tileSets = null;
    private RowInfo _summaryRow = null;
    private boolean _cancelled = false;

    public TileCacheModel(File file) {
        this._cacheDir = file != null && file.exists() && file.isDirectory() && file.canRead() ? file : null;
    }

    public void buildTileSets() {
        if (this._cacheDir == null) {
            return;
        }
        this._tileSets = new ArrayList();
        File[] fileArray = FileList.filesIn(this._cacheDir);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File object = fileArray[n2];
            if (object != null && object.isDirectory() && object.exists() && object.canRead() && !this._cancelled) {
                TileCacheModel.getTileSets(object, null, this._tileSets);
            }
            ++n2;
        }
        this._summaryRow = new RowInfo();
        for (TileSet tileSet : this._tileSets) {
            this._summaryRow.addRow(tileSet.getRowInfo());
        }
    }

    private static void getTileSets(File file, String string, ArrayList<TileSet> arrayList) {
        Object object;
        String string2 = String.valueOf(string == null ? "" : string) + file.getName() + File.separator;
        String string3 = TileCacheModel.matchConfig(string2);
        boolean bl = false;
        if (string3 != null || TileCacheModel.looksLikeCacheDir(file)) {
            object = new TileSet(file, string2, string3);
            if (string3 != null || ((TileSet)object).getRowInfo().getNumTiles() > 0) {
                bl = true;
                arrayList.add((TileSet)object);
            }
        }
        if (!bl) {
            File[] fileArray = FileList.filesIn(file);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                if (object != null && ((File)object).exists() && ((File)object).isDirectory() && ((File)object).canRead()) {
                    TileCacheModel.getTileSets((File)object, string2, arrayList);
                }
                ++n2;
            }
        }
    }

    private static String matchConfig(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < MapSourceLibrary.getNumSources()) {
            MapSource mapSource = MapSourceLibrary.getSource(n);
            int n2 = 0;
            while (n2 < 2) {
                String string2 = mapSource.getSiteName(n2);
                if (string2 != null && string2.equals(string)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(mapSource.getName());
                }
                ++n2;
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private static boolean looksLikeCacheDir(File file) {
        boolean bl = false;
        if (file != null && file.exists() && file.isDirectory() && file.canRead()) {
            File[] fileArray = FileList.filesIn(file);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2 != null && file2.exists() && file2.canRead()) {
                    if (file2.isDirectory() && TileSet.isNumeric(file2.getName()) && file2.getName().length() < 3) {
                        bl = true;
                    } else {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return bl;
    }

    public File getCacheDir() {
        return this._cacheDir;
    }

    public int getNumTileSets() {
        if (this._tileSets == null) {
            return 0;
        }
        return this._tileSets.size();
    }

    public int getTotalTiles() {
        return this._summaryRow.getNumTiles();
    }

    public TileSet getTileSet(int n) {
        if (n >= 0 && n < this.getNumTileSets()) {
            return this._tileSets.get(n);
        }
        return null;
    }

    public void cancel() {
        this._cancelled = true;
    }

    public boolean isAborted() {
        return this._cancelled;
    }
}

