/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.util.ArrayUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiUtilEx {
    private PsiUtilEx() {
    }

    @Nullable
    public static PsiParameter getParameterForArgument(PsiElement element) {
        PsiCallExpression call;
        PsiMethod method;
        PsiElement p = element.getParent();
        if (!(p instanceof PsiExpressionList)) {
            return null;
        }
        PsiExpressionList list = (PsiExpressionList)p;
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiCallExpression)) {
            return null;
        }
        Object[] arguments = list.getExpressions();
        int i = ArrayUtil.indexOf((Object[])arguments, (Object)element);
        if (i != -1 && (method = (call = (PsiCallExpression)parent).resolveMethod()) != null) {
            PsiParameter lastParam;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length > i) {
                return parameters[i];
            }
            if (parameters.length > 0 && (lastParam = parameters[parameters.length - 1]).getType() instanceof PsiEllipsisType) {
                return lastParam;
            }
        }
        return null;
    }

    public static boolean isStringOrCharacterLiteral(PsiElement place) {
        return place instanceof PsiLiteralExpression && PsiUtil.isJavaToken((PsiElement)place.getFirstChild(), (TokenSet)ElementType.TEXT_LITERALS);
    }

    public static boolean isString(@NotNull PsiType type) {
        String shortName;
        if (type == null) {
            PsiUtilEx.$$$reportNull$$$0(0);
        }
        if (type instanceof PsiClassType && !Objects.equals(shortName = ((PsiClassType)type).getClassName(), "String")) {
            return false;
        }
        return "java.lang.String".equals(type.getCanonicalText(false));
    }

    public static boolean isInjectionTargetType(@NotNull PsiType type) {
        if (type == null) {
            PsiUtilEx.$$$reportNull$$$0(1);
        }
        return PsiUtilEx.isStringOrStringArray(type) || InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.StringTemplate.Processor");
    }

    public static boolean isStringOrStringArray(@NotNull PsiType type) {
        if (type == null) {
            PsiUtilEx.$$$reportNull$$$0(2);
        }
        if (type instanceof PsiArrayType) {
            return PsiUtilEx.isString(((PsiArrayType)type).getComponentType());
        }
        return PsiUtilEx.isString(type);
    }

    public static Document createDocument(String s, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() || project.isDefault()) {
            return new DocumentImpl(s);
        }
        return JavaReferenceEditorUtil.createTypeDocument((String)s, (Project)project);
    }

    public static boolean isLanguageAnnotationTarget(PsiModifierListOwner owner) {
        if (owner instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)owner).getReturnType();
            if (returnType == null || !PsiUtilEx.isInjectionTargetType(returnType)) {
                return false;
            }
        } else if (owner instanceof PsiVariable) {
            PsiType type = ((PsiVariable)owner).getType();
            if (!PsiUtilEx.isInjectionTargetType(type)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "type";
        objectArray2[1] = "org/intellij/plugins/intelliLang/util/PsiUtilEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectionTargetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringOrStringArray";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

