/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.animation;

import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.animation.AnimationExtension;
import org.openstreetmap.josm.gui.animation.BirthdayExtension;
import org.openstreetmap.josm.gui.animation.ChristmasExtension;
import org.openstreetmap.josm.gui.animation.NoExtension;

public final class AnimationExtensionManager {
    private static volatile AnimationExtension currentExtension;
    private static final BooleanProperty PROP_ANIMATION;

    private AnimationExtensionManager() {
    }

    public static AnimationExtension getExtension() {
        if (currentExtension == null) {
            boolean isAnimated = Boolean.TRUE.equals(PROP_ANIMATION.get());
            currentExtension = isAnimated && AnimationExtensionManager.isChristmas() ? new ChristmasExtension() : (isAnimated && AnimationExtensionManager.isBirthday() ? new BirthdayExtension() : new NoExtension());
        }
        return currentExtension;
    }

    public static boolean isExtensionEnabled() {
        return !(AnimationExtensionManager.getExtension() instanceof NoExtension);
    }

    private static boolean isChristmas() {
        return LocalDate.now(ZoneId.systemDefault()).getDayOfYear() > 350;
    }

    private static boolean isBirthday() {
        LocalDate l = LocalDate.now(ZoneId.systemDefault());
        return l.getMonth() == Month.SEPTEMBER && l.getDayOfMonth() == 27;
    }

    static {
        PROP_ANIMATION = new BooleanProperty("gui.start.animation", true);
    }
}

