//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_IMAGING_GEOM_MODEL_SCHEMA_H
#define PXR_USD_IMAGING_USD_IMAGING_GEOM_MODEL_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_IMAGING_GEOM_MODEL_SCHEMA_TOKENS \
    (geomModel) \
    (drawMode) \
    (applyDrawMode) \
    (drawModeColor) \
    (cardGeometry) \
    (cardTextureXPos) \
    (cardTextureYPos) \
    (cardTextureZPos) \
    (cardTextureXNeg) \
    (cardTextureYNeg) \
    (cardTextureZNeg) \
    ((default_, "default")) \
    (origin) \
    (bounds) \
    (cards) \
    (inherited) \
    (cross) \
    (box) \
    (fromTexture) \

TF_DECLARE_PUBLIC_TOKENS(UsdImagingGeomModelSchemaTokens, USDIMAGING_API,
    USD_IMAGING_GEOM_MODEL_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class UsdImagingGeomModelSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdImagingGeomModelSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "geomModel" from the parent container and constructs a
    /// UsdImagingGeomModelSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDIMAGING_API
    static UsdImagingGeomModelSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    USDIMAGING_API
    HdTokenDataSourceHandle GetDrawMode() const;

    USDIMAGING_API
    HdBoolDataSourceHandle GetApplyDrawMode() const;

    USDIMAGING_API
    HdVec3fDataSourceHandle GetDrawModeColor() const;

    USDIMAGING_API
    HdTokenDataSourceHandle GetCardGeometry() const;

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureXPos() const;

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureYPos() const;

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureZPos() const;

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureXNeg() const;

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureYNeg() const;

    USDIMAGING_API
    HdAssetPathDataSourceHandle GetCardTextureZNeg() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate drawMode.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDrawModeLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &drawMode,
        const HdBoolDataSourceHandle &applyDrawMode,
        const HdVec3fDataSourceHandle &drawModeColor,
        const HdTokenDataSourceHandle &cardGeometry,
        const HdAssetPathDataSourceHandle &cardTextureXPos,
        const HdAssetPathDataSourceHandle &cardTextureYPos,
        const HdAssetPathDataSourceHandle &cardTextureZPos,
        const HdAssetPathDataSourceHandle &cardTextureXNeg,
        const HdAssetPathDataSourceHandle &cardTextureYNeg,
        const HdAssetPathDataSourceHandle &cardTextureZNeg
    );

    /// \class UsdImagingGeomModelSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDIMAGING_API
        Builder &SetDrawMode(
            const HdTokenDataSourceHandle &drawMode);
        USDIMAGING_API
        Builder &SetApplyDrawMode(
            const HdBoolDataSourceHandle &applyDrawMode);
        USDIMAGING_API
        Builder &SetDrawModeColor(
            const HdVec3fDataSourceHandle &drawModeColor);
        USDIMAGING_API
        Builder &SetCardGeometry(
            const HdTokenDataSourceHandle &cardGeometry);
        USDIMAGING_API
        Builder &SetCardTextureXPos(
            const HdAssetPathDataSourceHandle &cardTextureXPos);
        USDIMAGING_API
        Builder &SetCardTextureYPos(
            const HdAssetPathDataSourceHandle &cardTextureYPos);
        USDIMAGING_API
        Builder &SetCardTextureZPos(
            const HdAssetPathDataSourceHandle &cardTextureZPos);
        USDIMAGING_API
        Builder &SetCardTextureXNeg(
            const HdAssetPathDataSourceHandle &cardTextureXNeg);
        USDIMAGING_API
        Builder &SetCardTextureYNeg(
            const HdAssetPathDataSourceHandle &cardTextureYNeg);
        USDIMAGING_API
        Builder &SetCardTextureZNeg(
            const HdAssetPathDataSourceHandle &cardTextureZNeg);

        /// Returns a container data source containing the members set thus far.
        USDIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _drawMode;
        HdBoolDataSourceHandle _applyDrawMode;
        HdVec3fDataSourceHandle _drawModeColor;
        HdTokenDataSourceHandle _cardGeometry;
        HdAssetPathDataSourceHandle _cardTextureXPos;
        HdAssetPathDataSourceHandle _cardTextureYPos;
        HdAssetPathDataSourceHandle _cardTextureZPos;
        HdAssetPathDataSourceHandle _cardTextureXNeg;
        HdAssetPathDataSourceHandle _cardTextureYNeg;
        HdAssetPathDataSourceHandle _cardTextureZNeg;

    };

    /// Returns token data source for use as drawMode value.
    ///
    /// The following values will be stored statically and reused for future
    /// calls:
    /// - UsdImagingGeomModelSchemaTokens->default_
    /// - UsdImagingGeomModelSchemaTokens->origin
    /// - UsdImagingGeomModelSchemaTokens->bounds
    /// - UsdImagingGeomModelSchemaTokens->cards
    /// - UsdImagingGeomModelSchemaTokens->inherited
    USDIMAGING_API
    static HdTokenDataSourceHandle BuildDrawModeDataSource(
        const TfToken &drawMode);

    /// Returns token data source for use as cardGeometry value.
    ///
    /// The following values will be stored statically and reused for future
    /// calls:
    /// - UsdImagingGeomModelSchemaTokens->cross
    /// - UsdImagingGeomModelSchemaTokens->box
    /// - UsdImagingGeomModelSchemaTokens->fromTexture
    USDIMAGING_API
    static HdTokenDataSourceHandle BuildCardGeometryDataSource(
        const TfToken &cardGeometry);

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif