/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.Pending;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.UnrecoverableExceptions;
import io.cucumber.core.runner.AmbiguousStepDefinitionsException;
import io.cucumber.core.runner.ExecutionMode;
import io.cucumber.core.runner.StepDefinitionMatch;
import io.cucumber.core.runner.TestAbortedExceptions;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.core.runner.TestStepResultStatusMapper;
import io.cucumber.core.runner.UndefinedStepDefinitionException;
import io.cucumber.messages.TimeConversion;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepStarted;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Predicate;

abstract class TestStep
implements io.cucumber.plugin.event.TestStep {
    private final Predicate<Throwable> isTestAbortedException = TestAbortedExceptions.createIsTestAbortedExceptionPredicate();
    private final StepDefinitionMatch stepDefinitionMatch;
    private final UUID id;

    TestStep(UUID id, StepDefinitionMatch stepDefinitionMatch) {
        this.id = id;
        this.stepDefinitionMatch = stepDefinitionMatch;
    }

    public String getCodeLocation() {
        return this.stepDefinitionMatch.getCodeLocation();
    }

    public UUID getId() {
        return this.id;
    }

    ExecutionMode run(TestCase testCase, EventBus bus, TestCaseState state, ExecutionMode executionMode) {
        Status status;
        Instant startTime = bus.getInstant();
        this.emitTestStepStarted(testCase, bus, state.getTestExecutionId(), startTime);
        Throwable error = null;
        try {
            status = this.executeStep(state, executionMode);
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            error = t;
            status = this.mapThrowableToStatus(t);
        }
        Instant stopTime = bus.getInstant();
        Duration duration = Duration.between(startTime, stopTime);
        Result result = this.mapStatusToResult(status, error, duration);
        state.add(result);
        this.emitTestStepFinished(testCase, bus, state.getTestExecutionId(), stopTime, duration, result);
        return result.getStatus().is(Status.PASSED) ? executionMode : ExecutionMode.SKIP;
    }

    private void emitTestStepStarted(TestCase testCase, EventBus bus, UUID textExecutionId, Instant startTime) {
        bus.send(new io.cucumber.plugin.event.TestStepStarted(startTime, testCase, (io.cucumber.plugin.event.TestStep)this));
        Envelope envelope = Envelope.of((TestStepStarted)new TestStepStarted(textExecutionId.toString(), this.id.toString(), TimeConversion.javaInstantToTimestamp((Instant)startTime)));
        bus.send(envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status executeStep(TestCaseState state, ExecutionMode executionMode) throws Throwable {
        state.setCurrentTestStepId(this.id);
        try {
            Status status = executionMode.execute(this.stepDefinitionMatch, state);
            return status;
        }
        finally {
            state.clearCurrentTestStepId();
        }
    }

    private Status mapThrowableToStatus(Throwable t) {
        if (t.getClass().isAnnotationPresent(Pending.class)) {
            return Status.PENDING;
        }
        if (this.isTestAbortedException.test(t)) {
            return Status.SKIPPED;
        }
        if (t.getClass() == UndefinedStepDefinitionException.class) {
            return Status.UNDEFINED;
        }
        if (t.getClass() == AmbiguousStepDefinitionsException.class) {
            return Status.AMBIGUOUS;
        }
        return Status.FAILED;
    }

    private Result mapStatusToResult(Status status, Throwable error, Duration duration) {
        if (status == Status.UNDEFINED) {
            return new Result(status, Duration.ZERO, null);
        }
        return new Result(status, duration, error);
    }

    private void emitTestStepFinished(TestCase testCase, EventBus bus, UUID textExecutionId, Instant stopTime, Duration duration, Result result) {
        bus.send(new TestStepFinished(stopTime, testCase, (io.cucumber.plugin.event.TestStep)this, result));
        TestStepResult testStepResult = new TestStepResult(TimeConversion.javaDurationToDuration((Duration)duration), result.getError() != null ? this.extractStackTrace(result.getError()) : null, TestStepResultStatusMapper.from(result.getStatus()));
        Envelope envelope = Envelope.of((io.cucumber.messages.types.TestStepFinished)new io.cucumber.messages.types.TestStepFinished(textExecutionId.toString(), this.id.toString(), testStepResult, TimeConversion.javaInstantToTimestamp((Instant)stopTime)));
        bus.send(envelope);
    }

    private String extractStackTrace(Throwable error) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(s);
        error.printStackTrace(printStream);
        return new String(s.toByteArray(), StandardCharsets.UTF_8);
    }
}

