/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.streaming.FlushMode;
import org.opensearch.search.streaming.FlushModeResolver;

@ExperimentalApi
public final class AggregatorTreeEvaluator {
    private AggregatorTreeEvaluator() {
    }

    public static Collector evaluateAndRecreateIfNeeded(Collector collector, SearchContext searchContext, CheckedFunction<SearchContext, List<Aggregator>, IOException> aggProvider) throws IOException {
        if (!searchContext.isStreamSearch()) {
            return collector;
        }
        FlushMode flushMode = AggregatorTreeEvaluator.getFlushMode(collector, searchContext);
        if (flushMode == FlushMode.PER_SEGMENT) {
            return collector;
        }
        return MultiBucketCollector.wrap((Iterable)aggProvider.apply((Object)searchContext));
    }

    private static FlushMode getFlushMode(Collector collector, SearchContext searchContext) {
        long minBucketCount;
        double minCardinalityRatio;
        FlushMode cached = searchContext.getFlushMode();
        if (cached != null) {
            return cached;
        }
        long maxBucketCount = searchContext.getStreamingMaxEstimatedBucketCount();
        FlushMode mode = FlushModeResolver.resolve(collector, FlushMode.PER_SHARD, maxBucketCount, minCardinalityRatio = searchContext.getStreamingMinCardinalityRatio(), minBucketCount = searchContext.getStreamingMinEstimatedBucketCount());
        if (!searchContext.setFlushModeIfAbsent(mode)) {
            FlushMode existingMode = searchContext.getFlushMode();
            return existingMode != null ? existingMode : mode;
        }
        return mode;
    }
}

