/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.analysis.icu;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.index.analysis.AnalyzerProvider;
import org.opensearch.index.analysis.CharFilterFactory;
import org.opensearch.index.analysis.IcuAnalyzerProvider;
import org.opensearch.index.analysis.IcuCollationTokenFilterFactory;
import org.opensearch.index.analysis.IcuFoldingTokenFilterFactory;
import org.opensearch.index.analysis.IcuNormalizerCharFilterFactory;
import org.opensearch.index.analysis.IcuNormalizerTokenFilterFactory;
import org.opensearch.index.analysis.IcuTokenizerFactory;
import org.opensearch.index.analysis.IcuTransformTokenFilterFactory;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.index.mapper.ICUCollationKeywordFieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.search.DocValueFormat;

public class AnalysisICUPlugin
extends Plugin
implements AnalysisPlugin,
MapperPlugin {
    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Collections.singletonMap("icu_normalizer", IcuNormalizerCharFilterFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        extra.put("icu_normalizer", IcuNormalizerTokenFilterFactory::new);
        extra.put("icu_folding", IcuFoldingTokenFilterFactory::new);
        extra.put("icu_collation", IcuCollationTokenFilterFactory::new);
        extra.put("icu_transform", IcuTransformTokenFilterFactory::new);
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.singletonMap("icu_analyzer", IcuAnalyzerProvider::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.singletonMap("icu_tokenizer", IcuTokenizerFactory::new);
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("icu_collation_keyword", new ICUCollationKeywordFieldMapper.TypeParser());
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.singletonList(new NamedWriteableRegistry.Entry(DocValueFormat.class, ICUCollationKeywordFieldMapper.CollationFieldType.COLLATE_FORMAT.getWriteableName(), in -> ICUCollationKeywordFieldMapper.CollationFieldType.COLLATE_FORMAT));
    }
}

