/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;

@InterfaceStability.Unstable
public class StreamsResetter {
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_ERROR = 1;
    private static final String USAGE = "This tool helps to quickly reset an application in order to reprocess its data from scratch.\n* This tool resets offsets of input topics to the earliest available offset (by default), or to a specific defined position* This tool deletes the internal topics that were created by Kafka Streams (topics starting with \"<application.id>-\").\nThe tool finds these internal topics automatically. If the topics flagged automatically for deletion by the dry-run are unsuitable, you can specify a subset with the \"--internal-topics\" option.\n* This tool will not delete output topics (if you want to delete them, you need to do it yourself with the bin/kafka-topics.sh command).\n* This tool will not clean up the local state on the stream application instances (the persisted stores used to cache aggregation results).\nYou need to call KafkaStreams#cleanUp() in your application or manually delete them from the directory specified by \"state.dir\" configuration (${java.io.tmpdir}/kafka-streams/<application.id> by default).\n* When long session timeout has been configured, active members could take longer to get expired on the broker thus blocking the reset job to complete. Use the \"--force\" option could remove those left-over members immediately. Make sure to stop all stream applications when this option is specified to avoid unexpected disruptions.\n\n*** Important! You will get wrong output if you don't clean up the local stores after running the reset tool!\n\n*** Warning! This tool makes irreversible changes to your application. It is strongly recommended that you run this once with \"--dry-run\" to preview your changes before making them.\n\n";
    private final List<String> allTopics = new LinkedList<String>();

    public static void main(String[] args) {
        Exit.exit((int)new StreamsResetter().execute(args));
    }

    public int execute(String[] args) {
        return this.execute(args, new Properties());
    }

    public int execute(String[] args, Properties config) {
        int n;
        block13: {
            String commandConfigFile;
            StreamsResetterOptions options = new StreamsResetterOptions(args);
            String groupId = options.applicationId();
            if (options.hasConfig()) {
                System.out.println("Option --config-file has been deprecated and will be removed in a future version. Use --command-config instead.");
                commandConfigFile = options.config();
            } else {
                commandConfigFile = options.commandConfig();
            }
            Properties properties = commandConfigFile != null ? Utils.loadProps((String)commandConfigFile) : new Properties();
            String bootstrapServerValue = "localhost:9092";
            if (options.hasBootstrapServer()) {
                bootstrapServerValue = options.bootstrapServer();
            }
            properties.put("bootstrap.servers", bootstrapServerValue);
            Admin adminClient = Admin.create((Properties)properties);
            try {
                HashMap<Object, Object> consumerConfig;
                this.maybeDeleteActiveConsumers(groupId, adminClient, options);
                this.allTopics.clear();
                this.allTopics.addAll((Collection)adminClient.listTopics().names().get(60L, TimeUnit.SECONDS));
                if (options.hasDryRun()) {
                    System.out.println("----Dry run displays the actions which will be performed when running Streams Reset Tool----");
                }
                if ((consumerConfig = new HashMap<Object, Object>(config)).containsKey("group.protocol") && !consumerConfig.get("group.protocol").toString().equalsIgnoreCase(GroupProtocol.CLASSIC.name())) {
                    System.out.println("WARNING: provided group protocol will be ignored. Using supported " + GroupProtocol.CLASSIC.name() + " protocol instead");
                }
                consumerConfig.put("group.protocol", GroupProtocol.CLASSIC.name());
                consumerConfig.putAll(properties);
                int exitCode = this.maybeResetInputAndSeekToEndIntermediateTopicOffsets(consumerConfig, options);
                n = exitCode |= this.maybeDeleteInternalTopics(adminClient, options);
                if (adminClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    System.err.println("ERROR: " + String.valueOf(e));
                    e.printStackTrace(System.err);
                    return 1;
                }
            }
            adminClient.close();
        }
        return n;
    }

    private void maybeDeleteActiveConsumers(String groupId, Admin adminClient, StreamsResetterOptions options) throws ExecutionException, InterruptedException {
        block3: {
            DescribeConsumerGroupsResult describeResult = adminClient.describeConsumerGroups(Set.of(groupId), (DescribeConsumerGroupsOptions)new DescribeConsumerGroupsOptions().timeoutMs(Integer.valueOf(10000)));
            try {
                ArrayList members = new ArrayList(((ConsumerGroupDescription)((KafkaFuture)describeResult.describedGroups().get(groupId)).get()).members());
                if (members.isEmpty()) break block3;
                if (options.hasForce()) {
                    System.out.println("Force deleting all active members in the group: " + groupId);
                    adminClient.removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions()).all().get();
                    break block3;
                }
                throw new IllegalStateException("Consumer group '" + groupId + "' is still active and has following members: " + String.valueOf(members) + ". Make sure to stop all running application instances before running the reset tool. You can use option '--force' to remove active members from the group.");
            }
            catch (ExecutionException ee) {
                if (ee.getCause() instanceof GroupIdNotFoundException) break block3;
                throw ee;
            }
        }
    }

    private int maybeResetInputAndSeekToEndIntermediateTopicOffsets(Map<Object, Object> consumerConfig, StreamsResetterOptions options) throws IOException, ParseException {
        List<String> inputTopics = options.inputTopicsOption();
        List<String> intermediateTopics = options.intermediateTopicsOption();
        int topicNotFound = 0;
        ArrayList<String> notFoundInputTopics = new ArrayList<String>();
        ArrayList<String> notFoundIntermediateTopics = new ArrayList<String>();
        if (inputTopics.isEmpty() && intermediateTopics.isEmpty()) {
            System.out.println("No input or intermediate topics specified. Skipping seek.");
            return 0;
        }
        if (!inputTopics.isEmpty()) {
            System.out.println("Reset-offsets for input topics " + String.valueOf(inputTopics));
        }
        if (!intermediateTopics.isEmpty()) {
            System.out.println("Seek-to-end for intermediate topics " + String.valueOf(intermediateTopics));
        }
        HashSet<String> topicsToSubscribe = new HashSet<String>(inputTopics.size() + intermediateTopics.size());
        for (String topic : inputTopics) {
            if (!this.allTopics.contains(topic)) {
                notFoundInputTopics.add(topic);
                continue;
            }
            topicsToSubscribe.add(topic);
        }
        for (String topic : intermediateTopics) {
            if (!this.allTopics.contains(topic)) {
                notFoundIntermediateTopics.add(topic);
                continue;
            }
            topicsToSubscribe.add(topic);
        }
        if (!notFoundInputTopics.isEmpty()) {
            System.out.println("Following input topics are not found, skipping them");
            for (String topic : notFoundInputTopics) {
                System.out.println("Topic: " + topic);
            }
            topicNotFound = 1;
        }
        if (!notFoundIntermediateTopics.isEmpty()) {
            System.out.println("Following intermediate topics are not found, skipping them");
            for (String topic : notFoundIntermediateTopics) {
                System.out.println("Topic:" + topic);
            }
            topicNotFound = 1;
        }
        if (topicsToSubscribe.isEmpty()) {
            return topicNotFound;
        }
        Properties config = new Properties();
        config.putAll(consumerConfig);
        config.setProperty("group.id", options.applicationId());
        config.setProperty("enable.auto.commit", "false");
        try (KafkaConsumer client = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            Collection partitions = topicsToSubscribe.stream().map(arg_0 -> ((KafkaConsumer)client).partitionsFor(arg_0)).flatMap(Collection::stream).map(info -> new TopicPartition(info.topic(), info.partition())).collect(Collectors.toList());
            client.assign(partitions);
            HashSet<TopicPartition> inputTopicPartitions = new HashSet<TopicPartition>();
            HashSet<TopicPartition> intermediateTopicPartitions = new HashSet<TopicPartition>();
            for (TopicPartition p : partitions) {
                String topic = p.topic();
                if (options.isInputTopic(topic)) {
                    inputTopicPartitions.add(p);
                    continue;
                }
                if (options.isIntermediateTopic(topic)) {
                    intermediateTopicPartitions.add(p);
                    continue;
                }
                System.err.println("Skipping invalid partition: " + String.valueOf(p));
            }
            this.maybeReset((Consumer<byte[], byte[]>)client, inputTopicPartitions, options);
            this.maybeSeekToEnd(options.applicationId(), (Consumer<byte[], byte[]>)client, intermediateTopicPartitions);
            if (!options.hasDryRun()) {
                for (TopicPartition p : partitions) {
                    client.position(p);
                }
                client.commitSync();
            }
        }
        catch (IOException | ParseException e) {
            System.err.println("ERROR: Resetting offsets failed.");
            throw e;
        }
        System.out.println("Done.");
        return topicNotFound;
    }

    public void maybeSeekToEnd(String groupId, Consumer<byte[], byte[]> client, Set<TopicPartition> intermediateTopicPartitions) {
        if (!intermediateTopicPartitions.isEmpty()) {
            System.out.println("Following intermediate topics offsets will be reset to end (for consumer group " + groupId + ")");
            for (TopicPartition topicPartition : intermediateTopicPartitions) {
                if (!this.allTopics.contains(topicPartition.topic())) continue;
                System.out.println("Topic: " + topicPartition.topic());
            }
            client.seekToEnd(intermediateTopicPartitions);
        }
    }

    private void maybeReset(Consumer<byte[], byte[]> client, Set<TopicPartition> inputTopicPartitions, StreamsResetterOptions options) throws IOException, ParseException {
        if (!inputTopicPartitions.isEmpty()) {
            System.out.println("Following input topics offsets will be reset to (for consumer group " + options.applicationId() + ")");
            if (options.hasToOffset()) {
                this.resetOffsetsTo(client, inputTopicPartitions, options.toOffset());
            } else if (options.hasToEarliest()) {
                client.seekToBeginning(inputTopicPartitions);
            } else if (options.hasToLatest()) {
                client.seekToEnd(inputTopicPartitions);
            } else if (options.hasShiftBy()) {
                this.shiftOffsetsBy(client, inputTopicPartitions, options.shiftBy());
            } else if (options.hasToDatetime()) {
                String ts = options.toDatetime();
                long timestamp = Utils.getDateTime((String)ts);
                this.resetToDatetime(client, inputTopicPartitions, timestamp);
            } else if (options.hasByDuration()) {
                String duration = options.byDuration();
                this.resetByDuration(client, inputTopicPartitions, Duration.parse(duration));
            } else if (options.hasFromFile()) {
                String resetPlanPath = options.fromFile();
                Map<TopicPartition, Long> topicPartitionsAndOffset = this.getTopicPartitionOffsetFromResetPlan(resetPlanPath);
                this.resetOffsetsFromResetPlan(client, inputTopicPartitions, topicPartitionsAndOffset);
            } else {
                client.seekToBeginning(inputTopicPartitions);
            }
            for (TopicPartition p : inputTopicPartitions) {
                System.out.println("Topic: " + p.topic() + " Partition: " + p.partition() + " Offset: " + client.position(p));
            }
        }
    }

    public void resetOffsetsFromResetPlan(Consumer<byte[], byte[]> client, Set<TopicPartition> inputTopicPartitions, Map<TopicPartition, Long> topicPartitionsAndOffset) {
        Map endOffsets = client.endOffsets(inputTopicPartitions);
        Map beginningOffsets = client.beginningOffsets(inputTopicPartitions);
        Map<TopicPartition, Long> validatedTopicPartitionsAndOffset = this.checkOffsetRange(topicPartitionsAndOffset, beginningOffsets, endOffsets);
        for (TopicPartition topicPartition : inputTopicPartitions) {
            client.seek(topicPartition, validatedTopicPartitionsAndOffset.get(topicPartition).longValue());
        }
    }

    private Map<TopicPartition, Long> getTopicPartitionOffsetFromResetPlan(String resetPlanPath) throws IOException, ParseException {
        String resetPlanCsv = Utils.readFileAsString((String)resetPlanPath);
        return this.parseResetPlan(resetPlanCsv);
    }

    private void resetByDuration(Consumer<byte[], byte[]> client, Set<TopicPartition> inputTopicPartitions, Duration duration) {
        this.resetToDatetime(client, inputTopicPartitions, Instant.now().minus(duration).toEpochMilli());
    }

    public void resetToDatetime(Consumer<byte[], byte[]> client, Set<TopicPartition> inputTopicPartitions, Long timestamp) {
        HashMap<TopicPartition, Long> topicPartitionsAndTimes = new HashMap<TopicPartition, Long>(inputTopicPartitions.size());
        for (TopicPartition topicPartition : inputTopicPartitions) {
            topicPartitionsAndTimes.put(topicPartition, timestamp);
        }
        Map topicPartitionsAndOffset = client.offsetsForTimes(topicPartitionsAndTimes);
        for (TopicPartition topicPartition : inputTopicPartitions) {
            Optional<Long> partitionOffset = Optional.ofNullable((OffsetAndTimestamp)topicPartitionsAndOffset.get(topicPartition)).map(OffsetAndTimestamp::offset).filter(offset -> offset != -1L);
            if (partitionOffset.isPresent()) {
                client.seek(topicPartition, partitionOffset.get().longValue());
                continue;
            }
            client.seekToEnd(List.of(topicPartition));
            System.out.println("Partition " + topicPartition.partition() + " from topic " + topicPartition.topic() + " is empty, without a committed record. Falling back to latest known offset.");
        }
    }

    public void shiftOffsetsBy(Consumer<byte[], byte[]> client, Set<TopicPartition> inputTopicPartitions, long shiftBy) {
        Map endOffsets = client.endOffsets(inputTopicPartitions);
        Map beginningOffsets = client.beginningOffsets(inputTopicPartitions);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>(inputTopicPartitions.size());
        for (TopicPartition topicPartition : inputTopicPartitions) {
            long position = client.position(topicPartition);
            long offset = position + shiftBy;
            topicPartitionsAndOffset.put(topicPartition, offset);
        }
        Map<TopicPartition, Long> validatedTopicPartitionsAndOffset = this.checkOffsetRange(topicPartitionsAndOffset, beginningOffsets, endOffsets);
        for (TopicPartition topicPartition : inputTopicPartitions) {
            client.seek(topicPartition, validatedTopicPartitionsAndOffset.get(topicPartition).longValue());
        }
    }

    public void resetOffsetsTo(Consumer<byte[], byte[]> client, Set<TopicPartition> inputTopicPartitions, Long offset) {
        Map endOffsets = client.endOffsets(inputTopicPartitions);
        Map beginningOffsets = client.beginningOffsets(inputTopicPartitions);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>(inputTopicPartitions.size());
        for (TopicPartition topicPartition : inputTopicPartitions) {
            topicPartitionsAndOffset.put(topicPartition, offset);
        }
        Map<TopicPartition, Long> validatedTopicPartitionsAndOffset = this.checkOffsetRange(topicPartitionsAndOffset, beginningOffsets, endOffsets);
        for (TopicPartition topicPartition : inputTopicPartitions) {
            client.seek(topicPartition, validatedTopicPartitionsAndOffset.get(topicPartition).longValue());
        }
    }

    private Map<TopicPartition, Long> parseResetPlan(String resetPlanCsv) throws ParseException {
        String[] resetPlanCsvParts;
        HashMap<TopicPartition, Long> topicPartitionAndOffset = new HashMap<TopicPartition, Long>();
        if (resetPlanCsv == null || resetPlanCsv.isEmpty()) {
            throw new ParseException("Error parsing reset plan CSV file. It is empty,", 0);
        }
        for (String line : resetPlanCsvParts = resetPlanCsv.split("\n")) {
            String[] lineParts = line.split(",");
            if (lineParts.length != 3) {
                throw new ParseException("Reset plan CSV file is not following the format `TOPIC,PARTITION,OFFSET`.", 0);
            }
            String topic = lineParts[0];
            int partition = Integer.parseInt(lineParts[1]);
            long offset = Long.parseLong(lineParts[2]);
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            topicPartitionAndOffset.put(topicPartition, offset);
        }
        return topicPartitionAndOffset;
    }

    private Map<TopicPartition, Long> checkOffsetRange(Map<TopicPartition, Long> inputTopicPartitionsAndOffset, Map<TopicPartition, Long> beginningOffsets, Map<TopicPartition, Long> endOffsets) {
        HashMap<TopicPartition, Long> validatedTopicPartitionsOffsets = new HashMap<TopicPartition, Long>();
        for (Map.Entry<TopicPartition, Long> topicPartitionAndOffset : inputTopicPartitionsAndOffset.entrySet()) {
            long endOffset = endOffsets.get(topicPartitionAndOffset.getKey());
            long offset = topicPartitionAndOffset.getValue();
            if (offset < endOffset) {
                long beginningOffset = beginningOffsets.get(topicPartitionAndOffset.getKey());
                if (offset > beginningOffset) {
                    validatedTopicPartitionsOffsets.put(topicPartitionAndOffset.getKey(), offset);
                    continue;
                }
                System.out.println("New offset (" + offset + ") is lower than earliest offset. Value will be set to " + beginningOffset);
                validatedTopicPartitionsOffsets.put(topicPartitionAndOffset.getKey(), beginningOffset);
                continue;
            }
            System.out.println("New offset (" + offset + ") is higher than latest offset. Value will be set to " + endOffset);
            validatedTopicPartitionsOffsets.put(topicPartitionAndOffset.getKey(), endOffset);
        }
        return validatedTopicPartitionsOffsets;
    }

    private int maybeDeleteInternalTopics(Admin adminClient, StreamsResetterOptions options) {
        List<String> topicsToDelete;
        List inferredInternalTopics = this.allTopics.stream().filter(options::isInferredInternalTopic).collect(Collectors.toList());
        List<String> specifiedInternalTopics = options.internalTopics();
        if (!specifiedInternalTopics.isEmpty()) {
            if (!new HashSet(inferredInternalTopics).containsAll(specifiedInternalTopics)) {
                throw new IllegalArgumentException("Invalid topic specified in the --internal-topics option. Ensure that the topics specified are all internal topics. Do a dry run without the --internal-topics option to see the list of all internal topics that can be deleted.");
            }
            topicsToDelete = specifiedInternalTopics;
            System.out.println("Deleting specified internal topics " + String.valueOf(topicsToDelete));
        } else {
            topicsToDelete = inferredInternalTopics;
            System.out.println("Deleting inferred internal topics " + String.valueOf(topicsToDelete));
        }
        if (!options.hasDryRun()) {
            this.doDelete(topicsToDelete, adminClient);
        }
        System.out.println("Done.");
        return 0;
    }

    public void doDelete(List<String> topicsToDelete, Admin adminClient) {
        boolean hasDeleteErrors = false;
        DeleteTopicsResult deleteTopicsResult = adminClient.deleteTopics(topicsToDelete);
        Map results = deleteTopicsResult.topicNameValues();
        for (Map.Entry entry : results.entrySet()) {
            try {
                ((KafkaFuture)entry.getValue()).get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                System.err.println("ERROR: deleting topic " + (String)entry.getKey());
                e.printStackTrace(System.err);
                hasDeleteErrors = true;
            }
        }
        if (hasDeleteErrors) {
            throw new RuntimeException("Encountered an error deleting one or more topics");
        }
    }

    public static boolean matchesInternalTopicFormat(String topicName) {
        return topicName.endsWith("-changelog") || topicName.endsWith("-repartition") || topicName.endsWith("-subscription-registration-topic") || topicName.endsWith("-subscription-response-topic") || topicName.matches(".+-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-\\d+-topic") || topicName.matches(".+-KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-\\d+-topic");
    }

    private static class StreamsResetterOptions
    extends CommandDefaultOptions {
        private final OptionSpec<String> bootstrapServerOption;
        private final OptionSpec<String> applicationIdOption;
        private final OptionSpec<String> inputTopicsOption;
        private final OptionSpec<String> intermediateTopicsOption;
        private final OptionSpec<String> internalTopicsOption;
        private final OptionSpec<Long> toOffsetOption;
        private final OptionSpec<String> toDatetimeOption;
        private final OptionSpec<String> byDurationOption;
        private final OptionSpecBuilder toEarliestOption;
        private final OptionSpecBuilder toLatestOption;
        private final OptionSpec<String> fromFileOption;
        private final OptionSpec<Long> shiftByOption;
        private final OptionSpecBuilder dryRunOption;
        @Deprecated(since="4.2", forRemoval=true)
        private final OptionSpec<String> configOption;
        private final OptionSpec<String> commandConfigOption;
        private final OptionSpecBuilder forceOption;

        public StreamsResetterOptions(String[] args) {
            super(args);
            this.applicationIdOption = this.parser.accepts("application-id", "REQUIRED: The Kafka Streams application ID (application.id).").withRequiredArg().ofType(String.class).describedAs("id").required();
            this.bootstrapServerOption = this.parser.accepts("bootstrap-server", "The server(s) to connect to. The broker list string in the form HOST1:PORT1,HOST2:PORT2. (default: localhost:9092)").withRequiredArg().ofType(String.class).describedAs("server to connect to");
            this.inputTopicsOption = this.parser.accepts("input-topics", "Comma-separated list of user input topics. For these topics, the tool by default will reset the offset to the earliest available offset. Reset to other offset position by appending other reset offset option, ex: --input-topics foo --shift-by 5").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("list");
            this.intermediateTopicsOption = this.parser.accepts("intermediate-topics", "[deprecated] Comma-separated list of intermediate user topics (topics that are input and output topics). For these topics, the tool will skip to the end.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("list");
            this.internalTopicsOption = this.parser.accepts("internal-topics", "Comma-separated list of internal topics to delete. Must be a subset of the internal topics marked for deletion by the default behaviour (do a dry-run without this option to view these topics).").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("list");
            this.toOffsetOption = this.parser.accepts("to-offset", "Reset offsets to a specific offset.").withRequiredArg().ofType(Long.class);
            this.toDatetimeOption = this.parser.accepts("to-datetime", "Reset offsets to offset from datetime. Format: 'YYYY-MM-DDThh:mm:ss.sss'").withRequiredArg().ofType(String.class);
            this.byDurationOption = this.parser.accepts("by-duration", "Reset offsets to offset by duration from current timestamp. Format: 'PnDTnHnMnS'").withRequiredArg().ofType(String.class);
            this.toEarliestOption = this.parser.accepts("to-earliest", "Reset offsets to earliest offset.");
            this.toLatestOption = this.parser.accepts("to-latest", "Reset offsets to latest offset.");
            this.fromFileOption = this.parser.accepts("from-file", "Reset offsets to values defined in CSV file.").withRequiredArg().ofType(String.class);
            this.shiftByOption = this.parser.accepts("shift-by", "Reset offsets shifting current offset by 'n', where 'n' can be positive or negative").withRequiredArg().describedAs("number-of-offsets").ofType(Long.class);
            this.configOption = this.parser.accepts("config-file", "(DEPRECATED) Property file containing configs to be passed to admin clients and embedded consumer. This option will be removed in a future version. Use --command-config instead.").withRequiredArg().ofType(String.class).describedAs("file name");
            this.commandConfigOption = this.parser.accepts("command-config", "Config properties file to be passed to admin clients and embedded consumer.").withRequiredArg().ofType(String.class).describedAs("file name");
            this.forceOption = this.parser.accepts("force", "Force the removal of members of the consumer group (intended to remove stopped members if a long session timeout was used). Make sure to shut down all stream applications when this option is specified to avoid unexpected rebalances.");
            this.dryRunOption = this.parser.accepts("dry-run", "Display the actions that would be performed without executing the reset commands.");
            try {
                this.options = this.parser.parse(args);
                CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)StreamsResetter.USAGE);
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.toOffsetOption, (OptionSpec[])new OptionSpec[]{this.toDatetimeOption, this.byDurationOption, this.toEarliestOption, this.toLatestOption, this.fromFileOption, this.shiftByOption});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.toDatetimeOption, (OptionSpec[])new OptionSpec[]{this.toOffsetOption, this.byDurationOption, this.toEarliestOption, this.toLatestOption, this.fromFileOption, this.shiftByOption});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.byDurationOption, (OptionSpec[])new OptionSpec[]{this.toOffsetOption, this.toDatetimeOption, this.toEarliestOption, this.toLatestOption, this.fromFileOption, this.shiftByOption});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.toEarliestOption, (OptionSpec[])new OptionSpec[]{this.toOffsetOption, this.toDatetimeOption, this.byDurationOption, this.toLatestOption, this.fromFileOption, this.shiftByOption});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.toLatestOption, (OptionSpec[])new OptionSpec[]{this.toOffsetOption, this.toDatetimeOption, this.byDurationOption, this.toEarliestOption, this.fromFileOption, this.shiftByOption});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.fromFileOption, (OptionSpec[])new OptionSpec[]{this.toOffsetOption, this.toDatetimeOption, this.byDurationOption, this.toEarliestOption, this.toLatestOption, this.shiftByOption});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.shiftByOption, (OptionSpec[])new OptionSpec[]{this.toOffsetOption, this.toDatetimeOption, this.byDurationOption, this.toEarliestOption, this.toLatestOption, this.fromFileOption});
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.configOption, (OptionSpec[])new OptionSpec[]{this.commandConfigOption});
            }
            catch (OptionException e) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
            }
        }

        public boolean hasDryRun() {
            return this.options.has((OptionSpec)this.dryRunOption);
        }

        public String applicationId() {
            return (String)this.options.valueOf(this.applicationIdOption);
        }

        public boolean hasConfig() {
            return this.options.has(this.configOption);
        }

        public String config() {
            return (String)this.options.valueOf(this.configOption);
        }

        public String commandConfig() {
            return (String)this.options.valueOf(this.commandConfigOption);
        }

        public boolean hasBootstrapServer() {
            return this.options.has(this.bootstrapServerOption);
        }

        public String bootstrapServer() {
            return (String)this.options.valueOf(this.bootstrapServerOption);
        }

        public boolean hasForce() {
            return this.options.has((OptionSpec)this.forceOption);
        }

        public List<String> inputTopicsOption() {
            return this.options.valuesOf(this.inputTopicsOption);
        }

        public List<String> intermediateTopicsOption() {
            if (this.options.has(this.intermediateTopicsOption)) {
                System.out.println("WARN: `--intermediate-topics` is deprecated and will be removed in a future release");
            }
            return this.options.valuesOf(this.intermediateTopicsOption);
        }

        public boolean hasToOffset() {
            return this.options.has(this.toOffsetOption);
        }

        public long toOffset() {
            return (Long)this.options.valueOf(this.toOffsetOption);
        }

        public boolean hasToEarliest() {
            return this.options.has((OptionSpec)this.toEarliestOption);
        }

        public boolean hasToLatest() {
            return this.options.has((OptionSpec)this.toLatestOption);
        }

        public boolean hasShiftBy() {
            return this.options.has(this.shiftByOption);
        }

        public long shiftBy() {
            return (Long)this.options.valueOf(this.shiftByOption);
        }

        public boolean hasToDatetime() {
            return this.options.has(this.toDatetimeOption);
        }

        public String toDatetime() {
            return (String)this.options.valueOf(this.toDatetimeOption);
        }

        public boolean hasByDuration() {
            return this.options.has(this.byDurationOption);
        }

        public String byDuration() {
            return (String)this.options.valueOf(this.byDurationOption);
        }

        public boolean hasFromFile() {
            return this.options.has(this.fromFileOption);
        }

        public String fromFile() {
            return (String)this.options.valueOf(this.fromFileOption);
        }

        public boolean isInputTopic(String topic) {
            return this.options.valuesOf(this.inputTopicsOption).contains(topic);
        }

        public boolean isIntermediateTopic(String topic) {
            return this.options.valuesOf(this.intermediateTopicsOption).contains(topic);
        }

        private boolean isInferredInternalTopic(String topicName) {
            return !this.isInputTopic(topicName) && !this.isIntermediateTopic(topicName) && topicName.startsWith((String)this.options.valueOf(this.applicationIdOption) + "-") && StreamsResetter.matchesInternalTopicFormat(topicName);
        }

        public List<String> internalTopics() {
            return this.options.valuesOf(this.internalTopicsOption);
        }
    }
}

