/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.lifecycle.LifecycleComponent;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.util.concurrent.ConcurrentMapLong;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.RequestHandlerRegistry;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportMessageListener;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportStats;

@PublicApi(since="1.0.0")
public interface Transport
extends LifecycleComponent {
    default public <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> reg) {
        this.getRequestHandlers().registerHandler(reg);
    }

    public void setMessageListener(TransportMessageListener var1);

    default public void setSlowLogThreshold(TimeValue slowLogThreshold) {
    }

    default public boolean isSecure() {
        return false;
    }

    public BoundTransportAddress boundAddress();

    public Map<String, BoundTransportAddress> profileBoundAddresses();

    public TransportAddress[] addressesFromString(String var1) throws UnknownHostException;

    public List<String> getDefaultSeedAddresses();

    public void openConnection(DiscoveryNode var1, ConnectionProfile var2, ActionListener<Connection> var3);

    public TransportStats getStats();

    public ResponseHandlers getResponseHandlers();

    public RequestHandlers getRequestHandlers();

    public static int resolvePublishPort(int publishPort, List<InetSocketAddress> boundAddresses, InetAddress publishInetAddress) {
        if (publishPort < 0) {
            for (InetSocketAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            HashSet<Integer> ports = new HashSet<Integer>();
            for (InetSocketAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = (Integer)ports.iterator().next();
            }
        }
        return publishPort;
    }

    public static int resolveTransportPublishPort(int publishPort, List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        return Transport.resolvePublishPort(publishPort, boundAddresses.stream().map(TransportAddress::address).collect(Collectors.toList()), publishInetAddress);
    }

    @PublicApi(since="1.0.0")
    public static final class RequestHandlers {
        private volatile Map<String, RequestHandlerRegistry<? extends TransportRequest>> requestHandlers = Collections.emptyMap();

        synchronized <Request extends TransportRequest> void registerHandler(RequestHandlerRegistry<Request> reg) {
            if (this.requestHandlers.containsKey(reg.getAction())) {
                throw new IllegalArgumentException("transport handlers for action " + reg.getAction() + " is already registered");
            }
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put((Object)reg.getAction(), reg).immutableMap();
        }

        public synchronized <Request extends TransportRequest> void forceRegister(RequestHandlerRegistry<Request> reg) {
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put((Object)reg.getAction(), reg).immutableMap();
        }

        public <T extends TransportRequest> RequestHandlerRegistry<T> getHandler(String action) {
            return this.requestHandlers.get(action);
        }
    }

    @PublicApi(since="1.0.0")
    public static final class ResponseHandlers {
        private final ConcurrentMapLong<ResponseContext<? extends TransportResponse>> handlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
        private final AtomicLong requestIdGenerator = new AtomicLong();

        public boolean contains(long requestId) {
            return this.handlers.containsKey((Object)requestId);
        }

        public ResponseContext<? extends TransportResponse> remove(long requestId) {
            return (ResponseContext)this.handlers.remove(requestId);
        }

        public long add(ResponseContext<? extends TransportResponse> holder) {
            long requestId = this.newRequestId();
            ResponseContext existing = (ResponseContext)this.handlers.put(requestId, holder);
            assert (existing == null) : "request ID already in use: " + requestId;
            return requestId;
        }

        long newRequestId() {
            return this.requestIdGenerator.incrementAndGet();
        }

        public List<ResponseContext<? extends TransportResponse>> prune(Predicate<ResponseContext<? extends TransportResponse>> predicate) {
            ArrayList<ResponseContext<? extends TransportResponse>> holders = new ArrayList<ResponseContext<? extends TransportResponse>>();
            for (Map.Entry entry : this.handlers.entrySet()) {
                ResponseContext remove;
                ResponseContext holder = (ResponseContext)entry.getValue();
                if (!predicate.test(holder) || (remove = (ResponseContext)this.handlers.remove(entry.getKey())) == null) continue;
                holders.add(holder);
            }
            return holders;
        }

        public TransportResponseHandler<? extends TransportResponse> onResponseReceived(long requestId, TransportMessageListener listener) {
            ResponseContext context = (ResponseContext)this.handlers.remove(requestId);
            listener.onResponseReceived(requestId, context);
            if (context == null) {
                return null;
            }
            return context.handler();
        }
    }

    @PublicApi(since="1.0.0")
    public static final class ResponseContext<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final Connection connection;
        private final String action;

        ResponseContext(TransportResponseHandler<T> handler, Connection connection, String action) {
            this.handler = handler;
            this.connection = connection;
            this.action = action;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public Connection connection() {
            return this.connection;
        }

        public String action() {
            return this.action;
        }
    }

    @PublicApi(since="1.0.0")
    public static interface Connection
    extends Closeable {
        public DiscoveryNode getNode();

        public void sendRequest(long var1, String var3, TransportRequest var4, TransportRequestOptions var5) throws IOException, TransportException;

        public void addCloseListener(ActionListener<Void> var1);

        public boolean isClosed();

        default public Version getVersion() {
            return this.getNode().getVersion();
        }

        default public Object getCacheKey() {
            return this;
        }

        @Override
        public void close();
    }
}

