/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestScaleIndexAction
extends BaseRestHandler {
    private static final String SEARCH_ONLY_FIELD = "search_only";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_scale")));
    }

    @Override
    public String getName() {
        return "search_only_index_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String index = request.param("index");
        if (index == null || index.trim().isEmpty()) {
            throw new IllegalArgumentException("index is required");
        }
        boolean searchOnly = this.parseSearchOnlyValue(request);
        return channel -> client.admin().indices().prepareScaleSearchOnly(index, searchOnly).execute(new RestToXContentListener((RestChannel)channel));
    }

    private boolean parseSearchOnlyValue(RestRequest request) {
        try {
            Map source;
            try {
                source = request.contentParser().map();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Request body must be valid JSON", e);
            }
            for (String key : source.keySet()) {
                if (SEARCH_ONLY_FIELD.equals(key)) continue;
                throw new IllegalArgumentException("Unknown parameter [" + key + "]. Only [search_only] is allowed.");
            }
            if (!source.containsKey(SEARCH_ONLY_FIELD)) {
                throw new IllegalArgumentException("Parameter [search_only] is required");
            }
            Object value = source.get(SEARCH_ONLY_FIELD);
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("Parameter [search_only] must be a boolean (true or false)");
            }
            return (Boolean)value;
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw e;
            }
            throw new IllegalArgumentException("Request body must be valid JSON", e);
        }
    }
}

