function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React from 'react';
import { OuiStepNumber } from './step_number';
import { useI18nCompleteStep, useI18nDisabledStep, useI18nIncompleteStep, useI18nStep, useI18nWarningStep } from './step_strings';
export var OuiStepHorizontal = function OuiStepHorizontal(_ref) {
  var className = _ref.className,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    title = _ref.title,
    isSelected = _ref.isSelected,
    isComplete = _ref.isComplete,
    onClick = _ref.onClick,
    disabled = _ref.disabled,
    status = _ref.status,
    rest = _objectWithoutProperties(_ref, ["className", "step", "title", "isSelected", "isComplete", "onClick", "disabled", "status"]);
  var buttonTitle = useI18nStep({
    number: step,
    title: title
  });
  var completeTitle = useI18nCompleteStep({
    number: step,
    title: title
  });
  var disabledTitle = useI18nDisabledStep({
    number: step,
    title: title
  });
  var incompleteTitle = useI18nIncompleteStep({
    number: step,
    title: title
  });
  var warningTitle = useI18nWarningStep({
    number: step,
    title: title
  });
  var classes = classNames('ouiStepHorizontal', className, {
    'ouiStepHorizontal-isSelected': isSelected,
    'ouiStepHorizontal-isComplete': isComplete,
    'ouiStepHorizontal-isIncomplete': !isSelected && !isComplete,
    'ouiStepHorizontal-isDisabled': disabled
  });
  if (disabled) status = 'disabled';else if (isComplete) status = 'complete';else if (isSelected) status = status;else if (!status) status = 'incomplete';
  var stepTitle = buttonTitle;
  if (status === 'disabled') stepTitle = disabledTitle;
  if (status === 'complete') stepTitle = completeTitle;
  if (status === 'incomplete') stepTitle = incompleteTitle;
  if (status === 'warning') stepTitle = warningTitle;
  var onStepClick = function onStepClick(event) {
    if (!disabled) onClick(event);
  };
  return /*#__PURE__*/React.createElement("button", _extends({
    className: classes,
    title: stepTitle,
    onClick: onStepClick,
    disabled: disabled
  }, rest), /*#__PURE__*/React.createElement(OuiStepNumber, {
    className: "ouiStepHorizontal__number",
    status: status,
    number: step
  }), /*#__PURE__*/React.createElement("span", {
    className: "ouiStepHorizontal__title"
  }, title));
};

/* OUI -> EUI Aliases: Build-Time */
OuiStepHorizontal.propTypes = {
  /**
     * Adds to the line before the indicator for showing current progress
     */
  isSelected: PropTypes.bool,
  /**
     * Adds to the line after the indicator for showing current progress
     */
  isComplete: PropTypes.bool,
  onClick: PropTypes.func.isRequired,
  /**
     * Makes the whole step button disabled.
     */
  disabled: PropTypes.bool,
  /**
     * The number of the step in the list of steps
     */
  step: PropTypes.number,
  title: PropTypes.string,
  /**
     * Visual representation of the step number indicator.
     * May replace the number provided in props.step with alternate styling.
     * The `isSelected`, `isComplete`, and `disabled` props will override these.
     */
  status: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};
/* OUI -> EUI Aliases: Build-Time */export { EuiStepHorizontal } from '../../eui_components/steps/step_horizontal';