/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.util;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.indexmanagement.indexstatemanagement.action.RolloverAction;
import org.opensearch.indexmanagement.indexstatemanagement.model.ChangePolicy;
import org.opensearch.indexmanagement.indexstatemanagement.model.Conditions;
import org.opensearch.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.model.State;
import org.opensearch.indexmanagement.indexstatemanagement.model.Transition;
import org.opensearch.indexmanagement.indexstatemanagement.model.coordinator.SweptManagedIndexConfig;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.indexstatemanagement.util.TransitionConditionContext;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionRetry;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionTimeout;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.PolicyRetryInfoMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StateMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00d0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a=\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\f\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003\u001a\"\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018\u001a'\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010$\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'\u001a(\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030)\u001a\u001a\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u00182\b\b\u0002\u0010/\u001a\u00020\u0007\u001a\u0012\u00100\u001a\u00020\u0018*\u0002012\u0006\u00102\u001a\u000203\u001a\u0018\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0002\u001a\u0018\u00107\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0002\u001a\u0018\u00108\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0002\u001a\u0018\u00109\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0002\u001a\u0018\u0010:\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0002\u001a\u0018\u0010;\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0002\u001a\u0018\u0010<\u001a\u00020\u00182\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203H\u0002\u001a\n\u0010=\u001a\u00020\u0018*\u000201\u001a*\u00100\u001a\u00020\u0018*\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C\u001a\u0012\u0010E\u001a\u00020F*\u00020G2\u0006\u0010H\u001a\u00020\u0016\u001a.\u0010I\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0018\u00010J*\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00010O\u001a\u0014\u0010P\u001a\u00020\u0018*\u00020K2\b\u0010L\u001a\u0004\u0018\u00010M\u001a(\u0010Q\u001a\u00020\u0016*\u00020\u00162\b\u0010R\u001a\u0004\u0018\u00010G2\b\u0010S\u001a\u0004\u0018\u00010K2\b\u0010T\u001a\u0004\u0018\u00010U\u001a\u001a\u0010V\u001a\u00020\u0016*\u00020\u00162\u0006\u0010S\u001a\u00020K2\u0006\u0010T\u001a\u00020U\u001a\u0014\u0010[\u001a\u00020\u0018*\u00020\u000e2\b\u0010\\\u001a\u0004\u0018\u00010K\u001a\u0012\u0010]\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010^\u001a\u00020\u0018*\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010_\u001a\u00020\u0018*\u00020\t2\b\u0010`\u001a\u0004\u0018\u00010\u00032\u0006\u0010a\u001a\u00020\t2\u0006\u0010b\u001a\u00020c\u001a\u0018\u0010d\u001a\u00020\u0018*\u00020K2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00030)\u001a \u0010f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010g\u001a\u00020hH\u0086@\u00a2\u0006\u0002\u0010i\u001a\u000e\u0010j\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u000f\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010W\u001a\u00020\u0018*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\"\u0015\u0010Y\u001a\u00020\u0018*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\bY\u0010X\"\u0015\u0010Z\u001a\u00020\u0018*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010X\u00a8\u0006k"}, d2={"managedIndexConfigIndexRequest", "Lorg/opensearch/action/index/IndexRequest;", "index", "", "uuid", "policyID", "jobInterval", "", "policy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "jobJitter", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;Ljava/lang/Double;)Lorg/opensearch/action/index/IndexRequest;", "managedIndexConfig", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ManagedIndexConfig;", "METADATA_POST_FIX", "managedIndexMetadataID", "indexUuid", "revertManagedIndexMetadataID", "metadataID", "managedIndexMetadataIndexRequest", "managedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "waitRefresh", "", "create", "updateEnabledField", "Lorg/opensearch/action/update/UpdateRequest;", "enabled", "enabledTime", "", "(Ljava/lang/String;ZLjava/lang/Long;)Lorg/opensearch/action/update/UpdateRequest;", "updateDisableManagedIndexRequest", "updateEnableManagedIndexRequest", "deleteManagedIndexRequest", "Lorg/opensearch/action/delete/DeleteRequest;", "deleteManagedIndexMetadataRequest", "updateManagedIndexRequest", "sweptManagedIndexConfig", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/coordinator/SweptManagedIndexConfig;", "getManagedIndicesToDelete", "", "currentIndexUuids", "currentManagedIndexUuids", "getSweptManagedIndexSearchRequest", "Lorg/opensearch/action/search/SearchRequest;", "scroll", "size", "evaluateConditions", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Transition;", "context", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/TransitionConditionContext;", "checkDocCount", "conditions", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Conditions;", "checkIndexAge", "checkSize", "checkCron", "checkRolloverAge", "checkNoAlias", "checkMinStateAge", "hasStatsConditions", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/RolloverAction;", "indexAgeTimeValue", "Lorg/opensearch/common/unit/TimeValue;", "numDocs", "indexSize", "Lorg/opensearch/core/common/unit/ByteSizeValue;", "primaryShardSize", "getUpdatedStateMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StateMetaData;", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/State;", "managedIndexMetaData", "shouldBackoff", "Lkotlin/Pair;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "actionMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionMetaData;", "actionRetry", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;", "hasTimedOut", "getStartingManagedIndexMetaData", "state", "action", "step", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "getCompletedManagedIndexMetaData", "isSuccessfulDelete", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;)Z", "isFailed", "isPolicyCompleted", "shouldChangePolicy", "actionToExecute", "hasDifferentPolicyVersion", "hasDifferentJobInterval", "isSafeToChange", "stateName", "newPolicy", "changePolicy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ChangePolicy;", "isAllowed", "allowList", "getManagedIndexConfig", "client", "Lorg/opensearch/transport/client/Client;", "(Ljava/lang/String;Lorg/opensearch/transport/client/Client;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIntervalFromManagedIndexConfig", "opensearch-index-management"})
@JvmName(name="ManagedIndexUtils")
@SourceDebugExtension(value={"SMAP\nManagedIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedIndexUtils.kt\norg/opensearch/indexmanagement/indexstatemanagement/util/ManagedIndexUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,515:1\n774#2:516\n865#2,2:517\n1878#2,3:520\n1#3:519\n*S KotlinDebug\n*F\n+ 1 ManagedIndexUtils.kt\norg/opensearch/indexmanagement/indexstatemanagement/util/ManagedIndexUtils\n*L\n165#1:516\n165#1:517,2\n481#1:520,3\n*E\n"})
public final class ManagedIndexUtils {
    @NotNull
    public static final String METADATA_POST_FIX = "#metadata";

    @NotNull
    public static final IndexRequest managedIndexConfigIndexRequest(@NotNull String index2, @NotNull String uuid, @NotNull String policyID, int jobInterval, @NotNull Policy policy2, @Nullable Double jobJitter) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)policyID, (String)"policyID");
        Intrinsics.checkNotNullParameter((Object)policy2, (String)"policy");
        IntervalSchedule intervalSchedule = new IntervalSchedule(Instant.now(), jobInterval, ChronoUnit.MINUTES);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Instant instant2 = instant;
        Instant instant3 = Instant.now();
        long l = policy2.getSeqNo();
        long l2 = policy2.getPrimaryTerm();
        ManagedIndexConfig managedIndexConfig = new ManagedIndexConfig(null, 0L, 0L, index2, index2, uuid, true, (Schedule)intervalSchedule, instant2, instant3, policyID, l, l2, policy2, null, jobJitter, 7, null);
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").id(uuid).create(true).routing(managedIndexConfig.getIndexUuid());
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        IndexRequest indexRequest2 = indexRequest.source(managedIndexConfig.toXContent(xContentBuilder, params));
        Intrinsics.checkNotNullExpressionValue((Object)indexRequest2, (String)"source(...)");
        return indexRequest2;
    }

    @NotNull
    public static final IndexRequest managedIndexConfigIndexRequest(@NotNull ManagedIndexConfig managedIndexConfig) {
        Intrinsics.checkNotNullParameter((Object)managedIndexConfig, (String)"managedIndexConfig");
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").id(managedIndexConfig.getIndexUuid()).setIfPrimaryTerm(managedIndexConfig.getPrimaryTerm()).setIfSeqNo(managedIndexConfig.getSeqNo()).routing(managedIndexConfig.getIndexUuid());
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        IndexRequest indexRequest2 = indexRequest.source(managedIndexConfig.toXContent(xContentBuilder, params));
        Intrinsics.checkNotNullExpressionValue((Object)indexRequest2, (String)"source(...)");
        return indexRequest2;
    }

    @NotNull
    public static final String managedIndexMetadataID(@NotNull String indexUuid) {
        Intrinsics.checkNotNullParameter((Object)indexUuid, (String)"indexUuid");
        return indexUuid + METADATA_POST_FIX;
    }

    @NotNull
    public static final String revertManagedIndexMetadataID(@NotNull String metadataID) {
        Intrinsics.checkNotNullParameter((Object)metadataID, (String)"metadataID");
        return StringsKt.dropLast((String)metadataID, (int)9);
    }

    @NotNull
    public static final IndexRequest managedIndexMetadataIndexRequest(@NotNull ManagedIndexMetaData managedIndexMetadata, boolean waitRefresh, boolean create) {
        Intrinsics.checkNotNullParameter((Object)managedIndexMetadata, (String)"managedIndexMetadata");
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").id(ManagedIndexUtils.managedIndexMetadataID(managedIndexMetadata.getIndexUuid())).setIfPrimaryTerm(managedIndexMetadata.getPrimaryTerm()).setIfSeqNo(managedIndexMetadata.getSeqNo()).routing(managedIndexMetadata.getIndexUuid()).create(create);
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        IndexRequest req = indexRequest.source(managedIndexMetadata.toXContent(xContentBuilder, params, true));
        if (waitRefresh) {
            ReplicatedWriteRequest replicatedWriteRequest = req.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            Intrinsics.checkNotNullExpressionValue((Object)replicatedWriteRequest, (String)"setRefreshPolicy(...)");
            return (IndexRequest)replicatedWriteRequest;
        }
        Intrinsics.checkNotNull((Object)req);
        return req;
    }

    public static /* synthetic */ IndexRequest managedIndexMetadataIndexRequest$default(ManagedIndexMetaData managedIndexMetaData, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return ManagedIndexUtils.managedIndexMetadataIndexRequest(managedIndexMetaData, bl, bl2);
    }

    private static final UpdateRequest updateEnabledField(String uuid, boolean enabled, Long enabledTime) {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().startObject("managed_index");
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"startObject(...)");
        XContentBuilder builder = OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, "last_updated_time", Instant.now()).field("enabled", enabled).field("enabled_time", enabledTime).endObject().endObject();
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", uuid).doc(builder);
        Intrinsics.checkNotNullExpressionValue((Object)updateRequest, (String)"doc(...)");
        return updateRequest;
    }

    @NotNull
    public static final UpdateRequest updateDisableManagedIndexRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return ManagedIndexUtils.updateEnabledField(uuid, false, null);
    }

    @NotNull
    public static final UpdateRequest updateEnableManagedIndexRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return ManagedIndexUtils.updateEnabledField(uuid, true, Instant.now().toEpochMilli());
    }

    @NotNull
    public static final DeleteRequest deleteManagedIndexRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return new DeleteRequest(".opendistro-ism-config", uuid);
    }

    @NotNull
    public static final DeleteRequest deleteManagedIndexMetadataRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        DeleteRequest deleteRequest = new DeleteRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(uuid)).routing(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)deleteRequest, (String)"routing(...)");
        return deleteRequest;
    }

    @NotNull
    public static final UpdateRequest updateManagedIndexRequest(@NotNull SweptManagedIndexConfig sweptManagedIndexConfig) {
        Intrinsics.checkNotNullParameter((Object)sweptManagedIndexConfig, (String)"sweptManagedIndexConfig");
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", sweptManagedIndexConfig.getUuid()).setIfPrimaryTerm(sweptManagedIndexConfig.getPrimaryTerm()).setIfSeqNo(sweptManagedIndexConfig.getSeqNo()).doc(RestHandlerUtilsKt.getPartialChangePolicyBuilder(sweptManagedIndexConfig.getChangePolicy()));
        Intrinsics.checkNotNullExpressionValue((Object)updateRequest, (String)"doc(...)");
        return updateRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getManagedIndicesToDelete(@NotNull List<String> currentIndexUuids, @NotNull List<String> currentManagedIndexUuids) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(currentIndexUuids, (String)"currentIndexUuids");
        Intrinsics.checkNotNullParameter(currentManagedIndexUuids, (String)"currentManagedIndexUuids");
        Iterable $this$filter$iv = currentManagedIndexUuids;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String currentManagedIndex = (String)element$iv$iv;
            boolean bl = false;
            if (!(!currentIndexUuids.contains(currentManagedIndex))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final SearchRequest getSweptManagedIndexSearchRequest(boolean scroll, int size) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)QueryBuilders.existsQuery((String)"managed_index"));
        String[] stringArray = new String[]{".opendistro-ism-config"};
        SearchRequest req = new SearchRequest().indices(stringArray).allowPartialSearchResults(false).source(SearchSourceBuilder.searchSource().size(size).seqNoAndPrimaryTerm(Boolean.valueOf(true)).fetchSource(new String[0], new String[0]).query((QueryBuilder)boolQueryBuilder)).preference(Preference.PRIMARY_FIRST.type());
        if (scroll) {
            req.scroll(TimeValue.timeValueMinutes((long)1L));
        }
        Intrinsics.checkNotNull((Object)req);
        return req;
    }

    public static /* synthetic */ SearchRequest getSweptManagedIndexSearchRequest$default(boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        return ManagedIndexUtils.getSweptManagedIndexSearchRequest(bl, n);
    }

    public static final boolean evaluateConditions(@NotNull Transition $this$evaluateConditions, @NotNull TransitionConditionContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$evaluateConditions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Conditions conditions = $this$evaluateConditions.getConditions();
        if (conditions == null) {
            return true;
        }
        Conditions conditions2 = conditions;
        if (ManagedIndexUtils.checkDocCount(conditions2, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkIndexAge(conditions2, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkSize(conditions2, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkCron(conditions2, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkRolloverAge(conditions2, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkNoAlias(conditions2, context)) {
            return true;
        }
        return ManagedIndexUtils.checkMinStateAge(conditions2, context);
    }

    private static final boolean checkDocCount(Conditions conditions, TransitionConditionContext context) {
        return conditions.getDocCount() != null && context.getNumDocs() != null && conditions.getDocCount() <= context.getNumDocs();
    }

    private static final boolean checkIndexAge(Conditions conditions, TransitionConditionContext context) {
        if (conditions.getIndexAge() != null) {
            long indexCreationDateMilli = context.getIndexCreationDate().toEpochMilli();
            if (indexCreationDateMilli == -1L) {
                return false;
            }
            long elapsedTime = Instant.now().toEpochMilli() - indexCreationDateMilli;
            return conditions.getIndexAge().getMillis() <= elapsedTime;
        }
        return false;
    }

    private static final boolean checkSize(Conditions conditions, TransitionConditionContext context) {
        return conditions.getSize() != null && context.getIndexSize() != null && conditions.getSize().compareTo(context.getIndexSize()) <= 0;
    }

    private static final boolean checkCron(Conditions conditions, TransitionConditionContext context) {
        if (conditions.getCron() != null) {
            return conditions.getCron().getNextExecutionTime(context.getTransitionStartTime()).compareTo(Instant.now()) <= 0;
        }
        return false;
    }

    private static final boolean checkRolloverAge(Conditions conditions, TransitionConditionContext context) {
        if (conditions.getRolloverAge() != null) {
            Instant instant = context.getRolloverDate();
            if (instant == null) {
                return false;
            }
            long rolloverDateMilli = instant.toEpochMilli();
            long elapsedTime = Instant.now().toEpochMilli() - rolloverDateMilli;
            return conditions.getRolloverAge().getMillis() <= elapsedTime;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkNoAlias(Conditions conditions, TransitionConditionContext context) {
        if (conditions.getNoAlias() == null) return false;
        if (context.getIndexAliasesCount() == null) return false;
        if (conditions.getNoAlias().booleanValue()) {
            Integer n = context.getIndexAliasesCount();
            if (n != null) {
                if (n == 0) return true;
            }
        }
        if (conditions.getNoAlias() != false) return false;
        if (context.getIndexAliasesCount() <= 0) return false;
        return true;
    }

    private static final boolean checkMinStateAge(Conditions conditions, TransitionConditionContext context) {
        return conditions.getMinStateAge() != null && context.getStateStartTime() != null && System.currentTimeMillis() - context.getStateStartTime().toEpochMilli() >= conditions.getMinStateAge().getMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasStatsConditions(@NotNull Transition $this$hasStatsConditions) {
        Intrinsics.checkNotNullParameter((Object)$this$hasStatsConditions, (String)"<this>");
        Conditions conditions = $this$hasStatsConditions.getConditions();
        if ((conditions != null ? conditions.getDocCount() : null) != null) return true;
        Conditions conditions2 = $this$hasStatsConditions.getConditions();
        if (conditions2 == null) return false;
        ByteSizeValue byteSizeValue = conditions2.getSize();
        if (byteSizeValue == null) return false;
        return true;
    }

    public static final boolean evaluateConditions(@NotNull RolloverAction $this$evaluateConditions, @NotNull TimeValue indexAgeTimeValue, long numDocs, @NotNull ByteSizeValue indexSize, @NotNull ByteSizeValue primaryShardSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$evaluateConditions), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indexAgeTimeValue, (String)"indexAgeTimeValue");
        Intrinsics.checkNotNullParameter((Object)indexSize, (String)"indexSize");
        Intrinsics.checkNotNullParameter((Object)primaryShardSize, (String)"primaryShardSize");
        if ($this$evaluateConditions.getMinDocs() == null && $this$evaluateConditions.getMinAge() == null && $this$evaluateConditions.getMinSize() == null && $this$evaluateConditions.getMinPrimaryShardSize() == null) {
            return true;
        }
        if ($this$evaluateConditions.getMinDocs() != null && $this$evaluateConditions.getMinDocs() <= numDocs) {
            return true;
        }
        if ($this$evaluateConditions.getMinAge() != null && $this$evaluateConditions.getMinAge().getMillis() <= indexAgeTimeValue.getMillis()) {
            return true;
        }
        if ($this$evaluateConditions.getMinSize() != null && $this$evaluateConditions.getMinSize().compareTo(indexSize) <= 0) {
            return true;
        }
        return $this$evaluateConditions.getMinPrimaryShardSize() != null && $this$evaluateConditions.getMinPrimaryShardSize().compareTo(primaryShardSize) <= 0;
    }

    @NotNull
    public static final StateMetaData getUpdatedStateMetaData(@NotNull State $this$getUpdatedStateMetaData, @NotNull ManagedIndexMetaData managedIndexMetaData) {
        Intrinsics.checkNotNullParameter((Object)$this$getUpdatedStateMetaData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
        return stateMetaData == null ? new StateMetaData($this$getUpdatedStateMetaData.getName(), Instant.now().toEpochMilli()) : (!Intrinsics.areEqual((Object)stateMetaData.getName(), (Object)$this$getUpdatedStateMetaData.getName()) ? new StateMetaData($this$getUpdatedStateMetaData.getName(), Instant.now().toEpochMilli()) : stateMetaData);
    }

    @Nullable
    public static final Pair<Boolean, Long> shouldBackoff(@NotNull Action $this$shouldBackoff, @Nullable ActionMetaData actionMetaData, @Nullable ActionRetry actionRetry) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBackoff, (String)"<this>");
        ActionRetry actionRetry2 = $this$shouldBackoff.getConfigRetry();
        return actionRetry2 != null && (actionRetry2 = actionRetry2.getBackoff()) != null ? actionRetry2.shouldBackoff(actionMetaData, actionRetry) : null;
    }

    public static final boolean hasTimedOut(@NotNull Action $this$hasTimedOut, @Nullable ActionMetaData actionMetaData) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTimedOut, (String)"<this>");
        ActionMetaData actionMetaData2 = actionMetaData;
        Long startTime = actionMetaData2 != null ? actionMetaData2.getStartTime() : null;
        ActionTimeout configTimeout = $this$hasTimedOut.getConfigTimeout();
        if (startTime == null || configTimeout == null) {
            return false;
        }
        return Instant.now().toEpochMilli() - startTime > configTimeout.getTimeout().getMillis();
    }

    @NotNull
    public static final ManagedIndexMetaData getStartingManagedIndexMetaData(@NotNull ManagedIndexMetaData $this$getStartingManagedIndexMetaData, @Nullable State state, @Nullable Action action, @Nullable Step step) {
        Intrinsics.checkNotNullParameter((Object)$this$getStartingManagedIndexMetaData, (String)"<this>");
        if (state == null) {
            PolicyRetryInfoMetaData policyRetryInfoMetaData = new PolicyRetryInfoMetaData(true, 0);
            String string = $this$getStartingManagedIndexMetaData.getTransitionTo();
            if (string == null) {
                string = $this$getStartingManagedIndexMetaData.getStateMetaData();
            }
            return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getStartingManagedIndexMetaData, null, null, null, null, null, null, null, null, null, null, null, null, (PolicyRetryInfoMetaData)policyRetryInfoMetaData, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Failed to find state=" + string + " in policy=" + $this$getStartingManagedIndexMetaData.getPolicyID()))), null, (long)0L, (long)0L, null, (int)249855, null);
        }
        if (action == null || step == null) {
            return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getStartingManagedIndexMetaData, null, null, null, null, null, null, null, null, null, null, null, null, (PolicyRetryInfoMetaData)new PolicyRetryInfoMetaData(true, 0), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Failed to find action=" + $this$getStartingManagedIndexMetaData.getActionMetaData() + " in state=" + $this$getStartingManagedIndexMetaData.getStateMetaData()))), null, (long)0L, (long)0L, null, (int)249855, null);
        }
        StateMetaData updatedStateMetaData = ManagedIndexUtils.getUpdatedStateMetaData(state, $this$getStartingManagedIndexMetaData);
        ActionMetaData updatedActionMetaData = action.getUpdatedActionMetadata($this$getStartingManagedIndexMetaData, state.getName());
        StepMetaData updatedStepMetaData = step.getStartingStepMetaData($this$getStartingManagedIndexMetaData);
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getStartingManagedIndexMetaData, null, null, null, null, null, null, null, null, null, (StateMetaData)updatedStateMetaData, (ActionMetaData)updatedActionMetaData, (StepMetaData)updatedStepMetaData, null, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Starting action " + action.getType() + " and working on " + step.getName()))), null, (long)0L, (long)0L, null, (int)250367, null);
    }

    @NotNull
    public static final ManagedIndexMetaData getCompletedManagedIndexMetaData(@NotNull ManagedIndexMetaData $this$getCompletedManagedIndexMetaData, @NotNull Action action, @NotNull Step step) {
        ActionMetaData actionMetaData;
        Intrinsics.checkNotNullParameter((Object)$this$getCompletedManagedIndexMetaData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        ManagedIndexMetaData updatedStepMetaData = step.getUpdatedManagedIndexMetadata($this$getCompletedManagedIndexMetaData);
        ActionMetaData actionMetaData2 = updatedStepMetaData.getActionMetaData();
        if (actionMetaData2 == null) {
            return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getCompletedManagedIndexMetaData, null, null, null, null, null, null, null, null, null, null, null, null, (PolicyRetryInfoMetaData)new PolicyRetryInfoMetaData(true, 0), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)"Failed due to ActionMetaData being null")), null, (long)0L, (long)0L, null, (int)249855, null);
        }
        ActionMetaData actionMetaData3 = actionMetaData2;
        StepMetaData stepMetaData = updatedStepMetaData.getStepMetaData();
        if ((stepMetaData != null ? stepMetaData.getStepStatus() : null) == Step.StepStatus.FAILED) {
            if (action.getConfigRetry() == null) {
                actionMetaData = ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)true, (int)0, null, null, (int)119, null);
            } else {
                long l = actionMetaData3.getConsumedRetries();
                ActionRetry actionRetry = action.getConfigRetry();
                Intrinsics.checkNotNull((Object)actionRetry);
                actionMetaData = l >= actionRetry.getCount() ? ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)true, (int)0, null, null, (int)119, null) : ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)false, (int)(actionMetaData3.getConsumedRetries() + 1), (Long)Instant.now().toEpochMilli(), null, (int)71, null);
            }
        } else {
            actionMetaData = actionMetaData3;
        }
        ActionMetaData updatedActionMetaData = actionMetaData;
        Boolean bl = updatedStepMetaData.getPolicyCompleted();
        Boolean bl2 = updatedStepMetaData.getRolledOver();
        String string = updatedStepMetaData.getRolledOverIndexName();
        StepMetaData stepMetaData2 = updatedStepMetaData.getStepMetaData();
        String string2 = updatedStepMetaData.getTransitionTo();
        PolicyRetryInfoMetaData policyRetryInfoMetaData = updatedStepMetaData.getPolicyRetryInfo();
        Map map = updatedStepMetaData.getInfo();
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getCompletedManagedIndexMetaData, null, null, null, null, null, (Boolean)bl, (Boolean)bl2, null, (String)string2, null, (ActionMetaData)updatedActionMetaData, (StepMetaData)stepMetaData2, (PolicyRetryInfoMetaData)policyRetryInfoMetaData, (Map)map, null, (long)0L, (long)0L, (String)string, (int)115359, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuccessfulDelete(@NotNull ManagedIndexMetaData $this$isSuccessfulDelete) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuccessfulDelete, (String)"<this>");
        ActionMetaData actionMetaData = $this$isSuccessfulDelete.getActionMetaData();
        if (!Intrinsics.areEqual((Object)(actionMetaData != null ? actionMetaData.getName() : null), (Object)"delete")) return false;
        ActionMetaData actionMetaData2 = $this$isSuccessfulDelete.getActionMetaData();
        Intrinsics.checkNotNull((Object)actionMetaData2);
        if (actionMetaData2.getFailed()) return false;
        StepMetaData stepMetaData = $this$isSuccessfulDelete.getStepMetaData();
        if (!Intrinsics.areEqual((Object)(stepMetaData != null ? stepMetaData.getName() : null), (Object)"delete")) return false;
        StepMetaData stepMetaData2 = $this$isSuccessfulDelete.getStepMetaData();
        Intrinsics.checkNotNull((Object)stepMetaData2);
        if (stepMetaData2.getStepStatus() != Step.StepStatus.COMPLETED) return false;
        PolicyRetryInfoMetaData policyRetryInfoMetaData = $this$isSuccessfulDelete.getPolicyRetryInfo();
        if (policyRetryInfoMetaData == null) return true;
        if (!policyRetryInfoMetaData.getFailed()) return true;
        return false;
    }

    public static final boolean isFailed(@NotNull ManagedIndexMetaData $this$isFailed) {
        Intrinsics.checkNotNullParameter((Object)$this$isFailed, (String)"<this>");
        PolicyRetryInfoMetaData policyRetryInfoMetaData = $this$isFailed.getPolicyRetryInfo();
        boolean bl = policyRetryInfoMetaData != null ? policyRetryInfoMetaData.getFailed() : false;
        if (bl) {
            return true;
        }
        ActionMetaData actionMetaData = $this$isFailed.getActionMetaData();
        return actionMetaData != null ? actionMetaData.getFailed() : false;
    }

    public static final boolean isPolicyCompleted(@NotNull ManagedIndexMetaData $this$isPolicyCompleted) {
        Intrinsics.checkNotNullParameter((Object)$this$isPolicyCompleted, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isPolicyCompleted.getPolicyCompleted(), (Object)true);
    }

    public static final boolean shouldChangePolicy(@NotNull ManagedIndexConfig $this$shouldChangePolicy, @Nullable Action actionToExecute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldChangePolicy, (String)"<this>");
        if ($this$shouldChangePolicy.getChangePolicy() == null) {
            return false;
        }
        if ($this$shouldChangePolicy.getChangePolicy().isSafe()) {
            return true;
        }
        Action action = actionToExecute;
        return Intrinsics.areEqual((Object)(action != null ? action.getType() : null), (Object)"transition");
    }

    public static final boolean hasDifferentPolicyVersion(@NotNull ManagedIndexMetaData $this$hasDifferentPolicyVersion, @NotNull ManagedIndexConfig managedIndexConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDifferentPolicyVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)managedIndexConfig, (String)"managedIndexConfig");
        return !Intrinsics.areEqual((Object)$this$hasDifferentPolicyVersion.getPolicySeqNo(), (Object)managedIndexConfig.getPolicySeqNo()) || !Intrinsics.areEqual((Object)$this$hasDifferentPolicyVersion.getPolicyPrimaryTerm(), (Object)managedIndexConfig.getPolicyPrimaryTerm());
    }

    public static final boolean hasDifferentJobInterval(@NotNull ManagedIndexConfig $this$hasDifferentJobInterval, int jobInterval) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDifferentJobInterval, (String)"<this>");
        Schedule schedule = $this$hasDifferentJobInterval.getSchedule();
        if (schedule instanceof IntervalSchedule) {
            return ((IntervalSchedule)schedule).getInterval() != jobInterval;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isSafeToChange(@NotNull Policy $this$isSafeToChange, @Nullable String stateName, @NotNull Policy newPolicy, @NotNull ChangePolicy changePolicy) {
        Object v1;
        State currentState;
        block9: {
            Object object;
            Object object22;
            block8: {
                Intrinsics.checkNotNullParameter((Object)$this$isSafeToChange, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)newPolicy, (String)"newPolicy");
                Intrinsics.checkNotNullParameter((Object)changePolicy, (String)"changePolicy");
                if (stateName == null) {
                    return true;
                }
                if (changePolicy.getState() != null) {
                    return false;
                }
                Iterable iterable = $this$isSafeToChange.getStates();
                for (Object object22 : iterable) {
                    State it = (State)object22;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)stateName)) continue;
                    object = object22;
                    break block8;
                }
                object = null;
            }
            currentState = (State)object;
            Iterable iterable = newPolicy.getStates();
            object22 = iterable.iterator();
            while (object22.hasNext()) {
                Object e = object22.next();
                State it = (State)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)stateName)) continue;
                v1 = e;
                break block9;
            }
            v1 = null;
        }
        State newState = v1;
        if (currentState == null || newState == null) {
            return false;
        }
        if (currentState.getActions().size() != newState.getActions().size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = currentState.getActions();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void action;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Action action2 = (Action)item$iv;
            int index2 = n;
            boolean bl = false;
            Action newStateAction = newState.getActions().get(index2);
            if (Intrinsics.areEqual((Object)action.getType(), (Object)newStateAction.getType())) continue;
            return false;
        }
        return true;
    }

    public static final boolean isAllowed(@NotNull Action $this$isAllowed, @NotNull List<String> allowList) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowed, (String)"<this>");
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        return allowList.contains($this$isAllowed.getType());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getManagedIndexConfig(@NotNull String indexUuid, @NotNull Client client, @NotNull Continuation<? super ManagedIndexConfig> $completion) {
        if (!($completion instanceof getManagedIndexConfig.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ManagedIndexUtils.getManagedIndexConfig(null, null, (Continuation<? super ManagedIndexConfig>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                request = ((GetRequest)new GetRequest().routing(indexUuid).index(".opendistro-ism-config")).id(indexUuid);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)indexUuid);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getManagedIndexConfig$lambda$4(org.opensearch.action.get.GetRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((GetRequest)request), $continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                request = (GetRequest)$continuation.L$2;
                client = (Client)$continuation.L$1;
                indexUuid = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                response = (GetResponse)v0;
                managedIndexConfig = new Ref.ObjectRef();
                v1 = configSource = response.getSourceAsBytesRef();
                if (v1 == null) break;
                it = v1;
                $i$a$-let-ManagedIndexUtils$getManagedIndexConfig$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)indexUuid);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$4 = managedIndexConfig;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)configSource);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)it);
                $continuation.I$0 = $i$a$-let-ManagedIndexUtils$getManagedIndexConfig$2;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(configSource, (Ref.ObjectRef<ManagedIndexConfig>)managedIndexConfig, response, null){
                    int label;
                    final /* synthetic */ BytesReference $configSource;
                    final /* synthetic */ Ref.ObjectRef<ManagedIndexConfig> $managedIndexConfig;
                    final /* synthetic */ GetResponse $response;
                    {
                        this.$configSource = $configSource;
                        this.$managedIndexConfig = $managedIndexConfig;
                        this.$response = $response;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)this.$configSource, (MediaType)((MediaType)XContentType.JSON));
                                Intrinsics.checkNotNull((Object)xcp);
                                String string = this.$response.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                                this.$managedIndexConfig.element = OpenSearchExtensionsKt.parseWithType(xcp, string, this.$response.getSeqNo(), this.$response.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, ManagedIndexConfig>((Object)ManagedIndexConfig.Companion){

                                    public final ManagedIndexConfig invoke(XContentParser p0, String p1, long p2, long p3) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                        return ((ManagedIndexConfig.Companion)this.receiver).parse(p0, p1, p2, p3);
                                    }
                                });
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var11_5) {
                    return var11_5;
                }
                break;
            }
            case 2: {
                $i$a$-let-ManagedIndexUtils$getManagedIndexConfig$2 = $continuation.I$0;
                it = (BytesReference)$continuation.L$6;
                configSource = (BytesReference)$continuation.L$5;
                managedIndexConfig = (Ref.ObjectRef)$continuation.L$4;
                response = (GetResponse)$continuation.L$3;
                request = (GetRequest)$continuation.L$2;
                client = (Client)$continuation.L$1;
                indexUuid = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                break;
            }
        }
        return managedIndexConfig.element;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final long getIntervalFromManagedIndexConfig(@NotNull ManagedIndexConfig managedIndexConfig) {
        Intrinsics.checkNotNullParameter((Object)managedIndexConfig, (String)"managedIndexConfig");
        Tuple periodTuple = managedIndexConfig.getJobSchedule().getPeriodStartingAt(Instant.now());
        return ((Instant)periodTuple.v2()).toEpochMilli() - ((Instant)periodTuple.v1()).toEpochMilli();
    }

    private static final Unit getManagedIndexConfig$lambda$4(GetRequest $request, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.get($request, it);
        return Unit.INSTANCE;
    }
}

