/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;

@SdkInternalApi
public class StaticKeyAttributeMetadata
implements KeyAttributeMetadata {
    private final String name;
    private final AttributeValueType attributeValueType;

    private StaticKeyAttributeMetadata(String name, AttributeValueType attributeValueType) {
        this.name = name;
        this.attributeValueType = attributeValueType;
    }

    public static StaticKeyAttributeMetadata create(String name, AttributeValueType attributeValueType) {
        return new StaticKeyAttributeMetadata(name, attributeValueType);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public AttributeValueType attributeValueType() {
        return this.attributeValueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticKeyAttributeMetadata staticKey = (StaticKeyAttributeMetadata)o;
        if (this.name != null ? !this.name.equals(staticKey.name) : staticKey.name != null) {
            return false;
        }
        return this.attributeValueType == staticKey.attributeValueType;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.attributeValueType != null ? this.attributeValueType.hashCode() : 0);
        return result;
    }
}

