/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.TimeUnit;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.ShardsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class ShardsRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, ShardsRequest> {
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<String> index;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<ShardsRequest, ShardsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ShardsRequest, ShardsResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cat/shards";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat/shards/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, ShardsResponse._DESERIALIZER);

    private ShardsRequest(Builder builder) {
        super(builder);
        this.bytes = builder.bytes;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.masterTimeout = builder.masterTimeout;
        this.time = builder.time;
    }

    public static ShardsRequest of(Function<Builder, ObjectBuilder<ShardsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.bytes != null) {
            params.put("bytes", this.bytes.jsonValue());
        }
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.time != null) {
            params.put("time", this.time.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.bytes);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.time);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardsRequest other = (ShardsRequest)o;
        return Objects.equals(this.bytes, other.bytes) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.index, other.index) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.time, other.time);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ShardsRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<String> index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(ShardsRequest o) {
            super(o);
            this.bytes = o.bytes;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.time = o.time;
        }

        private Builder(Builder o) {
            super(o);
            this.bytes = o.bytes;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.time = o.time;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardsRequest build() {
            this._checkSingleUse();
            return new ShardsRequest(this);
        }
    }
}

