/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javajs.util.BS;
import javajs.util.Lst;
import javax.swing.JCheckBoxMenuItem;
import org.jmol.util.JSONWriter;
import org.openscience.jmol.app.janocchio.CoupleTable;
import org.openscience.jmol.app.janocchio.LoadMeasureThread;
import org.openscience.jmol.app.janocchio.Measure;
import org.openscience.jmol.app.janocchio.MeasureCouple;
import org.openscience.jmol.app.janocchio.MeasureDist;
import org.openscience.jmol.app.janocchio.MeasureNoe;
import org.openscience.jmol.app.janocchio.NMR_JmolPanel;
import org.openscience.jmol.app.janocchio.NMR_Viewer;
import org.openscience.jmol.app.janocchio.NmrMolecule;
import org.openscience.jmol.app.janocchio.NoeTable;

public class LoadMeasureThreadJSON
extends LoadMeasureThread {
    Map<String, Object> data;

    public LoadMeasureThreadJSON(NMR_JmolPanel nmrPanel, Map<String, Object> jsonData) {
        this.nmrPanel = nmrPanel;
        this.data = jsonData;
    }

    @Override
    protected void setMore() {
        if (!this.data.containsKey("NamfisPopulation")) {
            return;
        }
        Lst populations = (Lst)this.data.get("NamfisPopulation");
        if (populations.size() > 0) {
            int i;
            int nmodel = ((NMR_Viewer)this.nmrPanel.vwr).getModelCount();
            double[] population = new double[nmodel + 1];
            for (i = 0; i <= nmodel; ++i) {
                population[i] = 0.0;
            }
            for (i = 0; i < populations.size(); ++i) {
                double pop;
                Map p = (Map)populations.get(i);
                int index = LoadMeasureThreadJSON.getInt(p, "index");
                population[index] = pop = this.getDouble(p, "p");
            }
            this.nmrPanel.populationDisplay.addPopulation(population);
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)this.nmrPanel.getMenuItem("NMR.populationDisplayCheck");
            mi.setSelected(true);
        }
    }

    @Override
    protected void setNOEs() {
        if (!this.data.containsKey("NOEs")) {
            return;
        }
        Lst noes = (Lst)this.data.get("NOEs");
        for (int i = 0; i < noes.size(); ++i) {
            Map noe = (Map)noes.get(i);
            int ia = LoadMeasureThreadJSON.getInt(noe, "a");
            int ib = LoadMeasureThreadJSON.getInt(noe, "b");
            String exp = (String)noe.get("exp");
            String expd = (String)noe.get("expd");
            this.addNOE(ia, ib, exp, expd);
        }
        if (this.data.containsKey("RefNOE")) {
            int[] noeNPrefIndices = new int[2];
            Map refNOE = (Map)this.data.get("RefNOE");
            noeNPrefIndices[0] = LoadMeasureThreadJSON.getInt(refNOE, "a");
            noeNPrefIndices[1] = LoadMeasureThreadJSON.getInt(refNOE, "b");
            this.nmrPanel.noeTable.setNoeNPrefIndices(noeNPrefIndices);
        }
        if (this.data.containsKey("ExpRefNOEValue")) {
            double expRefValue = this.getDouble(this.data, "ExpRefNOEValue");
            this.nmrPanel.noeTable.setNoeExprefValue(expRefValue);
        }
        if (this.data.containsKey("CorrelationTime")) {
            double dval = this.getDouble(this.data, "CorrelationTime");
            this.nmrPanel.noeTable.setCorrelationTime(dval);
            this.nmrPanel.noeTable.noeParameterSelectionPanel.getTauField().setText(String.valueOf(dval));
        }
        if (this.data.containsKey("MixingTime")) {
            double dval = this.getDouble(this.data, "MixingTime");
            this.nmrPanel.noeTable.setMixingTime(dval);
            this.nmrPanel.noeTable.noeParameterSelectionPanel.gettMixField().setText(String.valueOf(dval));
        }
        if (this.data.containsKey("NMRfreq")) {
            double dval = this.getDouble(this.data, "NMRfreq");
            this.nmrPanel.noeTable.setNMRfreq(dval);
            this.nmrPanel.noeTable.noeParameterSelectionPanel.getFreqField().setText(String.valueOf(dval));
        }
        if (this.data.containsKey("RhoStar")) {
            double dval = this.getDouble(this.data, "RhoStar");
            this.nmrPanel.noeTable.setRhoStar(dval);
            this.nmrPanel.noeTable.noeParameterSelectionPanel.getRhoStarField().setText(String.valueOf(dval));
        }
        if (this.data.containsKey("NoeYellowValue")) {
            double dval = this.getDouble(this.data, "NoeYellowValue");
            this.nmrPanel.noeTable.setYellowValue(dval);
            this.nmrPanel.noeTable.noeColourSelectionPanel.getYellowField().setText(String.valueOf(dval));
        }
        if (this.data.containsKey("NoeRedValue")) {
            double dval = this.getDouble(this.data, "NoeRedValue");
            this.nmrPanel.noeTable.setRedValue(dval);
            this.nmrPanel.noeTable.noeColourSelectionPanel.getRedField().setText(String.valueOf(dval));
        }
        if (this.data.containsKey("CoupleYellowValue")) {
            double dval = this.getDouble(this.data, "CoupleYellowValue");
            this.nmrPanel.coupleTable.setYellowValue(dval);
            this.nmrPanel.coupleTable.coupleColourSelectionPanel.getYellowField().setText(String.valueOf(dval));
        }
        if (this.data.containsKey("CoupleRedValue")) {
            double dval = this.getDouble(this.data, "CoupleRedValue");
            this.nmrPanel.coupleTable.setRedValue(dval);
            this.nmrPanel.coupleTable.coupleColourSelectionPanel.getRedField().setText(String.valueOf(dval));
        }
    }

    @Override
    protected void setCouples() {
        if (!this.data.containsKey("Couples")) {
            return;
        }
        Lst couples = (Lst)this.data.get("Couples");
        for (int i = 0; i < couples.size(); ++i) {
            Map couple = (Map)couples.get(i);
            int ia = LoadMeasureThreadJSON.getInt(couple, "a");
            int ib = LoadMeasureThreadJSON.getInt(couple, "b");
            int ic = LoadMeasureThreadJSON.getInt(couple, "c");
            int id = LoadMeasureThreadJSON.getInt(couple, "d");
            String exp = (String)couple.get("exp");
            this.addCouple(ia, ib, ic, id, exp);
        }
    }

    @Override
    protected boolean setLabels() {
        if (!this.data.containsKey("Labels")) {
            return false;
        }
        Lst labels = (Lst)this.data.get("Labels");
        for (int i = 0; i < labels.size(); ++i) {
            Map label = (Map)labels.get(i);
            int j = LoadMeasureThreadJSON.getInt(label, "index");
            String l = (String)label.get("label");
            this.addCommand(j - 1, l);
        }
        return true;
    }

    private double getDouble(Map<String, Object> p, String key) {
        return ((Number)p.get(key)).doubleValue();
    }

    private static int getInt(Map<String, Object> noe, String key) {
        return ((Number)noe.get(key)).intValue();
    }

    public void writeNamfisFiles(String name) {
        Map<String, Object> nmrdata;
        File namfis1 = new File(name + ".in1");
        File namfis2 = new File(name + ".in2");
        File namfis3 = new File(name + ".in3");
        File namfisout = new File(name + ".out");
        String parent = namfis1.getParent();
        File filename = new File(parent + "/filename.dat");
        File optionfile = new File(parent + "/optionfile");
        String zipFileName = name + ".zip";
        Lst noes = new Lst();
        Lst couples = new Lst();
        try {
            nmrdata = this.getNmrDataJSON();
            noes = (Lst)nmrdata.get("NOEs");
            couples = (Lst)nmrdata.get("Couples");
        }
        catch (Exception e) {
            nmrdata = new Hashtable<String, Object>();
        }
        try {
            String exp;
            Map couple;
            int i;
            Map noe;
            BS[] mols = this.nmrPanel.getAllMolecules();
            PrintWriter out1 = new PrintWriter(new FileWriter(namfis1));
            String[] labelArray = this.nmrPanel.labelSetter.getLabelArray();
            int base = 0;
            for (int i2 = 0; i2 < mols.length; ++i2) {
                String b;
                String a;
                int n;
                NmrMolecule props = this.nmrPanel.getDistanceJMolecule(mols[i2], labelArray, true);
                props.calcNOEs();
                for (n = 0; n < noes.size(); ++n) {
                    String exp2;
                    noe = (Map)noes.get(n);
                    a = (String)noe.get("a");
                    b = (String)noe.get("b");
                    if (!noe.containsKey("expd") || (exp2 = (String)noe.get("expd")) == null) continue;
                    int j = new Integer(a) - 1;
                    int k = new Integer(b) - 1;
                    props.addJmolDistance(j + base, k + base);
                }
                for (n = 0; n < couples.size(); ++n) {
                    String exp3;
                    Map couple2 = (Map)couples.get(n);
                    a = (String)couple2.get("a");
                    b = (String)couple2.get("b");
                    String c = (String)couple2.get("c");
                    String d = (String)couple2.get("d");
                    if (!couple2.containsKey("exp") || (exp3 = (String)couple2.get("exp")) == null) continue;
                    int j = new Integer(a) - 1;
                    int k = new Integer(b) - 1;
                    int l = new Integer(c) - 1;
                    int m = new Integer(d) - 1;
                    props.addJmolCouple(j + base, k + base, l + base, m + base);
                }
                Vector<Double> vec = props.getDistances();
                vec.add(new Double(1.0));
                this.writeVector(vec, out1);
                vec = props.getCouples();
                vec.add(new Double(1.0));
                this.writeVector(vec, out1);
                base += mols[i2].cardinality();
            }
            out1.flush();
            out1.close();
            PrintWriter out2 = new PrintWriter(new FileWriter(namfis2));
            DecimalFormat df = new DecimalFormat("#0.00  ");
            out2.print("-1\n");
            int nnoe = 0;
            for (int i3 = 0; i3 < noes.size(); ++i3) {
                noe = (Map)noes.get(i3);
                if (!noe.containsKey("expd")) continue;
                ++nnoe;
            }
            int ncouple = 0;
            for (i = 0; i < couples.size(); ++i) {
                couple = (Map)couples.get(i);
                if (!couple.containsKey("exp")) continue;
                ++ncouple;
            }
            out2.print(++ncouple + " " + ++nnoe + " 0\n");
            for (i = 0; i < noes.size(); ++i) {
                Map noe2 = (Map)noes.get(i);
                if (!noe2.containsKey("expd") || (exp = (String)noe2.get("expd")) == null) continue;
                out2.print(df.format(Double.valueOf(exp)) + " " + 0.4 + "\n");
            }
            out2.print("1.0 0.4\n");
            out2.print("\n");
            for (i = 0; i < couples.size(); ++i) {
                couple = (Map)couples.get(i);
                if (!couple.containsKey("exp")) continue;
                exp = (String)couple.get("exp");
                out2.print(exp + " ");
            }
            out2.print(1.0);
            out2.print("\n");
            for (i = 0; i < couples.size(); ++i) {
                couple = (Map)couples.get(i);
                if (!couple.containsKey("exp")) continue;
                out2.print("2.0 ");
            }
            out2.print(0.5);
            out2.print("\n");
            out2.print("\n");
            out2.print("1.0 1.0\n");
            out2.print("5.0\n");
            out2.print("0\n");
            out2.flush();
            out2.close();
            PrintWriter out3 = new PrintWriter(new FileWriter(namfis3));
            out3.flush();
            out3.close();
            PrintWriter out4 = new PrintWriter(new FileWriter(filename));
            out4.print(namfis1.getName() + "\n");
            out4.print(namfis2.getName() + "\n");
            out4.print(namfisout.getName() + "\n");
            out4.print(namfis3.getName() + "\n");
            out4.flush();
            out4.close();
            PrintWriter out5 = new PrintWriter(new FileWriter(optionfile));
            out5.print("  Begin\n");
            out5.print("    NoList\n");
            out5.print("    Derivative level          3\n");
            out5.print("    Verify                   No\n");
            out5.print("    Infinite step size      1.0d+20\n");
            out5.print("    step limit              1.0d-02\n");
            out5.print("    Major iterations limit    200\n");
            out5.print("    Minor iterations limit   2000\n");
            out5.print("    Major print level         10\n");
            out5.print("    Function precision        1.0d-20\n");
            out5.print("    Optimality Tolerance      1.0d-20\n");
            out5.print("    Linear Feasibility Tolerance 1.0d-2\n");
            out5.print("  end\n");
            out5.flush();
            out5.close();
            Vector<String> inputFileNames = new Vector<String>();
            inputFileNames.add(namfis1.getAbsolutePath());
            inputFileNames.add(namfis2.getAbsolutePath());
            inputFileNames.add(namfis3.getAbsolutePath());
            inputFileNames.add(filename.getAbsolutePath());
            inputFileNames.add(optionfile.getAbsolutePath());
            this.writeZip(inputFileNames, zipFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeVector(Vector<?> vector, PrintWriter out) {
        DecimalFormat df = new DecimalFormat("0.000  ");
        int count = 0;
        for (int j = 0; j < vector.size(); ++j) {
            out.print(df.format(vector.get(j)));
            if (count++ != 10) continue;
            out.print("\n");
            count = 0;
        }
        if (count != 0) {
            out.print("\n");
        }
    }

    private void writeZip(Vector<String> v, String outFilename) {
        byte[] buf = new byte[2048];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            for (int i = 0; i < v.size(); ++i) {
                int len;
                FileInputStream in = new FileInputStream(v.get(i));
                out.putNextEntry(new ZipEntry(v.get(i)));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("Error Writing zip....");
            e.printStackTrace();
        }
    }

    public void writeNmrDataJSON(File file) throws Exception {
        JSONWriter writer = new JSONWriter();
        writer.setStream(new FileOutputStream(file));
        writer.writeMap(this.getNmrDataJSON());
        writer.closeStream();
    }

    public Map<String, Object> getNmrDataJSON() {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put("StructureFile", this.nmrPanel.vwr.getModelSetPathName());
        Lst labels = new Lst();
        String[] labelArray = this.nmrPanel.labelSetter.getLabelArray();
        for (int i = 0; i < labelArray.length; ++i) {
            if (labelArray[i] == null) continue;
            Hashtable<String, String> l = new Hashtable<String, String>();
            l.put("index", String.valueOf(i + 1));
            l.put("label", labelArray[i]);
            labels.addLast(l);
        }
        data.put("Labels", labels);
        NoeTable noeTable = this.nmrPanel.noeTable;
        Lst noes = new Lst();
        int noeCount = noeTable.getRowCount();
        for (int i = 0; i < noeCount; ++i) {
            int[] atomIndices = noeTable.getMeasurementCountPlusIndices(i);
            Hashtable<String, String> n = new Hashtable<String, String>();
            n.put("a", String.valueOf(atomIndices[1] + 1));
            n.put("b", String.valueOf(atomIndices[2] + 1));
            n.put("exp", noeTable.getExpNoe(atomIndices[1], atomIndices[2]));
            n.put("expd", noeTable.getExpDist(atomIndices[1], atomIndices[2]));
            noes.addLast(n);
        }
        data.put("NOEs", noes);
        CoupleTable coupleTable = this.nmrPanel.coupleTable;
        int coupleCount = coupleTable.getRowCount();
        Lst couples = new Lst();
        for (int i = 0; i < coupleCount; ++i) {
            int[] atomIndices = coupleTable.getMeasurementCountPlusIndices(i);
            Hashtable<String, String> c = new Hashtable<String, String>();
            c.put("a", String.valueOf(atomIndices[1] + 1));
            c.put("b", String.valueOf(atomIndices[2] + 1));
            c.put("c", String.valueOf(atomIndices[3] + 1));
            c.put("d", String.valueOf(atomIndices[4] + 1));
            c.put("exp", coupleTable.getExpCouple(atomIndices[1], atomIndices[4]));
            couples.addLast(c);
        }
        data.put("Couples", couples);
        int[] noeNPrefIndices = noeTable.getnoeNPrefIndices();
        Hashtable<String, Integer> refNOE = new Hashtable<String, Integer>();
        refNOE.put("a", new Integer(noeNPrefIndices[0]));
        refNOE.put("b", new Integer(noeNPrefIndices[1]));
        data.put("RefNOE", refNOE);
        double noeExprefValue = noeTable.getNoeExprefValue();
        data.put("ExpRefNOEValue", Double.toString(noeExprefValue));
        data.put("CorrelationTime", Double.toString(noeTable.getCorrelationTime()));
        data.put("MixingTime", Double.toString(noeTable.getMixingTime()));
        data.put("NMRfreq", Double.toString(noeTable.getNMRfreq()));
        data.put("Cutoff", Double.toString(noeTable.getCutoff()));
        data.put("RhoStar", Double.toString(noeTable.getRhoStar()));
        data.put("NoeRedValue", Double.toString(noeTable.getRedValue()));
        data.put("NoeYellowValue", Double.toString(noeTable.getYellowValue()));
        data.put("CoupleRedValue", Double.toString(coupleTable.getRedValue()));
        data.put("CoupleYellowValue", Double.toString(coupleTable.getYellowValue()));
        double[] population = this.nmrPanel.populationDisplay.getPopulation();
        int populationLength = 0;
        if (population != null) {
            populationLength = population.length;
        }
        Lst populations = new Lst();
        for (int i = 0; i < populationLength; ++i) {
            if (!(population[i] > 0.0)) continue;
            Hashtable<String, Object> p = new Hashtable<String, Object>();
            p.put("index", i);
            p.put("p", String.valueOf(population[i]));
            populations.addLast(p);
        }
        data.put("NamfisPopulation", populations);
        return data;
    }

    public int jumpBestFrame() {
        Map<String, Object> nmrdata = new LoadMeasureThreadJSON(this.nmrPanel, null).getNmrDataJSON();
        Lst noes = (Lst)nmrdata.get("NOEs");
        Lst couples = (Lst)nmrdata.get("Couples");
        try {
            BS[] mols = this.nmrPanel.getAllMolecules();
            String[] labelArray = this.nmrPanel.labelSetter.getLabelArray();
            double noeWeight = this.nmrPanel.frameDeltaDisplay.getNoeWeight();
            double coupleWeight = this.nmrPanel.frameDeltaDisplay.getCoupleWeight();
            boolean lexpNoes = this.nmrPanel.noeTable.getlexpNoes();
            double minDiff = Double.MAX_VALUE;
            int minFrame = -1;
            int base = 0;
            for (int i = 0; i < mols.length; ++i) {
                String b;
                String a;
                int n;
                NmrMolecule props = this.nmrPanel.getDistanceJMolecule(mols[i], labelArray, true);
                props.calcNOEs();
                double diffDist = 0.0;
                double diffNoe = 0.0;
                double diffCouple = 0.0;
                for (n = 0; n < noes.size(); ++n) {
                    Measure measure;
                    int k;
                    int j;
                    String exp;
                    Map noe = (Map)noes.get(n);
                    a = (String)noe.get("a");
                    b = (String)noe.get("b");
                    if (noe.containsKey("expd") && (exp = (String)noe.get("expd")) != null) {
                        j = new Integer(a) - 1;
                        k = new Integer(b) - 1;
                        double cDist = props.getJmolDistance(j + base, k + base);
                        measure = new MeasureDist(exp, cDist);
                        diffDist += measure.getDiff();
                    }
                    if (!noe.containsKey("exp") || (exp = (String)noe.get("exp")) == null) continue;
                    j = new Integer(a) - 1;
                    k = new Integer(b) - 1;
                    double cNoe = props.getJmolNoe(j + base, k + base);
                    measure = new MeasureNoe(exp, cNoe);
                    diffNoe += measure.getDiff();
                }
                for (n = 0; n < couples.size(); ++n) {
                    String exp;
                    Map couple = (Map)couples.get(n);
                    a = (String)couple.get("a");
                    b = (String)couple.get("b");
                    String c = (String)couple.get("c");
                    String d = (String)couple.get("d");
                    if (!couple.containsKey("exp") || (exp = (String)couple.get("exp")) == null) continue;
                    int j = new Integer(a) - 1;
                    int k = new Integer(b) - 1;
                    int l = new Integer(c) - 1;
                    int m = new Integer(d) - 1;
                    double[] cCouple = props.calcJmolCouple(j + base, k + base, l + base, m + base);
                    MeasureCouple measure = new MeasureCouple(exp, cCouple[1]);
                    diffCouple += measure.getDiff();
                }
                double diff = diffCouple * coupleWeight;
                diff = lexpNoes ? (diff += diffNoe * noeWeight) : (diff += diffDist * noeWeight);
                if (diff < minDiff) {
                    minDiff = diff;
                    minFrame = i;
                }
                base += mols[i].cardinality();
            }
            return minFrame + 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

