/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.processor;

import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.utils.IOUtils;

public class ShowInExplorerEventProcessor
implements IDataTransferEventProcessor<StreamTransferConsumer> {
    public static final String ID = "showInExplorer";

    @Override
    public void processEvent(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferEventProcessor.Event event, @NotNull StreamTransferConsumer consumer, @Nullable DBTTask task, @NotNull Map<String, Object> processorSettings) throws DBException {
        if (!consumer.getSettings().isOutputClipboard()) {
            String folder = consumer.getOutputFolder();
            String filename = consumer.getOutputFileName();
            Path finalFile = DBFUtils.resolvePathFromString((DBRProgressMonitor)monitor, (DBPProject)consumer.getProject(), (String)folder).resolve(filename);
            if (IOUtils.isLocalURI((URI)finalFile.toUri())) {
                String finalPath = finalFile.toAbsolutePath().toString();
                DBWorkbench.getPlatformUI().showInSystemExplorer(finalPath);
            }
        }
    }
}

