/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.api;

import java.util.Objects;
import org.jkiss.code.NotNull;

public final class CompositeObjectId {
    @NotNull
    private final String primaryId;
    @NotNull
    private final String secondaryId;

    public CompositeObjectId(@NotNull String primaryId, @NotNull String secondaryId) {
        this.primaryId = primaryId;
        this.secondaryId = secondaryId;
    }

    @NotNull
    public static CompositeObjectId of(@NotNull String shortId) {
        String[] parts = shortId.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid object reference: " + shortId + ", must be in a form of primary-id:secondary-id");
        }
        return new CompositeObjectId(parts[0], parts[1]);
    }

    @NotNull
    public String shortId() {
        return this.primaryId + ":" + this.secondaryId;
    }

    public String toString() {
        return this.shortId();
    }

    @NotNull
    public String primaryId() {
        return this.primaryId;
    }

    @NotNull
    public String secondaryId() {
        return this.secondaryId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompositeObjectId that = (CompositeObjectId)obj;
        return Objects.equals(this.primaryId, that.primaryId) && Objects.equals(this.secondaryId, that.secondaryId);
    }

    public int hashCode() {
        return Objects.hash(this.primaryId, this.secondaryId);
    }
}

