/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import java.util.Collection;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class LicenseAnalyzer
extends IUAnalyzer {
    @Override
    public void analyzeIU(IInstallableUnit iu) {
        if (Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.group"))) {
            Collection licenses = iu.getLicenses();
            if (iu.getLicenses() == null || licenses.size() == 0) {
                this.error(iu, "[ERROR] " + iu.getId() + " has no license");
                return;
            }
            if (((ILicense)licenses.iterator().next()).getBody().length() == 0) {
                this.error(iu, "[ERROR] " + iu.getId() + " has no license");
                return;
            }
            for (ILicense license : licenses) {
                String licenseProperty;
                if (!license.getBody().startsWith("%") || iu.getProperty("df_LT." + (licenseProperty = license.getBody().substring(1))) != null) continue;
                this.error(iu, "[ERROR] " + iu.getId() + " has no license");
            }
        }
    }

    @Override
    public void preAnalysis(IMetadataRepository repository) {
    }
}

