/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.resolver.ResolutionException;

public abstract class SystemModule
extends Module {
    private volatile AtomicReference<ModuleContainerAdaptor.ContainerEvent> forStop = new AtomicReference();

    public SystemModule(ModuleContainer container) {
        super(0L, "System Bundle", container, EnumSet.of(Module.Settings.AUTO_START, Module.Settings.USE_ACTIVATION_POLICY), 0);
    }

    public final void init() throws BundleException {
        this.getRevisions().getContainer().checkAdminPermission(this.getBundle(), "execute");
        boolean lockedStarted = false;
        this.inStart.incrementAndGet();
        try {
            this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
            lockedStarted = true;
            this.getContainer().getAdaptor().initBegin();
            this.checkValid();
            if (ACTIVE_SET.contains((Object)this.getState())) {
                return;
            }
            this.getRevisions().getContainer().open();
            if (this.getState().equals((Object)Module.State.INSTALLED)) {
                ResolutionReport report;
                this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                lockedStarted = false;
                try {
                    report = this.getRevisions().getContainer().resolve(Collections.singletonList(this), true);
                }
                finally {
                    this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                    lockedStarted = true;
                }
                this.checkValid();
                ResolutionException e = report.getResolutionException();
                if (e != null && e.getCause() instanceof BundleException) {
                    throw (BundleException)e.getCause();
                }
                if (ACTIVE_SET.contains((Object)this.getState())) {
                    return;
                }
                if (this.getState().equals((Object)Module.State.INSTALLED)) {
                    String reportMessage = report.getResolutionReportMessage(this.getCurrentRevision());
                    throw new BundleException(String.valueOf(Msg.Module_ResolveError) + reportMessage, 4);
                }
            }
            this.setState(Module.State.STARTING);
            AtomicReference<ModuleContainerAdaptor.ContainerEvent> existingForStop = this.forStop;
            if (existingForStop.get() != null) {
                this.forStop = new AtomicReference();
            }
            this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STARTING);
            try {
                this.initWorker();
            }
            catch (Throwable t) {
                this.setState(Module.State.STOPPING);
                this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STOPPING);
                this.setState(Module.State.RESOLVED);
                this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STOPPED);
                this.getRevisions().getContainer().close();
                if (t instanceof BundleException) {
                    throw (BundleException)t;
                }
                throw new BundleException("Error initializing container.", 5, t);
            }
        }
        finally {
            this.getContainer().getAdaptor().initEnd();
            if (lockedStarted) {
                this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
            }
            this.inStart.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContainerAdaptor.ContainerEvent waitForStop(long timeout) throws InterruptedException {
        boolean waitForever = timeout == 0L;
        long start = System.currentTimeMillis();
        long timeLeft = timeout;
        AtomicReference<ModuleContainerAdaptor.ContainerEvent> stopEvent = null;
        Module.State currentState = null;
        boolean stateLocked = false;
        try {
            if (timeout == 0L) {
                this.stateChangeLock.lockInterruptibly();
                stateLocked = true;
            } else {
                stateLocked = this.stateChangeLock.tryLock(timeLeft, TimeUnit.MILLISECONDS);
            }
            if (stateLocked) {
                stopEvent = this.forStop;
                currentState = this.getState();
            }
        }
        finally {
            if (stateLocked) {
                this.stateChangeLock.unlock();
            }
        }
        if (stopEvent == null || currentState == null) {
            return ModuleContainerAdaptor.ContainerEvent.STOPPED_TIMEOUT;
        }
        if (!ACTIVE_SET.contains((Object)currentState)) {
            ModuleContainerAdaptor.ContainerEvent result = stopEvent.get();
            if (result != null) {
                return result;
            }
            return ModuleContainerAdaptor.ContainerEvent.STOPPED;
        }
        AtomicReference<ModuleContainerAdaptor.ContainerEvent> atomicReference = stopEvent;
        synchronized (atomicReference) {
            while (true) {
                ModuleContainerAdaptor.ContainerEvent result;
                if ((result = stopEvent.get()) != null) {
                    return result;
                }
                long l = timeLeft = waitForever ? 0L : start + timeout - System.currentTimeMillis();
                if (!waitForever && timeLeft <= 0L) break;
                stopEvent.wait(timeLeft);
            }
            return ModuleContainerAdaptor.ContainerEvent.STOPPED_TIMEOUT;
        }
    }

    protected void initWorker() throws BundleException {
    }

    @Override
    public void start(Module.StartOptions ... options) throws BundleException {
        this.init();
        super.start(Module.StartOptions.TRANSIENT, Module.StartOptions.USE_ACTIVATION_POLICY);
        this.getRevisions().getContainer().adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.STARTED, this, null, new FrameworkListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Module.StopOptions ... options) throws BundleException {
        block13: {
            ModuleContainerAdaptor.ContainerEvent containerEvent = ModuleContainerAdaptor.ContainerEvent.STOPPED_TIMEOUT;
            try {
                if (this.stateChangeLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        try {
                            super.stop(Module.StopOptions.TRANSIENT);
                        }
                        catch (BundleException e) {
                            this.getRevisions().getContainer().adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, this, e, new FrameworkListener[0]);
                        }
                        containerEvent = this.holdsTransitionEventLock(ModuleContainerAdaptor.ModuleEvent.UPDATED) ? ModuleContainerAdaptor.ContainerEvent.STOPPED_UPDATE : (this.holdsTransitionEventLock(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED) ? ModuleContainerAdaptor.ContainerEvent.STOPPED_REFRESH : ModuleContainerAdaptor.ContainerEvent.STOPPED);
                        this.getRevisions().getContainer().adaptor.publishContainerEvent(containerEvent, this, null, new FrameworkListener[0]);
                        this.getRevisions().getContainer().close();
                    }
                    catch (Throwable throwable) {
                        AtomicReference<ModuleContainerAdaptor.ContainerEvent> eventReference = this.forStop;
                        eventReference.compareAndSet(null, containerEvent);
                        this.stateChangeLock.unlock();
                        AtomicReference<ModuleContainerAdaptor.ContainerEvent> atomicReference = eventReference;
                        synchronized (atomicReference) {
                            eventReference.notifyAll();
                        }
                        throw throwable;
                    }
                    AtomicReference<ModuleContainerAdaptor.ContainerEvent> eventReference = this.forStop;
                    eventReference.compareAndSet(null, containerEvent);
                    this.stateChangeLock.unlock();
                    AtomicReference<ModuleContainerAdaptor.ContainerEvent> atomicReference = eventReference;
                    synchronized (atomicReference) {
                        eventReference.notifyAll();
                        break block13;
                    }
                }
                throw new BundleException(Msg.SystemModule_LockError);
            }
            catch (InterruptedException e) {
                this.getRevisions().getContainer().adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, this, e, new FrameworkListener[0]);
                throw new BundleException(String.valueOf(Msg.Module_LockError) + this.toString(), 7, e);
            }
        }
    }

    public void update() throws BundleException {
        Module.State previousState;
        this.getContainer().checkAdminPermission(this.getBundle(), "lifecycle");
        this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UPDATED);
        try {
            previousState = this.getState();
            this.stop(new Module.StopOptions[0]);
        }
        finally {
            this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UPDATED);
        }
        switch (previousState) {
            case STARTING: {
                this.init();
                break;
            }
            case ACTIVE: {
                this.start(new Module.StartOptions[0]);
            }
        }
    }

    @Override
    protected void startWorker() throws BundleException {
        super.startWorker();
        ((ModuleContainer.ContainerStartLevel)this.getRevisions().getContainer().getFrameworkStartLevel()).doContainerStartLevel(this, Integer.MIN_VALUE, new FrameworkListener[0]);
    }

    @Override
    protected void stopWorker() throws BundleException {
        super.stopWorker();
        ((ModuleContainer.ContainerStartLevel)this.getRevisions().getContainer().getFrameworkStartLevel()).doContainerStartLevel(this, 0, new FrameworkListener[0]);
    }
}

