/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;
import org.jkiss.dbeaver.registry.driver.DriverClassFindJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;
import org.jkiss.utils.CommonUtils;

public class PostgreSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private static final boolean ENABLE_PROXY = false;
    public static final String[] SSL_MODES = new String[]{"", "disable", "allow", "prefer", "require", "verify-ca", "verify-full"};
    private Combo sslModeCombo;
    private Combo sslFactoryCombo;
    private Button useProxyService;
    private boolean sslClassesResolved;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        this.createTrustStoreConfigGroup(composite);
        if (this.getEditIntention() != DBPConnectionEditIntention.CREDENTIALS_ONLY) {
            Group advGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.dialog_connection_network_postgres_ssl_advanced, (int)2, (int)768, (int)-1);
            this.sslModeCombo = UIUtils.createLabelCombo((Composite)advGroup, (String)PostgreMessages.dialog_connection_network_postgres_ssl_advanced_ssl_mode, (int)12);
            this.sslModeCombo.setLayoutData((Object)new GridData(32));
            String[] stringArray = SSL_MODES;
            int n = SSL_MODES.length;
            int n2 = 0;
            while (n2 < n) {
                String mode = stringArray[n2];
                this.sslModeCombo.add(mode);
                ++n2;
            }
            this.sslFactoryCombo = UIUtils.createLabelCombo((Composite)advGroup, (String)PostgreMessages.dialog_connection_network_postgres_ssl_advanced_ssl_factory, (int)4);
        }
    }

    protected boolean useCACertificate() {
        return true;
    }

    public void loadSettings(final @NotNull DBWHandlerConfiguration configuration) {
        super.loadSettings(configuration);
        if (CommonUtils.isEmpty((String)configuration.getStringProperty("ssl.method"))) {
            this.caCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("rootCert")));
            this.clientCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("clientCert")));
            this.clientKeyPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("clientKey")));
        }
        if (this.getEditIntention() != DBPConnectionEditIntention.CREDENTIALS_ONLY) {
            UIUtils.setComboSelection((Combo)this.sslModeCombo, (String)CommonUtils.notEmpty((String)configuration.getStringProperty("sslMode")));
            PaintListener paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (!PostgreSSLConfigurator.this.sslClassesResolved) {
                        PostgreSSLConfigurator.this.sslClassesResolved = true;
                        PostgreSSLConfigurator.this.sslFactoryCombo.removePaintListener((PaintListener)this);
                        Job resolveJob = new Job("Find factories"){
                            {
                                super($anonymous0);
                                this.setUser(true);
                            }

                            protected IStatus run(IProgressMonitor monitor) {
                                DriverClassFindJob finder = new DriverClassFindJob(configuration.getDriver(), SSLSocketFactory.class.getName(), false);
                                finder.run((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                                UIUtils.syncExec(() -> {
                                    (this).PostgreSSLConfigurator.this.sslFactoryCombo.removeAll();
                                    for (String cn : finder.getDriverClassNames()) {
                                        (this).PostgreSSLConfigurator.this.sslFactoryCombo.add(cn);
                                    }
                                    String factoryValue = configuration.getStringProperty("sslFactory");
                                    if (!CommonUtils.isEmpty((String)factoryValue)) {
                                        (this).PostgreSSLConfigurator.this.sslFactoryCombo.setText(factoryValue);
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                        };
                        resolveJob.schedule();
                    }
                }
            };
            this.sslFactoryCombo.addPaintListener(paintListener);
        }
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        if (this.getEditIntention() != DBPConnectionEditIntention.CREDENTIALS_ONLY) {
            configuration.setProperty("sslMode", (Object)this.sslModeCombo.getText());
            configuration.setProperty("sslFactory", (Object)this.sslFactoryCombo.getText());
        }
    }
}

