/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraintColumn;

public class DBVEntityConstraint
implements DBSEntityConstraint,
DBSEntityReferrer {
    @NotNull
    private final DBVEntity entity;
    private final List<DBVEntityConstraintColumn> attributes = new ArrayList<DBVEntityConstraintColumn>();
    private DBSEntityConstraintType type;
    private String name;
    private boolean useAllColumns = false;

    public DBVEntityConstraint(@NotNull DBVEntity entity, DBSEntityConstraintType type, String name) {
        this.entity = entity;
        this.type = type;
        this.name = name == null ? type.getName() : name;
    }

    public DBVEntityConstraint(@NotNull DBVEntity entity, DBVEntityConstraint copy) {
        this.entity = entity;
        this.type = copy.type;
        this.name = copy.name;
        for (DBVEntityConstraintColumn col : copy.attributes) {
            this.attributes.add(new DBVEntityConstraintColumn(this, col));
        }
        this.useAllColumns = copy.useAllColumns;
    }

    public List<DBVEntityConstraintColumn> getAttributeReferences(@Nullable DBRProgressMonitor monitor) {
        return this.attributes;
    }

    public List<DBVEntityConstraintColumn> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public DBVEntity getParentObject() {
        return this.entity;
    }

    @NotNull
    public DBVEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.entity.getDataSource();
    }

    @Override
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public boolean isUseAllColumns() {
        return this.useAllColumns;
    }

    public void setUseAllColumns(boolean useAllColumns) {
        this.useAllColumns = useAllColumns;
    }

    public boolean hasAttributes() {
        return this.useAllColumns || !this.attributes.isEmpty();
    }

    public void setAttributes(Collection<DBSEntityAttribute> realAttributes) {
        this.attributes.clear();
        for (DBSEntityAttribute attr : realAttributes) {
            this.attributes.add(new DBVEntityConstraintColumn(this, attr.getName()));
        }
    }

    public void addAttribute(String name) {
        this.attributes.add(new DBVEntityConstraintColumn(this, name));
    }

    @Nullable
    private DBSAttributeEnumerable getEnumAttr() {
        DBSEntityAttribute attribute;
        if (this.attributes.size() == 1 && (attribute = this.attributes.get(0).getAttribute()) instanceof DBSAttributeEnumerable) {
            return (DBSAttributeEnumerable)attribute;
        }
        return null;
    }
}

