/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.IPropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;

public class DataSourcePropertyFilter
implements IPropertyFilter {
    private static final Set<String> readExpPropertiesFor = new LinkedHashSet<String>();
    private final boolean showExpensive;

    public DataSourcePropertyFilter() {
        this((DBPDataSourceContainer)null);
    }

    public DataSourcePropertyFilter(DBPDataSource dataSource) {
        this(dataSource == null ? null : dataSource.getContainer());
    }

    public DataSourcePropertyFilter(DBPDataSourceContainer container) {
        DBPPreferenceStore store = container != null ? container.getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
        this.showExpensive = store.getBoolean("database.props.expensive");
    }

    @Override
    public boolean select(Object object, DBPPropertyDescriptor property) {
        if (property instanceof ObjectPropertyDescriptor) {
            ObjectPropertyDescriptor prop = (ObjectPropertyDescriptor)property;
            if (!prop.isExpensive() || this.showExpensive) {
                return true;
            }
            if (object instanceof DBSObject) {
                return DataSourcePropertyFilter.isExpensivePropertiesReadEnabledFor((DBSObject)object);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExpensivePropertiesReadEnabledFor(DBSObject object) {
        Set<String> set = readExpPropertiesFor;
        synchronized (set) {
            String objectFullId = DBUtils.getObjectFullId(object);
            return readExpPropertiesFor.contains(objectFullId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readExpensivePropertiesFor(DBSObject object, boolean read) {
        Set<String> set = readExpPropertiesFor;
        synchronized (set) {
            String objectFullId = DBUtils.getObjectFullId(object);
            if (read) {
                readExpPropertiesFor.add(objectFullId);
            } else {
                readExpPropertiesFor.remove(objectFullId);
            }
        }
    }
}

