/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model.data;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class ClickhouseGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final ClickhouseGeometryValueHandler INSTANCE = new ClickhouseGeometryValueHandler();
    private static final String TYPE_POINT = "point";
    private static final String TYPE_RING = "ring";
    private static final String TYPE_LINESTRING = "linestring";
    private static final String TYPE_MULTILINESTRING = "multilinestring";
    private static final String TYPE_POLYGON = "polygon";
    private static final String TYPE_MULTIPOLYGON = "multipolygon";

    private ClickhouseGeometryValueHandler() {
    }

    public static boolean isGeometryType(@NotNull String typeName) {
        return switch (typeName.toLowerCase(Locale.ROOT)) {
            case TYPE_MULTILINESTRING, TYPE_POLYGON, TYPE_RING, TYPE_POINT, TYPE_MULTIPOLYGON, TYPE_LINESTRING -> true;
            default -> false;
        };
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel());
        MultiLineString geometry = switch (type.getTypeName().toLowerCase(Locale.ROOT)) {
            case TYPE_POINT -> ClickhouseGeometryValueHandler.createPoint(factory, (double[])object);
            case TYPE_RING -> ClickhouseGeometryValueHandler.createRing(factory, (double[][])object);
            case TYPE_LINESTRING -> ClickhouseGeometryValueHandler.createLineString(factory, (double[][])object);
            case TYPE_MULTILINESTRING -> ClickhouseGeometryValueHandler.createMultiLineString(factory, (double[][][])object);
            case TYPE_POLYGON -> ClickhouseGeometryValueHandler.createPolygon(factory, (double[][][])object);
            case TYPE_MULTIPOLYGON -> ClickhouseGeometryValueHandler.createMultiPolygon(factory, (double[][][][])object);
            default -> throw new DBCException("Unexpected geo type: " + type.getTypeName(), null, session.getExecutionContext());
        };
        return new DBGeometry((Geometry)geometry);
    }

    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, resultSet.getObject(index), false, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        throw new DBCException("Editing of geo data is not yet supported", null, (DBCExecutionContext)session.getExecutionContext());
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    @NotNull
    private static Point createPoint(@NotNull GeometryFactory factory, @NotNull double[] object) {
        return factory.createPoint(new Coordinate(object[0], object[1]));
    }

    @NotNull
    private static LinearRing createRing(@NotNull GeometryFactory factory, @NotNull double[][] object) {
        Coordinate[] coordinates = (Coordinate[])Stream.concat(Arrays.stream(object), Arrays.stream(object).limit(1L)).map(point -> new Coordinate(point[0], point[1])).toArray(Coordinate[]::new);
        return factory.createLinearRing(coordinates);
    }

    @NotNull
    private static LineString createLineString(@NotNull GeometryFactory factory, @NotNull double[][] object) {
        Coordinate[] coordinates = (Coordinate[])Arrays.stream(object).map(point -> new Coordinate(point[0], point[1])).toArray(Coordinate[]::new);
        return factory.createLineString(coordinates);
    }

    @NotNull
    private static MultiLineString createMultiLineString(@NotNull GeometryFactory factory, @NotNull double[][][] object) {
        LineString[] lineStrings = (LineString[])Arrays.stream(object).map(lineString -> ClickhouseGeometryValueHandler.createLineString(factory, lineString)).toArray(LineString[]::new);
        return factory.createMultiLineString(lineStrings);
    }

    @NotNull
    private static Polygon createPolygon(@NotNull GeometryFactory factory, @NotNull double[][][] object) {
        List<LinearRing> rings = Arrays.stream(object).map(ring -> ClickhouseGeometryValueHandler.createRing(factory, ring)).toList();
        LinearRing shell = rings.get(0);
        LinearRing[] holes = (LinearRing[])rings.subList(1, rings.size()).toArray(LinearRing[]::new);
        return factory.createPolygon(shell, holes);
    }

    @NotNull
    private static MultiPolygon createMultiPolygon(@NotNull GeometryFactory factory, @NotNull double[][][][] object) {
        Polygon[] polygons = (Polygon[])Arrays.stream(object).map(polygon -> ClickhouseGeometryValueHandler.createPolygon(factory, polygon)).toArray(Polygon[]::new);
        return factory.createMultiPolygon(polygons);
    }
}

