/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DriverDependencies
implements DBPDriverDependencies {
    private static final Log log = Log.getLog(DriverDependencies.class);
    private final List<DBPDriverLibrary> rootLibraries;
    private final List<DBPDriverDependencies.DependencyNode> rootNodes = new ArrayList<DBPDriverDependencies.DependencyNode>();
    private final List<DBPDriverDependencies.DependencyNode> libraryList = new ArrayList<DBPDriverDependencies.DependencyNode>();

    public DriverDependencies(Collection<? extends DBPDriverLibrary> rootLibraries) {
        this.rootLibraries = new ArrayList<DBPDriverLibrary>(rootLibraries);
    }

    public void resolveDependencies(DBRProgressMonitor monitor) throws DBException {
        IOException lastError = null;
        this.rootNodes.clear();
        LinkedHashMap<String, DBPDriverDependencies.DependencyNode> libMap = new LinkedHashMap<String, DBPDriverDependencies.DependencyNode>();
        for (DBPDriverLibrary library : this.rootLibraries) {
            DBPDriverDependencies.DependencyNode node = new DBPDriverDependencies.DependencyNode(null, library);
            try {
                LinkedHashMap<String, DBPDriverDependencies.DependencyNode> localLibMap = new LinkedHashMap<String, DBPDriverDependencies.DependencyNode>();
                localLibMap.put(node.library.getId(), node);
                this.resolveDependencies(monitor, node, localLibMap);
                this.rootNodes.add(node);
                libMap.putAll(localLibMap);
            }
            catch (IOException e) {
                lastError = e;
                log.error((Object)("Error resolving library '" + library.getDisplayName() + "' dependencies"), (Throwable)e);
            }
        }
        this.libraryList.clear();
        this.libraryList.addAll(libMap.values());
        if (lastError != null) {
            throw new DBException("Error resolving dependencies", (Throwable)lastError);
        }
    }

    private void dumpNode(DBPDriverDependencies.DependencyNode node, int level) {
        if (node.duplicate) {
            return;
        }
        int i = 0;
        while (i < level) {
            System.out.print("\t");
            ++i;
        }
        System.out.println(node.library.getId() + ":" + node.library.getVersion());
        for (DBPDriverDependencies.DependencyNode child : node.dependencies) {
            this.dumpNode(child, level + 1);
        }
    }

    private void resolveDependencies(DBRProgressMonitor monitor, DBPDriverDependencies.DependencyNode ownerNode, Map<String, DBPDriverDependencies.DependencyNode> libMap) throws IOException {
        Collection dependencies = ownerNode.library.getDependencies(monitor);
        if (dependencies != null && !dependencies.isEmpty()) {
            for (DBPDriverLibrary dep : dependencies) {
                DBPDriverDependencies.DependencyNode node = new DBPDriverDependencies.DependencyNode(ownerNode, dep);
                DBPDriverDependencies.DependencyNode prevNode = libMap.get(node.library.getId());
                if (prevNode == null || prevNode.depth > node.depth) {
                    libMap.put(node.library.getId(), node);
                    if (prevNode != null) {
                        prevNode.duplicate = true;
                    }
                } else {
                    node.duplicate = true;
                }
                ownerNode.dependencies.add(node);
            }
            for (DBPDriverDependencies.DependencyNode node : ownerNode.dependencies) {
                if (node.duplicate) continue;
                this.resolveDependencies(monitor, node, libMap);
            }
        }
    }

    public List<DBPDriverDependencies.DependencyNode> getLibraryList() {
        return this.libraryList;
    }

    public List<DBPDriverDependencies.DependencyNode> getLibraryMap() {
        return this.rootNodes;
    }

    public void changeLibrary(DBPDriverLibrary oldLibrary, DBPDriverLibrary newLibrary) {
        int index = this.rootLibraries.indexOf(oldLibrary);
        if (index == -1) {
            this.rootLibraries.add(newLibrary);
        } else {
            this.rootLibraries.add(index, newLibrary);
            this.rootLibraries.remove(oldLibrary);
        }
    }
}

