/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.rules.EndOfLineRule;

public class LineCommentRule
extends EndOfLineRule {
    public LineCommentRule(String startSequence, TPToken token) {
        super(startSequence, token, '\u0000');
    }

    public LineCommentRule(String startSequence, TPToken token, char escapeCharacter) {
        super(startSequence, token, escapeCharacter);
    }

    public LineCommentRule(String startSequence, TPToken token, char escapeCharacter, boolean escapeContinuesLine) {
        super(startSequence, token, escapeCharacter, escapeContinuesLine);
    }

    public LineCommentRule(String startSequence, TPToken token, char escapeCharacter, boolean escapeContinuesLine, boolean excludeLineDelimiter) {
        super(startSequence, token, escapeCharacter, escapeContinuesLine, excludeLineDelimiter);
    }

    @Override
    protected TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
        int c;
        if (resume ? this.endSequenceDetected(scanner) : Character.toUpperCase(c = scanner.read()) == Character.toUpperCase(this.fStartSequence[0]) && this.sequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (Character.toUpperCase(c) == Character.toUpperCase(this.fStartSequence[0])) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : TPTokenAbstract.UNDEFINED;
        }
        return TPTokenAbstract.UNDEFINED;
    }

    @Override
    protected boolean sequenceDetected(TPCharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (Character.toUpperCase(c) != Character.toUpperCase(sequence[i])) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        if (Character.isLetterOrDigit(sequence[sequence.length - 1])) {
            int lastChar = scanner.read();
            scanner.unread();
            if (lastChar != -1 && !Character.isWhitespace((char)lastChar)) {
                return false;
            }
        }
        return true;
    }
}

