/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.registry.ToolDescriptor;
import org.jkiss.dbeaver.tools.registry.ToolsRegistry;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class ToolsPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.tools";
    public static final String PROP_HAS_TOOLS = "hasTools";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IWorkbenchPart)) {
            return false;
        }
        IStructuredSelection structuredSelection = NavigatorUtils.getSelectionFromPart((IWorkbenchPart)((IWorkbenchPart)receiver));
        if (structuredSelection == null || structuredSelection.isEmpty()) {
            return false;
        }
        switch (property) {
            case "hasTools": {
                return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer") && this.hasAvailableTools(structuredSelection);
            }
        }
        return false;
    }

    private boolean hasAvailableTools(IStructuredSelection selection) {
        boolean singleObject = selection.size() == 1;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            DBSObject dbObject = DBUtils.getFromObject((Object)item);
            if (dbObject != null) {
                item = dbObject;
            }
            if (item instanceof DBPObject) {
                for (ToolDescriptor descriptor : ToolsRegistry.getInstance().getTools()) {
                    if (descriptor.isSingleton() && !singleObject || !descriptor.appliesTo((DBPObject)item)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

