/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.piped;

import java.util.ArrayList;
import net.sf.jsqlparser.statement.piped.PipeOperator;
import net.sf.jsqlparser.statement.piped.PipeOperatorVisitor;
import net.sf.jsqlparser.statement.select.SelectItem;

public class AggregatePipeOperator
extends PipeOperator {
    private final ArrayList<SelectItem<?>> selectItems = new ArrayList();
    private final ArrayList<String> selectItemsOrderSuffices = new ArrayList();
    private final ArrayList<SelectItem<?>> groupItems = new ArrayList();
    private final ArrayList<String> groupItemsOrderSuffices = new ArrayList();
    private boolean usingShortHandOrdering = false;

    public AggregatePipeOperator(SelectItem<?> selectItem, String orderSuffix) {
        this.selectItems.add(selectItem);
        this.selectItemsOrderSuffices.add(orderSuffix);
    }

    public ArrayList<SelectItem<?>> getSelectItems() {
        return this.selectItems;
    }

    public ArrayList<SelectItem<?>> getGroupItems() {
        return this.groupItems;
    }

    public ArrayList<String> getSelectItemsOrderSuffices() {
        return this.selectItemsOrderSuffices;
    }

    public ArrayList<String> getGroupItemsOrderSuffices() {
        return this.groupItemsOrderSuffices;
    }

    public AggregatePipeOperator add(SelectItem<?> selectItem, String orderSuffix) {
        this.selectItems.add(selectItem);
        return this;
    }

    public AggregatePipeOperator with(SelectItem<?> selectItem, String orderSuffix) {
        return this.add(selectItem, orderSuffix);
    }

    public AggregatePipeOperator addGroupItem(SelectItem<?> selectItem, String orderSuffix) {
        this.groupItems.add(selectItem);
        this.groupItemsOrderSuffices.add(orderSuffix);
        return this;
    }

    public AggregatePipeOperator withGroupItem(SelectItem<?> selectItem, String orderSuffix) {
        return this.addGroupItem(selectItem, orderSuffix);
    }

    public boolean isUsingShortHandOrdering() {
        return this.usingShortHandOrdering;
    }

    public AggregatePipeOperator setShorthandOrdering(boolean usingShortHandOrdering) {
        this.usingShortHandOrdering = usingShortHandOrdering;
        return this;
    }

    @Override
    public <T, S> T accept(PipeOperatorVisitor<T, S> visitor, S context) {
        return visitor.visit(this, context);
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("|> ").append("AGGREGATE");
        int i = 0;
        for (SelectItem<?> selectItem : this.selectItems) {
            builder.append(i > 0 ? ", " : " ").append(selectItem);
            if (i < this.selectItemsOrderSuffices.size() && this.selectItemsOrderSuffices.get(i) != null && !this.selectItemsOrderSuffices.get(i).isEmpty()) {
                builder.append(" ").append(this.selectItemsOrderSuffices.get(i));
            }
            ++i;
        }
        builder.append("\n");
        if (!this.groupItems.isEmpty()) {
            builder.append("\t").append("GROUP");
            if (this.isUsingShortHandOrdering()) {
                builder.append(" AND ORDER");
            }
            builder.append(" BY");
            i = 0;
            for (SelectItem<?> selectItem : this.groupItems) {
                builder.append(i > 0 ? ", " : " ").append(selectItem);
                if (i < this.groupItemsOrderSuffices.size() && this.groupItemsOrderSuffices.get(i) != null && !this.groupItemsOrderSuffices.get(i).isEmpty()) {
                    builder.append(" ").append(this.groupItemsOrderSuffices.get(i));
                }
                ++i;
            }
            builder.append("\n");
        }
        return builder;
    }
}

