/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.CSSDOMConfiguration;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.DOMParentNode;
import io.sf.carte.doc.dom.DefaultNodeList;
import io.sf.carte.doc.dom.DocumentTypeImpl;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.ExtendedNodeList;
import io.sf.carte.doc.dom.NDTNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeIterator;
import io.sf.carte.doc.dom.NodeIteratorImpl;
import io.sf.carte.doc.dom.StyleDefinerElementHelper;
import io.sf.carte.doc.dom.TreeWalker;
import io.sf.carte.doc.dom.TreeWalkerImpl;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LinkStyle;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AbstractStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMUtil;
import io.sf.carte.doc.style.css.om.DefaultErrorHandler;
import io.sf.carte.doc.style.css.om.MediaFactory;
import io.sf.carte.doc.style.css.om.StyleSheetList;
import io.sf.carte.doc.xml.dtd.ContentModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class DOMDocument
extends DOMParentNode
implements CSSDocument {
    private static final long serialVersionUID = 2L;
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    private boolean strictErrorChecking = true;
    CSSDOMConfiguration domConfig = new CSSDOMConfiguration();
    private String documentURI = null;
    final Set<LinkStyleDefiner> linkedStyle = new LinkedHashSet<LinkStyleDefiner>(4);
    final Set<LinkStyleDefiner> embeddedStyle = new LinkedHashSet<LinkStyleDefiner>(3);
    private Set<CSSPropertyDefinition> registeredPropertySet = null;
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    private final MyOMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private final ErrorHandler errorHandler = this.createErrorHandler();
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private final Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    public DOMDocument(DocumentType documentType) {
        super((short)9);
        if (documentType != null && documentType.getOwnerDocument() == null) {
            DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)documentType;
            this.getNodeList().add(documentTypeImpl);
            documentTypeImpl.setParentNode(this);
        }
    }

    @Override
    public String getCompatMode() {
        DocumentType documentType = this.getDoctype();
        if (documentType != null) {
            return "CSS1Compat";
        }
        return "BackCompat";
    }

    @Override
    public CSSDocument.ComplianceMode getComplianceMode() {
        DocumentType documentType = this.getDoctype();
        if (documentType != null) {
            return CSSDocument.ComplianceMode.STRICT;
        }
        return CSSDocument.ComplianceMode.QUIRKS;
    }

    @Override
    public DOMElement getDocumentElement() {
        return this.getLastElementChild();
    }

    @Override
    public DocumentType getDoctype() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 10) continue;
            return (DocumentType)node;
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return null;
    }

    @Override
    public DOMNode getParentNode() {
        return null;
    }

    @Override
    public boolean isVisitedURI(String string) {
        return false;
    }

    @Override
    public DOMDocument cloneNode(boolean bl) {
        boolean bl2;
        DocumentType documentType = this.getDoctype();
        boolean bl3 = bl2 = documentType != null;
        if (bl2) {
            documentType = (DocumentType)documentType.cloneNode(bl);
        }
        DOMDocument dOMDocument = this.cloneDocument(documentType);
        if (bl) {
            boolean bl4 = !bl2;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) {
                    if (bl4) {
                        dOMDocument.appendChild(dOMDocument.importNode(node, true));
                        continue;
                    }
                    dOMDocument.insertBefore(dOMDocument.importNode(node, true), documentType);
                    continue;
                }
                bl4 = true;
            }
        } else if (bl2) {
            dOMDocument.removeChild(documentType);
        }
        DOMDocument.callUserHandlers((short)1, this, dOMDocument);
        return dOMDocument;
    }

    DOMDocument cloneDocument(DocumentType documentType) {
        String string = null;
        String string2 = null;
        DOMElement dOMElement = this.getDocumentElement();
        if (dOMElement != null) {
            string = dOMElement.getNamespaceURI();
            string2 = dOMElement.getTagName();
        }
        if (!(string != null || "html".equals(string2) || documentType != null && "html".equalsIgnoreCase(documentType.getName()))) {
            string = "";
        }
        DOMDocument dOMDocument = this.getImplementation().createDocument(string, string2, documentType);
        if (dOMElement != null) {
            dOMDocument.removeChild(dOMDocument.getDocumentElement());
        }
        return dOMDocument;
    }

    @Override
    public abstract CSSDOMImplementation getImplementation();

    protected abstract CSSDOMImplementation getStyleSheetFactory();

    MediaQueryList parseMediaList(String string, Node node) {
        MediaQueryList mediaQueryList;
        if (string.length() == 0) {
            mediaQueryList = MediaFactory.createImmutable();
        } else {
            try {
                mediaQueryList = this.getStyleSheetFactory().createImmutableMediaQueryList(string, node);
            }
            catch (CSSBudgetException cSSBudgetException) {
                this.getErrorHandler().linkedStyleError(node, cSSBudgetException.getMessage());
                return null;
            }
            if (mediaQueryList.isNotAllMedia() && mediaQueryList.hasErrors()) {
                return null;
            }
        }
        return mediaQueryList;
    }

    AbstractCSSStyleSheet loadStyleSheet(AbstractCSSStyleSheet abstractCSSStyleSheet, String string, String string2, MediaQueryList mediaQueryList, Node node) {
        Object object;
        if (abstractCSSStyleSheet == null) {
            abstractCSSStyleSheet = this.getStyleSheetFactory().createLinkedStyleSheet(node, string2, mediaQueryList);
        } else {
            object = (CSSDOMImplementation.MyCSSStyleSheet)abstractCSSStyleSheet;
            ((CSSDOMImplementation.MyCSSStyleSheet)object).setTitle(string2);
            ((CSSDOMImplementation.MyCSSStyleSheet)object).setMedia(mediaQueryList);
            ((BaseCSSStyleSheet)object).getCssRules().clear();
        }
        object = this.getReferrerpolicyAttribute(node);
        try {
            URL uRL = this.getURL(string);
            if (this.isAuthorizedOrigin(uRL)) {
                abstractCSSStyleSheet.setHref(uRL.toExternalForm());
                abstractCSSStyleSheet.loadStyleSheet(uRL, (String)object);
            } else {
                this.getErrorHandler().policyError(node, "Unauthorized URL: " + uRL.toExternalForm());
            }
        }
        catch (IOException iOException) {
            this.getErrorHandler().ioError(string, iOException);
        }
        catch (DOMPolicyException dOMPolicyException) {
            abstractCSSStyleSheet = null;
        }
        catch (DOMException dOMException) {
        }
        catch (Exception exception) {
            this.getErrorHandler().linkedSheetError(exception, abstractCSSStyleSheet);
        }
        return abstractCSSStyleSheet;
    }

    private String getReferrerpolicyAttribute(Node node) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("referrerpolicy")) != null) {
            return node2.getNodeValue();
        }
        return "";
    }

    AbstractCSSStyleSheet parseEmbeddedStyleSheet(AbstractCSSStyleSheet abstractCSSStyleSheet, String string, String string2, MediaQueryList mediaQueryList, Node node) {
        Object object;
        if (abstractCSSStyleSheet == null) {
            abstractCSSStyleSheet = this.getStyleSheetFactory().createLinkedStyleSheet(node, string2, mediaQueryList);
        } else {
            object = (CSSDOMImplementation.MyCSSStyleSheet)abstractCSSStyleSheet;
            ((CSSDOMImplementation.MyCSSStyleSheet)object).setTitle(string2);
            ((CSSDOMImplementation.MyCSSStyleSheet)object).setMedia(mediaQueryList);
            ((BaseCSSStyleSheet)object).getCssRules().clear();
        }
        abstractCSSStyleSheet.setHref(this.getBaseURI());
        if (string.length() != 0) {
            object = new StringReader(string);
            try {
                abstractCSSStyleSheet.parseStyleSheet((Reader)object);
            }
            catch (Exception exception) {
                this.getErrorHandler().linkedSheetError(exception, abstractCSSStyleSheet);
            }
        } else {
            abstractCSSStyleSheet.getCssRules().clear();
        }
        return abstractCSSStyleSheet;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(DOMElement dOMElement) {
        if (dOMElement != null) {
            return this.getEmbeddedStyleDefiner(dOMElement.getId());
        }
        return null;
    }

    static boolean isValidName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!DOMDocument.isValidStartCharacter(string.codePointAt(0))) {
            return false;
        }
        int n2 = string.offsetByCodePoints(0, 1);
        while (n2 < n) {
            if (!DOMDocument.isValidCharacter(string.codePointAt(n2))) {
                return false;
            }
            n2 = string.offsetByCodePoints(n2, 1);
        }
        return true;
    }

    private static boolean isValidCharacter(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 45 || n == 95 || n == 46 || n == 183 || n >= 192 && n <= 214 || n >= 216 && n <= 246 || n >= 248 && n <= 767 || n >= 768 && n <= 893 || n >= 895 && n <= 8191 || n >= 8204 && n <= 8205 || n >= 8255 && n <= 8256 || n >= 8304 && n <= 8591 || n >= 11264 && n <= 12271 || n >= 12289 && n <= 55295 || n >= 63744 && n <= 64975 || n >= 65008 && n <= 65533 || n >= 65536 && n <= 983039;
    }

    private static boolean isValidStartCharacter(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95 || n >= 192 && n <= 214 || n >= 216 && n <= 246 || n >= 248 && n <= 767 || n >= 880 && n <= 893 || n >= 895 && n <= 8191 || n >= 8204 && n <= 8205 || n >= 8304 && n <= 8591 || n >= 11264 && n <= 12271 || n >= 12289 && n <= 55295 || n >= 63744 && n <= 64975 || n >= 65008 && n <= 65533 || n >= 65536 && n <= 983039;
    }

    static String escapeCloseTag(String string, String string2) {
        int n = string2.indexOf(60);
        if (n == -1) {
            return string2;
        }
        int n2 = string2.indexOf(string, 2);
        if (n2 == -1) {
            return string2;
        }
        StringBuilder stringBuilder = null;
        int n3 = string.length();
        int n4 = string2.length() - 1;
        while (n < n4) {
            int n5;
            char c;
            char c2 = string2.charAt(n);
            if (c2 == '<' && (c = string2.charAt(n5 = n + 1)) == '/' && n4 - n5 > n3) {
                ++n5;
                if ((n5 = DOMDocument.skipIgnorableChars(n5, string2, n4)) < n4 && string2.regionMatches(true, n5, string, 0, n3) && (n5 = DOMDocument.skipIgnorableChars(n5 + n3, string2, n4)) <= n4 && string2.charAt(n5) == '>') {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(n4 + 4);
                        stringBuilder.append(string2.subSequence(0, n));
                    }
                    stringBuilder.append("&lt;");
                    stringBuilder.append(string2.subSequence(n + 1, n5 + 1));
                    n = n5 + 1;
                    continue;
                }
            }
            if (stringBuilder != null) {
                stringBuilder.append(c2);
            }
            ++n;
        }
        if (stringBuilder != null && n == n4) {
            stringBuilder.append(string2.charAt(n));
        }
        return stringBuilder == null ? string2 : stringBuilder.toString();
    }

    private static int skipIgnorableChars(int n, String string, int n2) {
        while (n < n2) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\t' && c != '\n') {
                if (c != '\r') break;
                int n3 = n + 1;
                if (string.charAt(n3) == '\n') {
                    n = n3;
                }
            }
            ++n;
        }
        return n;
    }

    static String escapeLtGtEntities(String string) {
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder = DOMDocument.appendEntityToBuffer(stringBuilder, "lt", string, i, n);
                continue;
            }
            if (c == '>') {
                stringBuilder = DOMDocument.appendEntityToBuffer(stringBuilder, "gt", string, i, n);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    static StringBuilder appendEntityToBuffer(StringBuilder stringBuilder, String string, String string2, int n, int n2) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(n2 + string.length() + 2);
            stringBuilder.append(string2.subSequence(0, n));
        }
        stringBuilder.append('&').append(string).append(';');
        return stringBuilder;
    }

    boolean isIdAttribute(String string) {
        if (this.getComplianceMode() == CSSDocument.ComplianceMode.STRICT) {
            return "id".equals(string);
        }
        return "id".equalsIgnoreCase(string);
    }

    @Override
    public DOMElement createElement(String string) throws DOMException {
        if (string == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(null, string);
    }

    @Override
    public DOMElement createElementNS(String string, String string2) throws DOMException {
        String string3;
        if (string2 == null) {
            throw new DOMException(5, "null qualified name");
        }
        String string4 = null;
        if (string != null) {
            if (string.length() == 0) {
                string = null;
                string3 = string2.toLowerCase(Locale.ROOT);
            } else {
                string = string.intern();
                int n = string2.indexOf(58);
                if (n == -1) {
                    string4 = this.lookupPrefix(string);
                    string3 = string2;
                } else {
                    if (n == string2.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (n == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    string4 = string2.substring(0, n).intern();
                    string3 = string2.substring(n + 1);
                }
            }
        } else {
            if (string2.indexOf(58) != -1) {
                throw new DOMException(14, "Prefix with null namespace");
            }
            string3 = string2.toLowerCase(Locale.ROOT);
        }
        if (!DOMDocument.isValidName(string3)) {
            throw new DOMException(5, "Invalid name: " + string3);
        }
        MyXMLElement myXMLElement = !"style".equals(string3) ? new MyXMLElement(string3, string) : new StyleElement(string);
        if (string4 != null) {
            myXMLElement.setPrefix(string4);
        }
        return myXMLElement;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DOMDocumentFragment();
    }

    @Override
    public Text createTextNode(String string) {
        if (string == null) {
            throw new DOMException(5, "null data");
        }
        MyText myText = new MyText();
        myText.setData(string);
        return myText;
    }

    @Override
    public Comment createComment(String string) {
        if (string == null) {
            throw new DOMException(5, "null data");
        }
        MyComment myComment = new MyComment();
        myComment.setData(string);
        return myComment;
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        if (string == null) {
            throw new DOMException(5, "null data");
        }
        MyCDATASection myCDATASection = new MyCDATASection();
        myCDATASection.setData(string);
        return myCDATASection;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (string == null || string.length() == 0) {
            throw new DOMException(5, "Void target");
        }
        if (string.equalsIgnoreCase("xml")) {
            throw new DOMException(5, "An xml declaration is not a processing instruction");
        }
        if (!DOMDocument.isValidName(string)) {
            throw new DOMException(5, "Invalid target: " + string);
        }
        if (string2.contains("?>")) {
            throw new DOMException(5, "A processing instruction data cannot contain a '?>'");
        }
        if ("xml-stylesheet".equals(string)) {
            return new MyStyleProcessingInstruction(string2);
        }
        return new MyProcessingInstruction(string, string2);
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        if (string == null) {
            throw new DOMException(5, "null entity reference name");
        }
        return new MyEntityReference(string);
    }

    @Override
    public Attr createAttribute(String string) throws DOMException {
        return this.createAttributeNS(null, string);
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        if (string2 == null) {
            throw new DOMException(5, "null name");
        }
        String string3 = string2;
        String string4 = null;
        if (string != null) {
            if (string.length() != 0) {
                string = string.intern();
                int n = string2.indexOf(58);
                if (n == -1) {
                    string4 = this.lookupPrefix(string);
                } else {
                    if (n == string2.length() - 1) {
                        throw new DOMException(14, "Empty local name");
                    }
                    if (n == 0) {
                        throw new DOMException(14, "Empty prefix");
                    }
                    string4 = string2.substring(0, n).intern();
                    string3 = string2.substring(n + 1);
                }
                if ("http://www.w3.org/1999/xhtml" == string) {
                    string3 = string3.toLowerCase(Locale.ROOT);
                }
            } else {
                if (string2.indexOf(58) != -1) {
                    throw new DOMException(14, "Prefix with null namespace");
                }
                string = null;
            }
        } else if (string2.indexOf(58) != -1) {
            throw new DOMException(14, "Prefix with null namespace");
        }
        Attr attr = this.createAttributeNS(string, string4, string3);
        return attr;
    }

    Attr createAttributeNS(String string, String string2, String string3) throws DOMException {
        MyAttr myAttr;
        if (!DOMDocument.isValidName(string3)) {
            throw new DOMException(5, "Invalid name: " + string3);
        }
        if ("xmlns".equals(string3)) {
            if (string != null && !XMLNS_NAMESPACE_URI.equals(string)) {
                throw new DOMException(14, "xmlns local name but not xmlns namespace");
            }
            myAttr = new XmlnsAttr();
        } else {
            myAttr = "class".equals(string3) ? new ClassAttr(string) : ("base".equals(string3) && "xml".equals(string2) ? new BaseEventAttr() : ("style".equals(string3) && string2 == null ? new MyStyleAttr(string3) : ("media".equals(string3) || "type".equals(string3) || "crossorigin".equals(string3) ? new StyleEventAttr(string3, string) : new MyAttr(string3, string))));
        }
        if (string2 != null) {
            myAttr.setPrefix(string2);
        }
        return myAttr;
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter) {
        return new NodeIteratorImpl((AbstractDOMNode)node, n, nodeFilter);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter) {
        return new TreeWalkerImpl((AbstractDOMNode)node, n, nodeFilter);
    }

    @Override
    public ElementList getElementsByClassName(String string) {
        return this.getNodeList().getElementsByClassName(string, this.getComplianceMode());
    }

    @Override
    public String lookupPrefix(String string) {
        DOMElement dOMElement = this.getDocumentElement();
        if (dOMElement == null) {
            return null;
        }
        return this.lookupPrefix(dOMElement, string);
    }

    private String lookupPrefix(Node node, String string) {
        if (node.getNamespaceURI() == string) {
            String string2 = node.getPrefix();
            return string2;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string3;
            if (node2.getNodeType() != 1 || (string3 = this.lookupPrefix(node2, string)) == null) continue;
            return string3;
        }
        return null;
    }

    @Override
    public DOMElement getElementById(String string) {
        return this.findElementById(this.getFirstChild(), string);
    }

    private DOMElement findElementById(Node node, String string) {
        while (node != null) {
            DOMElement dOMElement;
            String string2;
            if (node.getNodeType() == 1 && (string2 = (dOMElement = (DOMElement)node).getId()).equals(string)) {
                return dOMElement;
            }
            dOMElement = this.findElementById(node.getFirstChild(), string);
            if (dOMElement != null) {
                return dOMElement;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    @Deprecated
    public String getXmlEncoding() {
        return null;
    }

    @Override
    @Deprecated
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    @Deprecated
    public void setXmlStandalone(boolean bl) throws DOMException {
    }

    @Override
    @Deprecated
    public String getXmlVersion() {
        return null;
    }

    @Override
    @Deprecated
    public void setXmlVersion(String string) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        this.strictErrorChecking = bl;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String string) {
        this.documentURI = string;
        if (!this.linkedStyle.isEmpty()) {
            this.onBaseModify();
        }
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        switch (node.getNodeType()) {
            case 2: {
                Attr attr = (Attr)node;
                DOMAttr dOMAttr = (DOMAttr)this.createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                dOMAttr.specified = attr.getSpecified();
                dOMAttr.setValue(node.getNodeValue());
                return dOMAttr;
            }
            case 1: {
                Object object;
                Element element = (Element)node;
                DOMElement dOMElement = this.createElementNS(element.getNamespaceURI(), element.getNodeName());
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)object.item(i);
                        DOMAttr dOMAttr = (DOMAttr)this.importNode(attr, true);
                        dOMAttr.specified = attr.getSpecified();
                        dOMElement.setAttributeNode(dOMAttr);
                    }
                }
                if (bl) {
                    for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                        dOMElement.appendChild(this.importNode((Node)object, true));
                    }
                }
                return dOMElement;
            }
            case 3: {
                return this.createTextNode(node.getNodeValue());
            }
            case 4: {
                return this.createCDATASection(node.getNodeValue());
            }
            case 8: {
                return this.createComment(node.getNodeValue());
            }
            case 11: {
                DocumentFragment documentFragment = this.createDocumentFragment();
                if (bl) {
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        documentFragment.appendChild(this.importNode(node2, true));
                    }
                }
                return documentFragment;
            }
            case 5: {
                return this.createEntityReference(node.getNodeName());
            }
            case 7: {
                return this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
            }
        }
        throw new DOMException(9, "Cannot import this node type.");
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        throw new DOMException(9, "Node adoption not supported");
    }

    @Override
    public DOMNode insertBefore(Node node, Node node2) throws DOMException {
        block3: {
            short s;
            block2: {
                s = node.getNodeType();
                if (s != 1) break block2;
                for (Node node3 = this.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (s != 10) break block3;
            for (Node node4 = this.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                if (node4.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.insertBefore(node, node2);
    }

    @Override
    public DOMNode replaceChild(Node node, Node node2) throws DOMException {
        block2: {
            short s;
            block3: {
                s = node.getNodeType();
                if (s == node2.getNodeType()) break block2;
                if (s != 1) break block3;
                for (Node node3 = this.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block2;
            }
            if (s != 10) break block2;
            for (Node node4 = this.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                if (node4.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.replaceChild(node, node2);
    }

    @Override
    void preAddChild(Node node) {
        block3: {
            block2: {
                super.preAddChild(node);
                if (node.getNodeType() != 1) break block2;
                for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (node.getNodeType() != 10) break block3;
            for (Node node3 = this.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                if (node3.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
    }

    @Override
    void checkDocumentOwner(Node node) {
        if (node.getOwnerDocument() != this && node.getNodeType() != 10) {
            throw new DOMException(4, "Different document owners.");
        }
    }

    @Override
    void preReplaceChild(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
        block4: {
            block3: {
                super.preAddChild(abstractDOMNode);
                if (abstractDOMNode.getNodeType() != 1) break block3;
                if (abstractDOMNode2.getNodeType() == 1) break block4;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block4;
            }
            if (abstractDOMNode.getNodeType() == 10 && abstractDOMNode2.getNodeType() != 10) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 10) continue;
                    throw new DOMException(3, "Document already has a doctype.");
                }
            }
        }
    }

    @Override
    void postAddChild(AbstractDOMNode abstractDOMNode) {
        String string;
        super.postAddChild(abstractDOMNode);
        if (abstractDOMNode.getNodeType() == 7 && "xml-stylesheet".equals(abstractDOMNode.getNodeName()) && (string = abstractDOMNode.getNodeValue()) != null && string.contains("text/css")) {
            this.onSheetModify();
        }
    }

    @Override
    @Deprecated
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        throw new DOMException(9, "This operation is not supported.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    @Override
    public void normalizeDocument() {
        DOMElement dOMElement = this.getDocumentElement();
        if (dOMElement != null) {
            dOMElement.normalize();
        }
    }

    @Override
    public String lookupNamespaceURI(String string) {
        DOMElement dOMElement = this.getDocumentElement();
        return dOMElement != null ? dOMElement.lookupNamespaceURI(string) : null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        DOMElement dOMElement = this.getDocumentElement();
        if (dOMElement != null) {
            return dOMElement.getNamespaceURI() == string;
        }
        return string == null;
    }

    boolean isHTML() {
        return false;
    }

    @Override
    public void registerProperty(CSSPropertyDefinition cSSPropertyDefinition) {
        if (this.registeredPropertySet == null) {
            this.registeredPropertySet = new HashSet<CSSPropertyDefinition>();
        }
        this.registeredPropertySet.add(cSSPropertyDefinition);
        this.mergedStyleSheet = null;
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    private void updateStyleLists() {
        this.linkedStyle.clear();
        for (LinkStyleDefiner object2 : this.getLinkedStyleNodeList()) {
            if (object2.getSheet() == null) continue;
            this.linkedStyle.add(object2);
        }
        this.embeddedStyle.clear();
        for (LinkStyleDefiner linkStyleDefiner : this.getEmbeddedStyleNodeList()) {
            this.embeddedStyle.add(linkStyleDefiner);
        }
        Iterator<LinkStyleDefiner> iterator = this.linkedStyle.iterator();
        while (iterator.hasNext()) {
            this.addLinkedSheet(iterator.next().getSheet());
        }
        Iterator<LinkStyleDefiner> iterator2 = this.embeddedStyle.iterator();
        while (iterator2.hasNext()) {
            this.addLinkedSheet(iterator2.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
            this.lastStyleSheetSet = null;
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
            this.lastStyleSheetSet = null;
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void addLinkedSheet(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        if (abstractCSSStyleSheet != null) {
            this.sheets.add(abstractCSSStyleSheet);
        }
    }

    ExtendedNodeList<? extends DOMNode> getLinkedStyleNodeList() {
        return this.getLinkedStyleNodeList(true);
    }

    ExtendedNodeList<? extends DOMNode> getEmbeddedStyleNodeList() {
        return this.getLinkedStyleNodeList(false);
    }

    private DOMNodeList getLinkedStyleNodeList(boolean bl) {
        LinkedList linkedList = null;
        AbstractDOMNode abstractDOMNode = this.getNodeList().getFirst();
        while (abstractDOMNode != null) {
            short s = abstractDOMNode.getNodeType();
            if (s == 7 && "xml-stylesheet".equals(abstractDOMNode.getNodeName())) {
                LinkStyleProcessingInstruction linkStyleProcessingInstruction = (LinkStyleProcessingInstruction)((Object)abstractDOMNode);
                String string = linkStyleProcessingInstruction.getPseudoAttribute("href");
                if (string.length() > 1) {
                    if (string.charAt(0) == '#') {
                        if (!bl) {
                            if (linkedList == null) {
                                linkedList = new DefaultNodeList();
                            }
                            linkedList.add(abstractDOMNode);
                        }
                    } else if (bl) {
                        if (linkedList == null) {
                            linkedList = new DefaultNodeList();
                        }
                        linkedList.add(abstractDOMNode);
                    }
                }
            } else if (s == 1) break;
            abstractDOMNode = abstractDOMNode.nextSibling;
        }
        return linkedList == null ? AbstractDOMNode.emptyNodeList : linkedList;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(String string) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            short s = node.getNodeType();
            if (s == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction linkStyleProcessingInstruction = (LinkStyleProcessingInstruction)node;
                String string2 = linkStyleProcessingInstruction.getPseudoAttribute("href");
                if (string2.length() <= 1 || string2.charAt(0) != '#' || !string.equals(string2.substring(1))) continue;
                return linkStyleProcessingInstruction;
            }
            if (s == 1) break;
        }
        return null;
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet = this.getStyleSheetFactory().getDefaultStyleSheet(this.getComplianceMode());
        this.mergedStyleSheet = this.targetMedium == null ? baseDocumentCSSStyleSheet.clone() : baseDocumentCSSStyleSheet.clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        Iterator<AbstractCSSStyleSheet> iterator = this.sheets.iterator();
        while (iterator.hasNext()) {
            this.mergedStyleSheet.addStyleSheet(iterator.next());
        }
        if (this.registeredPropertySet != null) {
            for (CSSPropertyDefinition cSSPropertyDefinition : this.registeredPropertySet) {
                this.mergedStyleSheet.registerProperty(cSSPropertyDefinition);
            }
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        Object object;
        Object object2;
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        Object object3 = "";
        Iterator<LinkStyleDefiner> iterator = this.linkedStyle.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().getSheet();
            if (object2 == null || (object = ((AbstractStyleSheet)object2).getTitle()) == null || ((String)object).length() <= 0 || object2.getDisabled()) continue;
            if (((String)object3).length() > 0) {
                if (((String)object3).equalsIgnoreCase((String)object)) continue;
                return null;
            }
            object3 = object;
        }
        object2 = this.embeddedStyle.iterator();
        while (iterator.hasNext()) {
            String string;
            object = ((LinkStyleDefiner)object2.next()).getSheet();
            if (object == null || (string = ((AbstractStyleSheet)object).getTitle()) == null || string.length() <= 0 || object.getDisabled()) continue;
            if (((String)object3).length() > 0) {
                if (((String)object3).equalsIgnoreCase(string)) continue;
                return null;
            }
            object3 = string;
        }
        return object3;
    }

    @Override
    public void setSelectedStyleSheetSet(String string) {
        if (string == null || string.length() > 0 && !this.getStyleSheetSets().contains(string)) {
            return;
        }
        this.selectSheetSet(string, this.linkedStyle);
        this.selectSheetSet(string, this.embeddedStyle);
    }

    private void selectSheetSet(String string, Set<LinkStyleDefiner> set) {
        Iterator<LinkStyleDefiner> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            AbstractCSSStyleSheet abstractCSSStyleSheet = iterator.next().getSheet();
            if (abstractCSSStyleSheet == null || (string2 = abstractCSSStyleSheet.getTitle()) == null || string2.length() == 0) continue;
            if (string2.equalsIgnoreCase(string)) {
                abstractCSSStyleSheet.setDisabled(false);
                this.lastStyleSheetSet = string;
                continue;
            }
            abstractCSSStyleSheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        DOMDocument.enableStyleSheetSet(string, this.linkedStyle);
        DOMDocument.enableStyleSheetSet(string, this.embeddedStyle);
    }

    private static void enableStyleSheetSet(String string, Set<LinkStyleDefiner> set) {
        Iterator<LinkStyleDefiner> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            AbstractCSSStyleSheet abstractCSSStyleSheet = iterator.next().getSheet();
            if (abstractCSSStyleSheet == null || (string2 = abstractCSSStyleSheet.getTitle()) == null || string2.length() <= 0 || !string2.equals(string)) continue;
            abstractCSSStyleSheet.setDisabled(false);
        }
    }

    void onBaseModify() {
        for (LinkStyleDefiner linkStyleDefiner : this.getLinkedStyleNodeList()) {
            linkStyleDefiner.resetSheet();
        }
    }

    void onSheetModify() {
        this.mergedStyleSheet = null;
        this.sheets.setNeedsUpdate(true);
        this.onStyleModify();
    }

    void onStyleModify() {
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        DeviceFactory deviceFactory;
        StyleDatabase styleDatabase = null;
        if (this.targetMedium != null && (deviceFactory = this.getStyleSheetFactory().getDeviceFactory()) != null) {
            styleDatabase = deviceFactory.getStyleDatabase(this.targetMedium);
        }
        return styleDatabase;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String string) throws CSSMediaException {
        if ("all".equals(string)) {
            this.targetMedium = null;
        } else {
            if (string != null) {
                string = string.intern();
            }
            this.targetMedium = string;
        }
        this.onSheetModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        CSSCanvas cSSCanvas;
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        DeviceFactory deviceFactory = this.getStyleSheetFactory().getDeviceFactory();
        if (deviceFactory != null) {
            cSSCanvas = deviceFactory.createCanvas(this.targetMedium, this);
            this.canvases.put(this.targetMedium, cSSCanvas);
        } else {
            cSSCanvas = null;
        }
        return cSSCanvas;
    }

    @Override
    public void rebuildCascade() {
        this.onSheetModify();
    }

    ErrorHandler createErrorHandler() {
        return new MyDefaultErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings() || this.getErrorHandler().hasErrors() || this.getErrorHandler().hasWarnings();
    }

    public void onMetaAdded(String string, String string2) {
        if ("default-style".equalsIgnoreCase(string)) {
            this.metaDefaultStyleSet = string2;
            this.onSheetModify();
        } else if ("referrer".equalsIgnoreCase(string)) {
            this.metaReferrerPolicy = string2;
        }
    }

    public void onMetaRemoved(String string, String string2) {
        if ("default-style".equalsIgnoreCase(string)) {
            this.metaDefaultStyleSet = "";
            this.onSheetModify();
        } else if ("referrer".equalsIgnoreCase(string)) {
            this.metaReferrerPolicy = "";
        }
    }

    @Override
    public URL getBaseURL() {
        URL uRL = null;
        String string = this.getBaseURI();
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    @Override
    public String getBaseURI() {
        String string;
        String string2 = this.getDocumentURI();
        DOMElement dOMElement = this.getDocumentElement();
        if (dOMElement != null && (string = dOMElement.getAttribute("xml:base")).length() != 0) {
            if (string2 != null) {
                URL uRL;
                URL uRL2;
                try {
                    uRL2 = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    return this.getBaseForNullDocumentURI(string, dOMElement);
                }
                try {
                    uRL = new URL(uRL2, string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.getErrorHandler().ioError(string, malformedURLException);
                    return uRL2.toExternalForm();
                }
                string2 = uRL.toExternalForm();
                String string3 = uRL2.getProtocol();
                String string4 = uRL.getProtocol();
                if (!(string3.equals(string4) || string4.equals("https") || string4.equals("http") || string3.equals("file") || string3.equals("jar"))) {
                    this.getErrorHandler().policyError(dOMElement, "Remote document wants to set a non-http base URL: " + string2);
                    string2 = uRL2.toExternalForm();
                }
            } else {
                string2 = this.getBaseForNullDocumentURI(string, dOMElement);
            }
        }
        return string2;
    }

    private String getBaseForNullDocumentURI(String string, DOMElement dOMElement) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("https") || string2.equals("http")) {
                return string;
            }
            this.getErrorHandler().policyError(dOMElement, "Untrusted document wants to set a non-http base URL: " + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public URL getURL(String string) throws MalformedURLException {
        if (string.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL uRL = string.indexOf("://") < 0 ? new URL(this.getBaseURL(), string) : new URL(string);
        return uRL;
    }

    @Override
    public boolean isSafeOrigin(URL uRL) {
        URL uRL2 = this.getBaseURL();
        String string = uRL2.getHost();
        int n = uRL2.getPort();
        if (n == -1) {
            n = uRL2.getDefaultPort();
        }
        String string2 = uRL.getHost();
        int n2 = uRL.getPort();
        if (n2 == -1) {
            n2 = uRL.getDefaultPort();
        }
        return (string.equalsIgnoreCase(string2) || string2.endsWith(string)) && n == n2;
    }

    @Override
    public boolean isAuthorizedOrigin(URL uRL) {
        String string = uRL.getProtocol();
        if (this.documentURI != null) {
            URL uRL2 = this.getBaseURL();
            String string2 = uRL2.getProtocol();
            if (!(string.equalsIgnoreCase("https") || string.equalsIgnoreCase("http") || string2.equals("file") || string2.equals("jar"))) {
                return false;
            }
        } else if (!string.equalsIgnoreCase("https") && !string.equalsIgnoreCase("http")) {
            return false;
        }
        return true;
    }

    @Override
    public String getReferrerPolicy() {
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String string) {
        if (this.metaReferrerPolicy.length() == 0) {
            this.metaReferrerPolicy = string;
        }
    }

    public String toString() {
        return this.getChildNodes().toString();
    }

    public InputStream openStream(String string) throws IOException {
        return this.openConnection(this.getURL(string)).getInputStream();
    }

    private class BaseEventAttr
    extends EventAttr {
        private static final long serialVersionUID = 2L;

        BaseEventAttr() {
            super("base", DOMDocument.XML_NAMESPACE_URI);
        }

        @Override
        void onAttributeRemoval() {
            DOMElement dOMElement = this.getOwnerElement();
            this.onDOMChange(dOMElement);
        }

        @Override
        void onDOMChange(DOMElement dOMElement) {
            if (dOMElement == DOMDocument.this.getDocumentElement()) {
                DOMDocument.this.onBaseModify();
            }
        }
    }

    class ClassAttr
    extends MyAttr {
        private static final long serialVersionUID = 2L;

        ClassAttr(String string) {
            super("class", string);
        }

        @Override
        void setAttributeOwner(DOMElement dOMElement) throws DOMException {
            DOMElement dOMElement2;
            if (dOMElement == null && (dOMElement2 = this.getOwnerElement()) != null && this.isSameNamespace(dOMElement2.getNamespaceURI()) && dOMElement2.classList != null) {
                this.value = dOMElement2.classList.getValue();
                dOMElement2.classList.clear();
            }
            super.setAttributeOwner(dOMElement);
            if (dOMElement != null && this.isSameNamespace(dOMElement.getNamespaceURI()) && dOMElement.classList != null) {
                dOMElement.classList.setValue(this.value);
            }
        }

        private boolean isSameNamespace(String string) {
            String string2 = this.getNamespaceURI();
            if (string2 == null) {
                return string == null || this.isDefaultNamespace(string);
            }
            return string2.equals(string);
        }

        @Override
        public String getValue() {
            DOMElement.ClassList classList = this.getListValue();
            if (classList == null) {
                return super.getValue();
            }
            return classList.getValue();
        }

        @Override
        public void setValue(String string) throws DOMException {
            super.setValue(string);
            DOMElement.ClassList classList = this.getListValue();
            if (classList != null) {
                classList.setValue(string);
            }
        }

        DOMElement.ClassList getListValue() {
            DOMElement dOMElement = this.getOwnerElement();
            if (dOMElement == null || !this.isSameNamespace(dOMElement.getNamespaceURI())) {
                return null;
            }
            return (DOMElement.ClassList)dOMElement.getClassList();
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }
    }

    class DOMDocumentFragment
    extends DOMParentNode
    implements DocumentFragment {
        private static final long serialVersionUID = 2L;

        DOMDocumentFragment() {
            super((short)11);
        }

        @Override
        public String getNodeName() {
            return "#document-fragment";
        }

        @Override
        public String lookupNamespaceURI(String string) {
            return null;
        }

        @Override
        void checkAppendNodeHierarchy(Node node) {
            super.checkAppendNodeHierarchy(node);
            if (node.getNodeType() == 10) {
                throw new DOMException(3, "Doctype must be added to document.");
            }
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMDocumentFragment cloneNode(boolean bl) {
            DOMDocumentFragment dOMDocumentFragment = new DOMDocumentFragment();
            if (bl) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    dOMDocumentFragment.appendChild(node.cloneNode(true));
                }
            }
            DOMDocumentFragment.callUserHandlers((short)1, this, dOMDocumentFragment);
            return dOMDocumentFragment;
        }

        public String toString() {
            int n = this.getChildNodes().getLength();
            StringBuilder stringBuilder = new StringBuilder(64 + n * 32);
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                stringBuilder.append(node.toString());
            }
            return stringBuilder.toString();
        }
    }

    abstract class EventAttr
    extends MyAttr {
        private static final long serialVersionUID = 2L;

        EventAttr(String string, String string2) {
            super(string, string2);
        }

        @Override
        void setAttributeOwner(DOMElement dOMElement) {
            if (dOMElement != null) {
                super.setAttributeOwner(dOMElement);
                this.onDOMChange(dOMElement);
            } else {
                this.onAttributeRemoval();
                super.setAttributeOwner(null);
            }
        }

        @Override
        public void setValue(String string) throws DOMException {
            super.setValue(string);
            DOMElement dOMElement = this.getOwnerElement();
            if (dOMElement != null) {
                this.onDOMChange(dOMElement);
            }
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }

        abstract void onAttributeRemoval();

        abstract void onDOMChange(DOMElement var1);
    }

    static interface LinkStyleDefiner
    extends LinkStyle<AbstractCSSRule>,
    Node {
        public AbstractCSSStyleSheet getSheet();

        public void resetSheet();
    }

    static interface LinkStyleProcessingInstruction
    extends LinkStyleDefiner,
    ProcessingInstruction {
        public String getPseudoAttribute(String var1);
    }

    class MyAttr
    extends DOMAttr {
        private static final long serialVersionUID = 2L;

        MyAttr(String string, String string2) {
            super(string, string2);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public boolean isId() {
            DOMElement dOMElement = this.getOwnerElement();
            return dOMElement != null && dOMElement.isIdAttribute(this.getLocalName());
        }

        @Override
        public Attr cloneNode(boolean bl) {
            MyAttr myAttr = (MyAttr)this.getOwnerDocument().createAttributeNS(this.getNamespaceURI(), this.getName());
            myAttr.setValue(this.getValue());
            MyAttr.callUserHandlers((short)1, this, myAttr);
            return myAttr;
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        private static final long serialVersionUID = 2L;

        MyCDATASection() {
            super((short)4);
        }

        @Override
        public String getNodeName() {
            return "#cdata-section";
        }

        @Override
        public void setData(String string) throws DOMException {
            if (string.contains("]]>")) {
                throw new DOMException(5, "cdata-section cannot contain ']]>'");
            }
            super.setData(string);
        }

        @Override
        public CDATASection cloneNode(boolean bl) {
            MyCDATASection myCDATASection = new MyCDATASection();
            myCDATASection.setData(this.getData());
            MyCDATASection.callUserHandlers((short)1, this, myCDATASection);
            return myCDATASection;
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    abstract class MyCharacterData
    extends MyNode
    implements CharacterData {
        private static final long serialVersionUID = 2L;
        String data;

        MyCharacterData(short s) {
            super(s);
            this.data = "";
        }

        @Override
        void checkAppendNodeHierarchy(Node node) {
            throw new DOMException(3, "Cannot append the node to text/comment/cdatasection");
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public void setData(String string) throws DOMException {
            if (string == null) {
                string = "";
            }
            this.data = string;
        }

        @Override
        public int getLength() {
            return this.data.length();
        }

        @Override
        public String substringData(int n, int n2) throws DOMException {
            int n3 = this.data.length();
            int n4 = n + n2;
            if (n <= n3 && n4 >= n3) {
                return this.data;
            }
            try {
                return this.data.substring(n, n4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DOMException dOMException = new DOMException(1, indexOutOfBoundsException.getMessage());
                dOMException.initCause(indexOutOfBoundsException);
                throw dOMException;
            }
        }

        @Override
        public void appendData(String string) throws DOMException {
            StringBuilder stringBuilder = new StringBuilder(this.data.length() + string.length());
            stringBuilder.append(this.data).append(string);
            this.setData(stringBuilder.toString());
        }

        @Override
        public void insertData(int n, String string) throws DOMException {
            int n2 = this.data.length();
            if (n < 0 || n > n2) {
                throw new DOMException(1, "Wrong arguments");
            }
            StringBuilder stringBuilder = new StringBuilder(n2 + string.length());
            stringBuilder.append(this.data.subSequence(0, n)).append(string).append(this.data.subSequence(n, n2));
            this.setData(stringBuilder.toString());
        }

        @Override
        public void deleteData(int n, int n2) throws DOMException {
            int n3 = this.data.length();
            if (n < 0 || n2 < 0 || n >= n3) {
                throw new DOMException(1, "Wrong arguments");
            }
            int n4 = n + n2;
            if (n4 > n3) {
                n4 = n3;
                n2 = n3 - n;
            }
            StringBuilder stringBuilder = new StringBuilder(n3 - n2);
            stringBuilder.append(this.data.subSequence(0, n)).append(this.data.subSequence(n4, n3));
            this.setData(stringBuilder.toString());
        }

        @Override
        public void replaceData(int n, int n2, String string) throws DOMException {
            int n3 = this.data.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + string.length() - n2);
            try {
                stringBuilder.append(this.data.subSequence(0, n)).append(string);
                if (n + n2 < n3) {
                    stringBuilder.append(this.data.subSequence(n + n2, n3));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DOMException dOMException = new DOMException(1, indexOutOfBoundsException.getMessage());
                dOMException.initCause(indexOutOfBoundsException);
                throw dOMException;
            }
            this.setData(stringBuilder.toString());
        }

        @Override
        public String getNodeValue() {
            return this.getData();
        }

        @Override
        public void setNodeValue(String string) throws DOMException {
            this.setData(string);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.getData();
        }

        @Override
        public void setTextContent(String string) throws DOMException {
            this.setData(string);
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        private static final long serialVersionUID = 2L;

        MyComment() {
            super((short)8);
        }

        @Override
        public String getNodeName() {
            return "#comment";
        }

        @Override
        public void setData(String string) throws DOMException {
            if (string.contains("-->")) {
                throw new DOMException(5, "Comment cannot contain '--'");
            }
            super.setData(string);
        }

        @Override
        public Comment cloneNode(boolean bl) {
            MyComment myComment = new MyComment();
            myComment.setData(this.getData());
            MyComment.callUserHandlers((short)1, this, myComment);
            return myComment;
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    class MyDefaultErrorHandler
    extends DefaultErrorHandler {
        private static final long serialVersionUID = 2L;

        MyDefaultErrorHandler() {
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        private static final long serialVersionUID = 2L;
        private final String name;

        MyEntityReference(String string) {
            super((short)5);
            this.name = string;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        void checkAppendNodeHierarchy(Node node) {
            super.checkAppendNodeHierarchy(node);
            throw new DOMException(9, "This implementation does not support appending nodes to an entity reference.");
        }

        @Override
        public String lookupNamespaceURI(String string) {
            return null;
        }

        public String toString() {
            return '&' + this.name + ';';
        }
    }

    abstract class MyNode
    extends NDTNode {
        private static final long serialVersionUID = 2L;

        MyNode(short s) {
            super(s);
        }

        @Override
        void checkAppendNode(Node node) {
            throw new DOMException(3, "Cannot append the node to " + this.getNodeName());
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public Node cloneNode(boolean bl) {
            return this;
        }
    }

    class MyOMStyleSheetList
    extends StyleSheetList {
        private static final long serialVersionUID = 2L;

        protected MyOMStyleSheetList(int n) {
            super(n);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean bl = false;
            Iterator<AbstractCSSStyleSheet> iterator = this.iterator();
            while (iterator.hasNext()) {
                AbstractCSSStyleSheet abstractCSSStyleSheet = iterator.next();
                SheetErrorHandler sheetErrorHandler = abstractCSSStyleSheet.getErrorHandler();
                if (!abstractCSSStyleSheet.hasRuleErrorsOrWarnings() && !sheetErrorHandler.hasSacErrors() && !sheetErrorHandler.hasSacWarnings() && !sheetErrorHandler.hasOMErrors() && !sheetErrorHandler.hasOMWarnings()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        @Override
        protected Iterator<AbstractCSSStyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean bl) {
            super.setNeedsUpdate(bl);
        }

        @Override
        protected void update() {
            super.update();
            DOMDocument.this.updateStyleLists();
        }
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        private static final long serialVersionUID = 2L;
        String data;
        private final String target;

        MyProcessingInstruction(String string, String string2) {
            super((short)7);
            this.target = string;
            this.data = string2;
        }

        @Override
        public String getNodeName() {
            return this.getTarget();
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public void setData(String string) throws DOMException {
            if (string == null) {
                string = "";
            } else if (string.indexOf(62) != -1) {
                throw new DOMException(5, "PI is not allowed to contain '>'");
            }
            this.data = string;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public void setNodeValue(String string) throws DOMException {
            this.setData(string);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.getData();
        }

        @Override
        public void setTextContent(String string) throws DOMException {
            this.setData(string);
        }

        @Override
        public ProcessingInstruction cloneNode(boolean bl) {
            MyProcessingInstruction myProcessingInstruction = new MyProcessingInstruction(this.getTarget(), this.getData());
            MyProcessingInstruction.callUserHandlers((short)1, this, myProcessingInstruction);
            return myProcessingInstruction;
        }

        public String toString() {
            return "<?" + this.getTarget() + " " + this.getData() + "?>";
        }
    }

    class MyStyleAttr
    extends MyAttr
    implements StyleAttr {
        private static final long serialVersionUID = 2L;
        private AbstractCSSStyleDeclaration inlineStyle;

        MyStyleAttr(String string) {
            super(string, null);
            this.inlineStyle = null;
        }

        @Override
        void setAttributeOwner(DOMElement dOMElement) {
            super.setAttributeOwner(dOMElement);
            this.onDOMChange();
        }

        @Override
        public String getValue() {
            if (this.inlineStyle == null) {
                return super.getValue();
            }
            return this.inlineStyle.getCssText();
        }

        @Override
        public void setValue(String string) throws DOMException {
            super.setValue(string);
            if (this.inlineStyle != null) {
                this.setInlineStyle(string);
            } else {
                this.getStyle();
            }
            this.onDOMChange();
        }

        @Override
        public AbstractCSSStyleDeclaration getStyle() {
            if (this.inlineStyle == null) {
                this.inlineStyle = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
                this.setInlineStyle(super.getValue());
            }
            return this.inlineStyle;
        }

        private void setInlineStyle(String string) {
            block4: {
                if (string == null) {
                    string = "";
                }
                try {
                    StyleDeclarationErrorHandler styleDeclarationErrorHandler;
                    this.inlineStyle.setCssText(string);
                    if (this.inlineStyle.getLength() == 0 && ((styleDeclarationErrorHandler = this.inlineStyle.getStyleDeclarationErrorHandler()) == null || styleDeclarationErrorHandler.hasErrors())) {
                        this.inlineStyle = null;
                    }
                }
                catch (DOMException dOMException) {
                    DOMDocument.this.getErrorHandler().inlineStyleError(this.getOwnerElement(), dOMException, string);
                    if (this.inlineStyle.getLength() != 0) break block4;
                    this.inlineStyle = null;
                }
            }
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }

        void onDOMChange() {
            DOMDocument.this.onStyleModify();
        }
    }

    private class MyStyleProcessingInstruction
    extends MyProcessingInstruction
    implements LinkStyleProcessingInstruction {
        private static final long serialVersionUID = 2L;
        private AbstractCSSStyleSheet linkedSheet;
        private final LinkedHashMap<String, String> pseudoAttrs;

        private MyStyleProcessingInstruction(String string) {
            super("xml-stylesheet", string);
            this.linkedSheet = null;
            this.pseudoAttrs = new LinkedHashMap();
            this.parseData();
        }

        @Override
        public void setData(String string) throws DOMException {
            super.setData(string);
            this.parseData();
            this.resetSheet();
            if (this.getParentNode() != null) {
                DOMDocument.this.onSheetModify();
            }
        }

        private void parseData() throws DOMException {
            DOMUtil.parsePseudoAttributes(this.getData(), this.pseudoAttrs);
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            super.setParentNode(abstractDOMNode);
            DOMDocument.this.onSheetModify();
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                boolean bl;
                String string = this.getPseudoAttribute("type");
                if (string.length() != 0 && !"text/css".equalsIgnoreCase(string)) {
                    return null;
                }
                MediaQueryList mediaQueryList = DOMDocument.this.parseMediaList(this.getPseudoAttribute("media").trim(), this);
                if (mediaQueryList == null) {
                    return null;
                }
                String string2 = this.getPseudoAttribute("title");
                if (string2.length() == 0) {
                    string2 = null;
                }
                if ((bl = "yes".equalsIgnoreCase(this.getPseudoAttribute("alternate"))) && string2 == null) {
                    DOMDocument.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                    return null;
                }
                String string3 = this.getPseudoAttribute("href");
                int n = string3.length();
                if (n > 1) {
                    if (string3.charAt(0) != '#') {
                        this.linkedSheet = DOMDocument.this.loadStyleSheet(this.linkedSheet, string3, string2, mediaQueryList, this);
                    } else {
                        String string4 = string3.substring(1);
                        DOMElement dOMElement = DOMDocument.this.getElementById(string4);
                        if (dOMElement != null) {
                            String string5 = dOMElement.getTextContent().trim();
                            this.linkedSheet = DOMDocument.this.parseEmbeddedStyleSheet(this.linkedSheet, string5, string2, mediaQueryList, this);
                        } else {
                            DOMDocument.this.getErrorHandler().linkedStyleError(this, "Could not find element with id: " + string4);
                        }
                    }
                    if (bl && this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                } else {
                    DOMDocument.this.getErrorHandler().linkedStyleError(this, "Missing or void href pseudo-attribute.");
                }
            }
            return this.linkedSheet;
        }

        @Override
        public String getPseudoAttribute(String string) {
            String string2 = this.pseudoAttrs.get(string);
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        public void resetSheet() {
            this.linkedSheet = null;
            DOMDocument.this.onSheetModify();
        }

        @Override
        public ProcessingInstruction cloneNode(boolean bl) {
            MyStyleProcessingInstruction myStyleProcessingInstruction = new MyStyleProcessingInstruction(this.getData());
            MyStyleProcessingInstruction.callUserHandlers((short)1, this, myStyleProcessingInstruction);
            return myStyleProcessingInstruction;
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        private static final long serialVersionUID = 2L;
        boolean elementContentWhitespace;

        MyText() {
            super((short)3);
            this.elementContentWhitespace = false;
        }

        MyText(short s) {
            super(s);
            this.elementContentWhitespace = false;
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) {
            DOMNode dOMNode = this.getParentNode();
            if (dOMNode != null && dOMNode.getNodeType() == 1) {
                this.onDOMChange((DOMElement)dOMNode);
            }
            if (abstractDOMNode == null) {
                super.setParentNode(abstractDOMNode);
            } else {
                super.setParentNode(abstractDOMNode);
                if (abstractDOMNode.getNodeType() == 1) {
                    this.onDOMChange((DOMElement)abstractDOMNode);
                }
            }
        }

        @Override
        public void setData(String string) throws DOMException {
            super.setData(string);
            DOMNode dOMNode = this.getParentNode();
            if (dOMNode != null && dOMNode.getNodeType() == 1) {
                this.onDOMChange((DOMElement)dOMNode);
            }
        }

        void onDOMChange(DOMElement dOMElement) {
            LinkStyleDefiner linkStyleDefiner = DOMDocument.this.getEmbeddedStyleDefiner(dOMElement);
            if (linkStyleDefiner != null) {
                linkStyleDefiner.resetSheet();
            }
        }

        @Override
        public Text splitText(int n) throws DOMException {
            Text text;
            DOMNode dOMNode = this.getParentNode();
            try {
                String string = this.data.substring(0, n);
                text = this.getOwnerDocument().createTextNode(this.data.substring(n));
                if (dOMNode != null) {
                    dOMNode.insertBefore(text, this.getNextSibling());
                }
                this.setData(string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DOMException dOMException = new DOMException(1, indexOutOfBoundsException.getMessage());
                dOMException.initCause(indexOutOfBoundsException);
                throw dOMException;
            }
            return text;
        }

        @Override
        public boolean isElementContentWhitespace() {
            DOMElement dOMElement;
            AbstractDOMNode abstractDOMNode;
            if (this.data != null) {
                int n = this.data.length();
                for (int i = 0; i < n; ++i) {
                    if (Character.isWhitespace(this.data.charAt(i))) continue;
                    return false;
                }
            }
            return (abstractDOMNode = this.parentNode()) == null || abstractDOMNode.getNodeType() != 1 || !(dOMElement = (DOMElement)abstractDOMNode).isRawText();
        }

        @Override
        public String getWholeText() {
            short s;
            short s2;
            Node node;
            DOMNode dOMNode = this;
            for (node = this.getPreviousSibling(); node != null && ((s2 = node.getNodeType()) == 3 || s2 == 5); node = node.getPreviousSibling()) {
                dOMNode = node;
            }
            Node node2 = this;
            for (node = this.getNextSibling(); node != null && ((s = node.getNodeType()) == 3 || s == 5); node = node.getNextSibling()) {
                node2 = node;
            }
            if (dOMNode == node2) {
                return this.getData();
            }
            StringBuilder stringBuilder = new StringBuilder(this.data.length() * 2);
            for (node = dOMNode; node != node2; node = node.getNextSibling()) {
                stringBuilder.append(node.toString());
            }
            stringBuilder.append(node2.toString());
            return stringBuilder.toString();
        }

        @Override
        public Text replaceWholeText(String string) throws DOMException {
            if (string == null) {
                throw new DOMException(5, "null content (use empty string instead)");
            }
            DOMNode dOMNode = this.getParentNode();
            if (dOMNode != null) {
                Node node;
                short s;
                Node node2 = this.getPreviousSibling();
                while (node2 != null && ((s = node2.getNodeType()) == 5 || s == 3)) {
                    node = node2.getPreviousSibling();
                    dOMNode.removeChild(node2);
                    node2 = node;
                }
                node2 = this.getNextSibling();
                while (node2 != null && ((s = node2.getNodeType()) == 5 || s == 3)) {
                    node = node2.getNextSibling();
                    dOMNode.removeChild(node2);
                    node2 = node;
                }
            }
            this.setData(string);
            if (string.length() == 0) {
                if (dOMNode != null) {
                    dOMNode.removeChild(this);
                }
                return null;
            }
            return this;
        }

        @Override
        public String getNodeName() {
            return "#text";
        }

        @Override
        public Text cloneNode(boolean bl) {
            MyText myText = new MyText();
            myText.setData(this.getData());
            MyText.callUserHandlers((short)1, this, myText);
            return myText;
        }

        public String toString() {
            String string = this.getData();
            if (!this.isElementContentWhitespace()) {
                DOMNode dOMNode = this.getParentNode();
                if (dOMNode != null && dOMNode.getNodeType() == 1 && ((DOMElement)dOMNode).isRawText()) {
                    String string2 = dOMNode.getLocalName();
                    string = DOMDocument.escapeCloseTag(string2, string);
                } else {
                    string = DOMDocument.escapeLtGtEntities(string);
                }
            }
            return string;
        }
    }

    class MyXMLElement
    extends DOMElement {
        private static final long serialVersionUID = 2L;

        MyXMLElement(String string, String string2) {
            super(string, string2);
        }

        @Override
        boolean isNonHTMLOrVoid() {
            if (this.getNamespaceURI() != "http://www.w3.org/1999/xhtml") {
                return true;
            }
            DocumentType documentType = DOMDocument.this.getDoctype();
            if (documentType != null) {
                ContentModel contentModel;
                try {
                    contentModel = ContentModel.getModel((DocumentType)documentType);
                }
                catch (IOException | SAXException exception) {
                    contentModel = null;
                }
                if (contentModel != null) {
                    return contentModel.isEmpty(this.localName);
                }
            }
            return false;
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMElement cloneNode(boolean bl) {
            return this.cloneElementNode(new MyXMLElement(this.getLocalName(), this.getNamespaceURI()), bl);
        }

        DOMElement cloneElementNode(MyXMLElement myXMLElement, boolean bl) {
            myXMLElement.setPrefix(this.getPrefix());
            for (Node node : this.nodeMap.getNodeList()) {
                DOMAttr dOMAttr = (DOMAttr)node.cloneNode(bl);
                dOMAttr.specified = node.getSpecified();
                myXMLElement.setAttributeNode(dOMAttr);
            }
            if (bl) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    myXMLElement.appendChild(node.cloneNode(true));
                }
            }
            MyXMLElement.callUserHandlers((short)1, this, myXMLElement);
            return myXMLElement;
        }
    }

    static interface StyleAttr
    extends Attr {
        public AbstractCSSStyleDeclaration getStyle();
    }

    private class StyleElement
    extends MyXMLElement
    implements LinkStyleDefiner {
        private static final long serialVersionUID = 2L;
        private final StyleDefinerElementHelper helper;

        StyleElement(String string) {
            super("style", string);
            this.helper = new StyleDefinerElementHelper(this);
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            return this.helper.getInlineSheet();
        }

        @Override
        public void resetSheet() {
            this.helper.resetSheet();
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            super.setParentNode(abstractDOMNode);
            DOMDocument.this.onSheetModify();
        }

        @Override
        void postAddChild(AbstractDOMNode abstractDOMNode) {
            super.postAddChild(abstractDOMNode);
            this.helper.postAddChildInline(abstractDOMNode);
        }

        @Override
        void postRemoveChild(AbstractDOMNode abstractDOMNode) {
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void setTextContent(String string) throws DOMException {
            super.setTextContent(string);
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void normalize() {
            if (!this.helper.containsCSS()) {
                super.normalize();
            } else {
                AbstractCSSStyleSheet abstractCSSStyleSheet = this.getSheet();
                if (abstractCSSStyleSheet != null) {
                    super.setTextContent(abstractCSSStyleSheet.toString());
                } else {
                    super.normalize();
                }
            }
        }

        @Override
        public DOMElement cloneNode(boolean bl) {
            return this.cloneElementNode(new StyleElement(this.getNamespaceURI()), bl);
        }
    }

    class StyleEventAttr
    extends EventAttr {
        private static final long serialVersionUID = 2L;

        StyleEventAttr(String string, String string2) {
            super(string, string2);
        }

        @Override
        void onAttributeRemoval() {
            DOMElement dOMElement = this.getOwnerElement();
            if (dOMElement instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)((Object)dOMElement)).resetSheet();
            }
        }

        @Override
        void onDOMChange(DOMElement dOMElement) {
            if (dOMElement instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)((Object)dOMElement)).resetSheet();
            }
        }
    }

    class XmlnsAttr
    extends MyAttr {
        private static final long serialVersionUID = 2L;

        XmlnsAttr() {
            super("xmlns", DOMDocument.XMLNS_NAMESPACE_URI);
        }

        @Override
        public void setPrefix(String string) throws DOMException {
            throw new DOMException(14, "Cannot set prefix for xmlns attribute");
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }
    }
}

