/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;

class TokenStream {
    private static final int EOF_CHAR = -1;
    private static final int REPORT_NUMBER_FORMAT_ERROR = -2;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char NUMERIC_SEPARATOR = '_';
    private StringBuilder rawString = new StringBuilder();
    private boolean dirtyLine;
    String regExpFlags;
    private String string = "";
    private double number;
    private BigInteger bigInt;
    private boolean isBinary;
    private boolean isOldOctal;
    private boolean isOctal;
    private boolean isHex;
    private int quoteChar;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private ObjToIntMap allStrings = new ObjToIntMap(50);
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private boolean hitEOF = false;
    private int lineStart = 0;
    private int lineEndChar = -1;
    int lineno;
    private String sourceString;
    private Reader sourceReader;
    private char[] sourceBuffer;
    private int sourceEnd;
    int sourceCursor;
    int cursor;
    int tokenBeg;
    int tokenEnd;
    Token.CommentType commentType;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;
    private Parser parser;
    private String commentPrefix = "";
    private int commentCursor = -1;

    TokenStream(Parser parser, Reader reader, String string, int n) {
        this.parser = parser;
        this.lineno = n;
        if (reader != null) {
            if (string != null) {
                Kit.codeBug();
            }
            this.sourceReader = reader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (string == null) {
                Kit.codeBug();
            }
            this.sourceString = string;
            this.sourceEnd = string.length();
        }
        this.cursor = 0;
        this.sourceCursor = 0;
    }

    String tokenToString(int n) {
        return "";
    }

    static boolean isKeyword(String string, int n, boolean bl) {
        return 0 != TokenStream.stringToKeyword(string, n, bl);
    }

    private static int stringToKeyword(String string, int n, boolean bl) {
        if (n < 200) {
            return TokenStream.stringToKeywordForJS(string);
        }
        return TokenStream.stringToKeywordForES(string, bl);
    }

    private static int stringToKeywordForJS(String string) {
        int n;
        int n2 = 124;
        int n3 = 119;
        int n4 = 125;
        int n5 = 120;
        int n6 = 31;
        int n7 = 122;
        int n8 = 117;
        int n9 = 131;
        int n10 = 44;
        int n11 = 123;
        int n12 = 113;
        int n13 = 116;
        int n14 = 52;
        int n15 = 157;
        int n16 = 30;
        int n17 = 42;
        int n18 = 4;
        int n19 = 118;
        int n20 = 43;
        int n21 = 45;
        int n22 = 32;
        int n23 = 126;
        int n24 = 130;
        int n25 = 121;
        int n26 = 127;
        int n27 = 73;
        int n28 = 131;
        int n29 = 131;
        int n30 = 131;
        int n31 = 128;
        int n32 = 131;
        int n33 = 131;
        int n34 = 158;
        int n35 = 164;
        int n36 = 131;
        int n37 = 131;
        int n38 = 131;
        int n39 = 131;
        int n40 = 129;
        int n41 = 131;
        int n42 = 131;
        int n43 = 131;
        int n44 = 131;
        int n45 = 53;
        int n46 = 131;
        int n47 = 131;
        int n48 = 131;
        int n49 = 131;
        int n50 = 131;
        int n51 = 131;
        int n52 = 131;
        int n53 = 131;
        int n54 = 131;
        int n55 = 131;
        int n56 = 131;
        int n57 = 131;
        int n58 = 50;
        int n59 = 131;
        int n60 = 131;
        int n61 = 84;
        int n62 = 131;
        switch (string) {
            case "break": {
                n = 124;
                break;
            }
            case "case": {
                n = 119;
                break;
            }
            case "continue": {
                n = 125;
                break;
            }
            case "default": {
                n = 120;
                break;
            }
            case "delete": {
                n = 31;
                break;
            }
            case "do": {
                n = 122;
                break;
            }
            case "else": {
                n = 117;
                break;
            }
            case "export": {
                n = 131;
                break;
            }
            case "false": {
                n = 44;
                break;
            }
            case "for": {
                n = 123;
                break;
            }
            case "function": {
                n = 113;
                break;
            }
            case "if": {
                n = 116;
                break;
            }
            case "in": {
                n = 52;
                break;
            }
            case "let": {
                n = 157;
                break;
            }
            case "new": {
                n = 30;
                break;
            }
            case "null": {
                n = 42;
                break;
            }
            case "return": {
                n = 4;
                break;
            }
            case "switch": {
                n = 118;
                break;
            }
            case "this": {
                n = 43;
                break;
            }
            case "true": {
                n = 45;
                break;
            }
            case "typeof": {
                n = 32;
                break;
            }
            case "var": {
                n = 126;
                break;
            }
            case "void": {
                n = 130;
                break;
            }
            case "while": {
                n = 121;
                break;
            }
            case "with": {
                n = 127;
                break;
            }
            case "yield": {
                n = 73;
                break;
            }
            case "abstract": {
                n = 131;
                break;
            }
            case "boolean": {
                n = 131;
                break;
            }
            case "byte": {
                n = 131;
                break;
            }
            case "catch": {
                n = 128;
                break;
            }
            case "char": {
                n = 131;
                break;
            }
            case "class": {
                n = 131;
                break;
            }
            case "const": {
                n = 158;
                break;
            }
            case "debugger": {
                n = 164;
                break;
            }
            case "double": {
                n = 131;
                break;
            }
            case "enum": {
                n = 131;
                break;
            }
            case "extends": {
                n = 131;
                break;
            }
            case "final": {
                n = 131;
                break;
            }
            case "finally": {
                n = 129;
                break;
            }
            case "float": {
                n = 131;
                break;
            }
            case "goto": {
                n = 131;
                break;
            }
            case "implements": {
                n = 131;
                break;
            }
            case "import": {
                n = 131;
                break;
            }
            case "instanceof": {
                n = 53;
                break;
            }
            case "int": {
                n = 131;
                break;
            }
            case "interface": {
                n = 131;
                break;
            }
            case "long": {
                n = 131;
                break;
            }
            case "native": {
                n = 131;
                break;
            }
            case "package": {
                n = 131;
                break;
            }
            case "private": {
                n = 131;
                break;
            }
            case "protected": {
                n = 131;
                break;
            }
            case "public": {
                n = 131;
                break;
            }
            case "short": {
                n = 131;
                break;
            }
            case "static": {
                n = 131;
                break;
            }
            case "super": {
                n = 131;
                break;
            }
            case "synchronized": {
                n = 131;
                break;
            }
            case "throw": {
                n = 50;
                break;
            }
            case "throws": {
                n = 131;
                break;
            }
            case "transient": {
                n = 131;
                break;
            }
            case "try": {
                n = 84;
                break;
            }
            case "volatile": {
                n = 131;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n == 0) {
            return 0;
        }
        return n & 0xFF;
    }

    private static int stringToKeywordForES(String string, boolean bl) {
        int n = 124;
        int n2 = 119;
        int n3 = 128;
        int n4 = 131;
        int n5 = 158;
        int n6 = 125;
        int n7 = 164;
        int n8 = 120;
        int n9 = 31;
        int n10 = 122;
        int n11 = 117;
        int n12 = 131;
        int n13 = 131;
        int n14 = 129;
        int n15 = 123;
        int n16 = 113;
        int n17 = 116;
        int n18 = 131;
        int n19 = 52;
        int n20 = 53;
        int n21 = 30;
        int n22 = 4;
        int n23 = 131;
        int n24 = 118;
        int n25 = 43;
        int n26 = 50;
        int n27 = 84;
        int n28 = 32;
        int n29 = 126;
        int n30 = 130;
        int n31 = 121;
        int n32 = 127;
        int n33 = 73;
        int n34 = 131;
        int n35 = 131;
        int n36 = 131;
        int n37 = 131;
        int n38 = 131;
        int n39 = 131;
        int n40 = 131;
        int n41 = 131;
        int n42 = 44;
        int n43 = 42;
        int n44 = 45;
        int n45 = 157;
        int n46 = 131;
        int n47 = 0;
        switch (string) {
            case "break": {
                n47 = 124;
                break;
            }
            case "case": {
                n47 = 119;
                break;
            }
            case "catch": {
                n47 = 128;
                break;
            }
            case "class": {
                n47 = 131;
                break;
            }
            case "const": {
                n47 = 158;
                break;
            }
            case "continue": {
                n47 = 125;
                break;
            }
            case "debugger": {
                n47 = 164;
                break;
            }
            case "default": {
                n47 = 120;
                break;
            }
            case "delete": {
                n47 = 31;
                break;
            }
            case "do": {
                n47 = 122;
                break;
            }
            case "else": {
                n47 = 117;
                break;
            }
            case "export": {
                n47 = 131;
                break;
            }
            case "extends": {
                n47 = 131;
                break;
            }
            case "finally": {
                n47 = 129;
                break;
            }
            case "for": {
                n47 = 123;
                break;
            }
            case "function": {
                n47 = 113;
                break;
            }
            case "if": {
                n47 = 116;
                break;
            }
            case "import": {
                n47 = 131;
                break;
            }
            case "in": {
                n47 = 52;
                break;
            }
            case "instanceof": {
                n47 = 53;
                break;
            }
            case "new": {
                n47 = 30;
                break;
            }
            case "return": {
                n47 = 4;
                break;
            }
            case "super": {
                n47 = 131;
                break;
            }
            case "switch": {
                n47 = 118;
                break;
            }
            case "this": {
                n47 = 43;
                break;
            }
            case "throw": {
                n47 = 50;
                break;
            }
            case "try": {
                n47 = 84;
                break;
            }
            case "typeof": {
                n47 = 32;
                break;
            }
            case "var": {
                n47 = 126;
                break;
            }
            case "void": {
                n47 = 130;
                break;
            }
            case "while": {
                n47 = 121;
                break;
            }
            case "with": {
                n47 = 127;
                break;
            }
            case "yield": {
                n47 = 73;
                break;
            }
            case "await": {
                n47 = 131;
                break;
            }
            case "enum": {
                n47 = 131;
                break;
            }
            case "implements": {
                if (!bl) break;
                n47 = 131;
                break;
            }
            case "interface": {
                if (!bl) break;
                n47 = 131;
                break;
            }
            case "package": {
                if (!bl) break;
                n47 = 131;
                break;
            }
            case "private": {
                if (!bl) break;
                n47 = 131;
                break;
            }
            case "protected": {
                if (!bl) break;
                n47 = 131;
                break;
            }
            case "public": {
                if (!bl) break;
                n47 = 131;
                break;
            }
            case "false": {
                n47 = 44;
                break;
            }
            case "null": {
                n47 = 42;
                break;
            }
            case "true": {
                n47 = 45;
                break;
            }
            case "let": {
                n47 = 157;
                break;
            }
            case "static": {
                if (!bl) break;
                n47 = 131;
                break;
            }
            default: {
                n47 = 0;
            }
        }
        if (n47 == 0) {
            return 0;
        }
        return n47 & 0xFF;
    }

    private static boolean isValidIdentifierName(String string) {
        int n = 0;
        for (int n2 : string.codePoints().toArray()) {
            if (!(n++ == 0 ? n2 != 36 && n2 != 95 && !Character.isUnicodeIdentifierStart(n2) : n2 != 36 && n2 != 8204 && n2 != 8205 && !Character.isUnicodeIdentifierPart(n2))) continue;
            return false;
        }
        return true;
    }

    final String getSourceString() {
        return this.sourceString;
    }

    final int getLineno() {
        return this.lineno;
    }

    final String getString() {
        return this.string;
    }

    final char getQuoteChar() {
        return (char)this.quoteChar;
    }

    final double getNumber() {
        return this.number;
    }

    final BigInteger getBigInt() {
        return this.bigInt;
    }

    final boolean isNumericBinary() {
        return this.isBinary;
    }

    final boolean isNumericOldOctal() {
        return this.isOldOctal;
    }

    final boolean isNumericOctal() {
        return this.isOctal;
    }

    final boolean isNumericHex() {
        return this.isHex;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    final int getToken() throws IOException {
        boolean bl;
        int n;
        do {
            if ((n = this.getChar()) == -1) {
                this.tokenBeg = this.cursor - 1;
                this.tokenEnd = this.cursor;
                return 0;
            }
            if (n != 10) continue;
            this.dirtyLine = false;
            this.tokenBeg = this.cursor - 1;
            this.tokenEnd = this.cursor;
            return 1;
        } while (TokenStream.isJSSpace(n));
        if (n != 45) {
            this.dirtyLine = true;
        }
        this.tokenBeg = this.cursor - 1;
        this.tokenEnd = this.cursor;
        if (n == 64) {
            return 151;
        }
        boolean bl2 = false;
        if (n == 92) {
            n = this.getChar();
            if (n == 117) {
                bl = true;
                bl2 = true;
                this.stringBufferTop = 0;
            } else {
                bl = false;
                this.ungetChar(n);
                n = 92;
            }
        } else {
            boolean bl3 = bl = Character.isUnicodeIdentifierStart(n) || n == 36 || n == 95;
            if (bl) {
                this.stringBufferTop = 0;
                this.addToString(n);
            }
        }
        if (bl) {
            int n2;
            boolean bl4 = bl2;
            while (true) {
                if (bl2) {
                    int n3 = 0;
                    if (this.matchTemplateLiteralChar(123)) {
                        while ((n = this.getTemplateLiteralChar()) != 125 && (n3 = Kit.xDigitToInt(n, n3)) >= 0) {
                        }
                        if (n3 < 0 || n3 > 0x10FFFF) {
                            this.parser.reportError("msg.invalid.escape");
                            break;
                        }
                    } else {
                        for (n2 = 0; n2 != 4; ++n2) {
                            n = this.getChar();
                            n3 = Kit.xDigitToInt(n, n3);
                            if (n3 >= 0) continue;
                            this.parser.reportError("msg.invalid.escape");
                            break;
                        }
                    }
                    if (n3 < 0) {
                        this.parser.addError("msg.invalid.escape");
                        return -1;
                    }
                    this.addToString(n3);
                    bl2 = false;
                    continue;
                }
                n = this.getChar();
                if (n == 92) {
                    n = this.getChar();
                    if (n == 117) {
                        bl2 = true;
                        bl4 = true;
                        continue;
                    }
                    this.parser.addError("msg.illegal.character", n);
                    return -1;
                }
                if (n == -1 || n == 65279 || !Character.isUnicodeIdentifierPart(n) && n != 36) break;
                this.addToString(n);
            }
            this.ungetChar(n);
            String string = this.getStringFromBuffer();
            if (!bl4 || this.parser.compilerEnv.getLanguageVersion() >= 200) {
                n2 = TokenStream.stringToKeyword(string, this.parser.compilerEnv.getLanguageVersion(), this.parser.inUseStrictDirective());
                if (n2 != 0) {
                    if ((n2 == 157 || n2 == 73) && this.parser.compilerEnv.getLanguageVersion() < 170) {
                        this.string = n2 == 157 ? "let" : "yield";
                        n2 = 39;
                    }
                    this.string = (String)this.allStrings.intern(string);
                    if (n2 != 131) {
                        return n2;
                    }
                    if (this.parser.compilerEnv.getLanguageVersion() >= 200) {
                        return n2;
                    }
                    if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                        return n2;
                    }
                }
            } else if (TokenStream.isKeyword(string, this.parser.compilerEnv.getLanguageVersion(), this.parser.inUseStrictDirective())) {
                string = TokenStream.convertLastCharToHex(string);
            }
            if (bl4 && this.parser.compilerEnv.getLanguageVersion() >= 200 && !TokenStream.isValidIdentifierName(string)) {
                this.parser.reportError("msg.invalid.escape");
                return -1;
            }
            this.string = (String)this.allStrings.intern(string);
            return 39;
        }
        if (TokenStream.isDigit(n) || n == 46 && TokenStream.isDigit(this.peekChar())) {
            double d;
            String string;
            boolean bl5;
            this.stringBufferTop = 0;
            int n4 = 10;
            this.isBinary = false;
            this.isOctal = false;
            this.isOldOctal = false;
            this.isHex = false;
            boolean bl6 = bl5 = this.parser.compilerEnv.getLanguageVersion() >= 200;
            if (n == 48) {
                n = this.getChar();
                if (n == 120 || n == 88) {
                    n4 = 16;
                    this.isHex = true;
                    n = this.getChar();
                } else if (bl5 && (n == 111 || n == 79)) {
                    n4 = 8;
                    this.isOctal = true;
                    n = this.getChar();
                } else if (bl5 && (n == 98 || n == 66)) {
                    n4 = 2;
                    this.isBinary = true;
                    n = this.getChar();
                } else if (TokenStream.isDigit(n)) {
                    n4 = 8;
                    this.isOldOctal = true;
                } else {
                    this.addToString(48);
                }
            }
            int n5 = this.stringBufferTop;
            if (n4 == 10 || n4 == 16 || n4 == 8 && !this.isOldOctal || n4 == 2) {
                if ((n = this.readDigits(n4, n)) == -2) {
                    this.parser.addError("msg.caught.nfe");
                    return -1;
                }
            } else {
                while (TokenStream.isDigit(n)) {
                    if (n >= 56) {
                        this.parser.addWarning("msg.bad.octal.literal", n == 56 ? "8" : "9");
                        n4 = 10;
                        n = this.readDigits(n4, n);
                        if (n != -2) break;
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                    this.addToString(n);
                    n = this.getChar();
                }
            }
            if (this.stringBufferTop == n5 && (this.isBinary || this.isOctal || this.isHex)) {
                this.parser.addError("msg.caught.nfe");
                return -1;
            }
            boolean bl7 = true;
            boolean bl8 = false;
            if (bl5 && n == 110) {
                bl8 = true;
                n = this.getChar();
            } else if (n4 == 10 && (n == 46 || n == 101 || n == 69)) {
                bl7 = false;
                if (n == 46) {
                    bl7 = false;
                    this.addToString(n);
                    n = this.getChar();
                    n = this.readDigits(n4, n);
                    if (n == -2) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                }
                if (n == 101 || n == 69) {
                    bl7 = false;
                    this.addToString(n);
                    n = this.getChar();
                    if (n == 43 || n == 45) {
                        this.addToString(n);
                        n = this.getChar();
                    }
                    if (!TokenStream.isDigit(n)) {
                        this.parser.addError("msg.missing.exponent");
                        return -1;
                    }
                    if ((n = this.readDigits(n4, n)) == -2) {
                        this.parser.addError("msg.caught.nfe");
                        return -1;
                    }
                }
            }
            this.ungetChar(n);
            this.string = string = this.getStringFromBuffer();
            int n6 = string.indexOf(95);
            if (n6 != -1) {
                char[] cArray = string.toCharArray();
                for (int i = n6 + 1; i < cArray.length; ++i) {
                    if (cArray[i] == '_') continue;
                    cArray[n6++] = cArray[i];
                }
                string = new String(cArray, 0, n6);
            }
            if (bl8) {
                this.bigInt = new BigInteger(string, n4);
                return 83;
            }
            if (n4 == 10 && !bl7) {
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.parser.addError("msg.caught.nfe");
                    return -1;
                }
            } else {
                d = ScriptRuntime.stringPrefixToNumber(string, 0, n4);
            }
            this.number = d;
            return 40;
        }
        if (n == 34 || n == 39) {
            this.quoteChar = n;
            this.stringBufferTop = 0;
            n = this.getCharIgnoreLineEnd(false);
            block50: while (n != this.quoteChar) {
                boolean bl9 = false;
                if (n == -1) {
                    bl9 = true;
                } else if (n == 10) {
                    switch (this.lineEndChar) {
                        case 10: 
                        case 13: {
                            bl9 = true;
                            break;
                        }
                        case 8232: 
                        case 8233: {
                            n = this.lineEndChar;
                            break;
                        }
                    }
                }
                if (bl9) {
                    this.ungetCharIgnoreLineEnd(n);
                    this.tokenEnd = this.cursor;
                    this.parser.addError("msg.unterminated.string.lit");
                    return -1;
                }
                if (n == 92) {
                    n = this.getChar();
                    switch (n) {
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                            break;
                        }
                        case 117: {
                            int n7;
                            int n8 = this.stringBufferTop;
                            this.addToString(117);
                            int n9 = 0;
                            if (this.matchChar(123)) {
                                while (true) {
                                    if ((n = this.getChar()) == 125) {
                                        this.addToString(n);
                                        break;
                                    }
                                    if ((n9 = Kit.xDigitToInt(n, n9)) < 0) break;
                                    this.addToString(n);
                                }
                                if (n9 < 0 || n9 > 0x10FFFF) {
                                    this.parser.reportError("msg.invalid.escape");
                                    continue block50;
                                }
                            } else {
                                for (n7 = 0; n7 != 4; ++n7) {
                                    n = this.getChar();
                                    n9 = Kit.xDigitToInt(n, n9);
                                    if (n9 < 0) {
                                        if (this.parser.compilerEnv.getLanguageVersion() < 200) continue block50;
                                        this.parser.reportError("msg.invalid.escape");
                                        continue block50;
                                    }
                                    this.addToString(n);
                                }
                            }
                            this.stringBufferTop = n8;
                            n = n9;
                            break;
                        }
                        case 120: {
                            n = this.getChar();
                            int n9 = Kit.xDigitToInt(n, 0);
                            if (n9 < 0) {
                                this.addToString(120);
                                continue block50;
                            }
                            int n7 = n;
                            n = this.getChar();
                            n9 = Kit.xDigitToInt(n, n9);
                            if (n9 < 0) {
                                this.addToString(120);
                                this.addToString(n7);
                                continue block50;
                            }
                            n = n9;
                            break;
                        }
                        case 10: {
                            n = this.getChar();
                            continue block50;
                        }
                        default: {
                            if (48 > n || n >= 56) break;
                            int n10 = n - 48;
                            n = this.getChar();
                            if (48 <= n && n < 56) {
                                n10 = 8 * n10 + n - 48;
                                n = this.getChar();
                                if (48 <= n && n < 56 && n10 <= 31) {
                                    n10 = 8 * n10 + n - 48;
                                    n = this.getChar();
                                }
                            }
                            this.ungetChar(n);
                            n = n10;
                        }
                    }
                }
                this.addToString(n);
                n = this.getChar(false);
            }
            String string = this.getStringFromBuffer();
            this.string = (String)this.allStrings.intern(string);
            return 41;
        }
        if (n == 35 && this.cursor == 1 && this.peekChar() == 33 && !this.parser.calledByCompileFunction) {
            this.skipLine();
            return 165;
        }
        switch (n) {
            case 59: {
                return 85;
            }
            case 91: {
                return 86;
            }
            case 93: {
                return 87;
            }
            case 123: {
                return 88;
            }
            case 125: {
                return 89;
            }
            case 40: {
                return 90;
            }
            case 41: {
                return 91;
            }
            case 44: {
                return 92;
            }
            case 63: {
                return 106;
            }
            case 58: {
                if (this.matchChar(58)) {
                    return 148;
                }
                return 107;
            }
            case 46: {
                if (this.matchChar(46)) {
                    if (this.parser.compilerEnv.getLanguageVersion() >= 180 && this.matchChar(46)) {
                        return 174;
                    }
                    return 147;
                }
                if (this.matchChar(40)) {
                    return 150;
                }
                return 112;
            }
            case 124: {
                if (this.matchChar(124)) {
                    return 108;
                }
                if (this.matchChar(61)) {
                    return 94;
                }
                return 9;
            }
            case 94: {
                if (this.matchChar(61)) {
                    return 95;
                }
                return 10;
            }
            case 38: {
                if (this.matchChar(38)) {
                    return 109;
                }
                if (this.matchChar(61)) {
                    return 96;
                }
                return 11;
            }
            case 61: {
                if (this.matchChar(61)) {
                    if (this.matchChar(61)) {
                        return 46;
                    }
                    return 12;
                }
                if (this.matchChar(62)) {
                    return 168;
                }
                return 93;
            }
            case 33: {
                if (this.matchChar(61)) {
                    if (this.matchChar(61)) {
                        return 47;
                    }
                    return 13;
                }
                return 26;
            }
            case 60: {
                if (this.matchChar(33)) {
                    if (this.matchChar(45)) {
                        if (this.matchChar(45)) {
                            this.tokenBeg = this.cursor - 4;
                            this.skipLine();
                            this.commentType = Token.CommentType.HTML;
                            return 165;
                        }
                        this.ungetCharIgnoreLineEnd(45);
                    }
                    this.ungetCharIgnoreLineEnd(33);
                }
                if (this.matchChar(60)) {
                    if (this.matchChar(61)) {
                        return 97;
                    }
                    return 18;
                }
                if (this.matchChar(61)) {
                    return 15;
                }
                return 14;
            }
            case 62: {
                if (this.matchChar(62)) {
                    if (this.matchChar(62)) {
                        if (this.matchChar(61)) {
                            return 99;
                        }
                        return 20;
                    }
                    if (this.matchChar(61)) {
                        return 98;
                    }
                    return 19;
                }
                if (this.matchChar(61)) {
                    return 17;
                }
                return 16;
            }
            case 42: {
                if (this.parser.compilerEnv.getLanguageVersion() >= 200 && this.matchChar(42)) {
                    if (this.matchChar(61)) {
                        return 105;
                    }
                    return 75;
                }
                if (this.matchChar(61)) {
                    return 102;
                }
                return 23;
            }
            case 47: {
                this.markCommentStart();
                if (this.matchChar(47)) {
                    this.tokenBeg = this.cursor - 2;
                    this.skipLine();
                    this.commentType = Token.CommentType.LINE;
                    return 165;
                }
                if (this.matchChar(42)) {
                    boolean bl10 = false;
                    this.tokenBeg = this.cursor - 2;
                    if (this.matchChar(42)) {
                        bl10 = true;
                        this.commentType = Token.CommentType.JSDOC;
                    } else {
                        this.commentType = Token.CommentType.BLOCK_COMMENT;
                    }
                    while (true) {
                        if ((n = this.getChar()) == -1) {
                            this.tokenEnd = this.cursor - 1;
                            this.parser.addError("msg.unterminated.comment");
                            return 165;
                        }
                        if (n == 42) {
                            bl10 = true;
                            continue;
                        }
                        if (n == 47) {
                            if (!bl10) continue;
                            this.tokenEnd = this.cursor;
                            return 165;
                        }
                        bl10 = false;
                        this.tokenEnd = this.cursor;
                    }
                }
                if (this.matchChar(61)) {
                    return 103;
                }
                return 24;
            }
            case 37: {
                if (this.matchChar(61)) {
                    return 104;
                }
                return 25;
            }
            case 126: {
                return 27;
            }
            case 43: {
                if (this.matchChar(61)) {
                    return 100;
                }
                if (this.matchChar(43)) {
                    return 110;
                }
                return 21;
            }
            case 45: {
                if (this.matchChar(61)) {
                    n = 101;
                } else if (this.matchChar(45)) {
                    if (!this.dirtyLine && this.matchChar(62)) {
                        this.markCommentStart("--");
                        this.skipLine();
                        this.commentType = Token.CommentType.HTML;
                        return 165;
                    }
                    n = 111;
                } else {
                    n = 22;
                }
                this.dirtyLine = true;
                return n;
            }
            case 96: {
                return 170;
            }
        }
        this.parser.addError("msg.illegal.character", n);
        return -1;
    }

    private int readDigits(int n, int n2) throws IOException {
        if (TokenStream.isDigit(n, n2)) {
            block6: {
                this.addToString(n2);
                n2 = this.getChar();
                if (n2 == -1) {
                    return -1;
                }
                while (true) {
                    if (n2 == 95) {
                        n2 = this.getChar();
                        if (n2 == 10 || n2 == -1) {
                            return -2;
                        }
                        if (!TokenStream.isDigit(n, n2)) {
                            this.ungetChar(n2);
                            return 95;
                        }
                        this.addToString(95);
                        continue;
                    }
                    if (!TokenStream.isDigit(n, n2)) break block6;
                    this.addToString(n2);
                    n2 = this.getChar();
                    if (n2 == -1) break;
                }
                return -1;
            }
            return n2;
        }
        return n2;
    }

    private static boolean isAlpha(int n) {
        if (n <= 90) {
            return 65 <= n;
        }
        return 97 <= n && n <= 122;
    }

    private static boolean isDigit(int n, int n2) {
        return n == 10 && TokenStream.isDigit(n2) || n == 16 && TokenStream.isHexDigit(n2) || n == 8 && TokenStream.isOctalDigit(n2) || n == 2 && TokenStream.isDualDigit(n2);
    }

    private static boolean isDualDigit(int n) {
        return 48 == n || n == 49;
    }

    private static boolean isOctalDigit(int n) {
        return 48 <= n && n <= 55;
    }

    private static boolean isDigit(int n) {
        return 48 <= n && n <= 57;
    }

    private static boolean isHexDigit(int n) {
        return 48 <= n && n <= 57 || 97 <= n && n <= 102 || 65 <= n && n <= 70;
    }

    private static boolean isJSSpace(int n) {
        if (n <= 127) {
            return n == 32 || n == 9 || n == 12 || n == 11;
        }
        return n == 160 || n == 65279 || Character.getType((char)n) == 12;
    }

    private static boolean isJSFormatChar(int n) {
        return n > 127 && Character.getType((char)n) == 16;
    }

    void readRegExp(int n) throws IOException {
        int n2;
        int n3 = this.tokenBeg;
        this.stringBufferTop = 0;
        if (n == 103) {
            this.addToString(61);
        } else {
            if (n != 24) {
                Kit.codeBug();
            }
            if (this.peekChar() == 42) {
                this.tokenEnd = this.cursor - 1;
                this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                this.parser.reportError("msg.unterminated.re.lit");
                return;
            }
        }
        boolean bl = false;
        while ((n2 = this.getChar()) != 47 || bl) {
            if (n2 == 10 || n2 == -1) {
                this.ungetChar(n2);
                this.tokenEnd = this.cursor - 1;
                this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                this.parser.reportError("msg.unterminated.re.lit");
                return;
            }
            if (n2 == 92) {
                this.addToString(n2);
                n2 = this.getChar();
                if (n2 == 10 || n2 == -1) {
                    this.ungetChar(n2);
                    this.tokenEnd = this.cursor - 1;
                    this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
                    this.parser.reportError("msg.unterminated.re.lit");
                    return;
                }
            } else if (n2 == 91) {
                bl = true;
            } else if (n2 == 93) {
                bl = false;
            }
            this.addToString(n2);
        }
        int n4 = this.stringBufferTop;
        while (true) {
            if (this.matchChar(103)) {
                this.addToString(103);
                continue;
            }
            if (this.matchChar(105)) {
                this.addToString(105);
                continue;
            }
            if (this.matchChar(109)) {
                this.addToString(109);
                continue;
            }
            if (this.matchChar(115)) {
                this.addToString(115);
                continue;
            }
            if (!this.matchChar(121)) break;
            this.addToString(121);
        }
        this.tokenEnd = n3 + this.stringBufferTop + 2;
        if (TokenStream.isAlpha(this.peekChar())) {
            this.parser.reportError("msg.invalid.re.flag", String.valueOf(Character.toChars(this.peekChar())));
        }
        this.string = new String(this.stringBuffer, 0, n4);
        this.regExpFlags = new String(this.stringBuffer, n4, this.stringBufferTop - n4);
    }

    String readAndClearRegExpFlags() {
        String string = this.regExpFlags;
        this.regExpFlags = null;
        return string;
    }

    String getRawString() {
        if (this.rawString.length() == 0) {
            return "";
        }
        return this.rawString.toString();
    }

    private int getTemplateLiteralChar() throws IOException {
        int n = this.getCharIgnoreLineEnd(false);
        if (n == 10) {
            switch (this.lineEndChar) {
                case 13: {
                    if (this.charAt(this.cursor) != 10) break;
                    this.getCharIgnoreLineEnd(false);
                    break;
                }
                case 8232: 
                case 8233: {
                    n = this.lineEndChar;
                    break;
                }
            }
            this.lineEndChar = -1;
            this.lineStart = this.sourceCursor - 1;
            ++this.lineno;
        }
        this.rawString.append((char)n);
        return n;
    }

    private void ungetTemplateLiteralChar(int n) {
        this.ungetCharIgnoreLineEnd(n);
        this.rawString.setLength(this.rawString.length() - 1);
    }

    private boolean matchTemplateLiteralChar(int n) throws IOException {
        int n2 = this.getTemplateLiteralChar();
        if (n2 == n) {
            return true;
        }
        this.ungetTemplateLiteralChar(n2);
        return false;
    }

    private int peekTemplateLiteralChar() throws IOException {
        int n = this.getTemplateLiteralChar();
        this.ungetTemplateLiteralChar(n);
        return n;
    }

    int readTemplateLiteral(boolean bl) throws IOException {
        this.rawString.setLength(0);
        this.stringBufferTop = 0;
        boolean bl2 = false;
        block20: while (true) {
            int n = this.getTemplateLiteralChar();
            switch (n) {
                case -1: {
                    this.string = bl2 ? null : this.getStringFromBuffer();
                    this.tokenEnd = this.cursor - 1;
                    this.parser.reportError("msg.unexpected.eof");
                    return -1;
                }
                case 96: {
                    this.rawString.setLength(this.rawString.length() - 1);
                    this.string = bl2 ? null : this.getStringFromBuffer();
                    return 170;
                }
                case 36: {
                    if (this.matchTemplateLiteralChar(123)) {
                        this.rawString.setLength(this.rawString.length() - 2);
                        this.string = bl2 ? null : this.getStringFromBuffer();
                        this.tokenEnd = this.cursor - 1;
                        return 172;
                    }
                    this.addToString(n);
                    continue block20;
                }
                case 92: {
                    n = this.getTemplateLiteralChar();
                    switch (n) {
                        case 10: 
                        case 8232: 
                        case 8233: {
                            continue block20;
                        }
                        case 34: 
                        case 39: 
                        case 92: {
                            break;
                        }
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                            break;
                        }
                        case 120: {
                            int n2;
                            int n3 = 0;
                            for (n2 = 0; n2 < 2; ++n2) {
                                if (this.peekTemplateLiteralChar() == 96) {
                                    n3 = -1;
                                    break;
                                }
                                n3 = Kit.xDigitToInt(this.getTemplateLiteralChar(), n3);
                            }
                            if (n3 < 0) {
                                if (bl) {
                                    bl2 = true;
                                    continue block20;
                                }
                                this.parser.reportError("msg.syntax");
                                return -1;
                            }
                            n = n3;
                            break;
                        }
                        case 117: {
                            int n2;
                            int n3 = 0;
                            if (this.matchTemplateLiteralChar(123)) {
                                while (true) {
                                    if (this.peekTemplateLiteralChar() == 96) {
                                        n3 = -1;
                                        break;
                                    }
                                    n = this.getTemplateLiteralChar();
                                    if (n == -1) {
                                        this.parser.reportError("msg.syntax");
                                        return -1;
                                    }
                                    if (n == 125) break;
                                    n3 = Kit.xDigitToInt(n, n3);
                                }
                                if (n3 < 0 || n3 > 0x10FFFF) {
                                    if (bl) {
                                        bl2 = true;
                                        continue block20;
                                    }
                                    this.parser.reportError("msg.syntax");
                                    return -1;
                                }
                                if (n3 > 65535) {
                                    this.addToString(Character.highSurrogate(n3));
                                    this.addToString(Character.lowSurrogate(n3));
                                    continue block20;
                                }
                                n = n3;
                                break;
                            }
                            for (n2 = 0; n2 < 4; ++n2) {
                                if (this.peekTemplateLiteralChar() == 96) {
                                    n3 = -1;
                                    break;
                                }
                                n3 = Kit.xDigitToInt(this.getTemplateLiteralChar(), n3);
                            }
                            if (n3 < 0) {
                                if (bl) {
                                    bl2 = true;
                                    continue block20;
                                }
                                this.parser.reportError("msg.syntax");
                                return -1;
                            }
                            n = n3;
                            break;
                        }
                        case 48: {
                            int n3 = this.peekTemplateLiteralChar();
                            if (n3 >= 48 && n3 <= 57) {
                                if (bl) {
                                    bl2 = true;
                                    continue block20;
                                }
                                this.parser.reportError("msg.syntax");
                                return -1;
                            }
                            n = 0;
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (bl) {
                                bl2 = true;
                                continue block20;
                            }
                            this.parser.reportError("msg.syntax");
                            return -1;
                        }
                    }
                    this.addToString(n);
                    continue block20;
                }
            }
            this.addToString(n);
        }
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        if (!this.canUngetChar()) {
            return -1;
        }
        this.ungetChar(60);
        return this.getNextXMLToken();
    }

    int getNextXMLToken() throws IOException {
        this.tokenBeg = this.cursor;
        this.stringBufferTop = 0;
        int n = this.getChar();
        while (n != -1) {
            if (this.xmlIsTagContent) {
                switch (n) {
                    case 62: {
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.addToString(n);
                        if (this.peekChar() != 62) break;
                        n = this.getChar();
                        this.addToString(n);
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 149;
                    }
                    case 34: 
                    case 39: {
                        this.addToString(n);
                        if (this.readQuotedString(n)) break;
                        return -1;
                    }
                    case 61: {
                        this.addToString(n);
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.addToString(n);
                        break;
                    }
                    default: {
                        this.addToString(n);
                        this.xmlIsAttribute = false;
                    }
                }
                if (!this.xmlIsTagContent && this.xmlOpenTagsCount == 0) {
                    this.string = this.getStringFromBuffer();
                    return 152;
                }
            } else {
                block8 : switch (n) {
                    case 60: {
                        this.addToString(n);
                        n = this.peekChar();
                        switch (n) {
                            case 33: {
                                n = this.getChar();
                                this.addToString(n);
                                n = this.peekChar();
                                switch (n) {
                                    case 45: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        n = this.getChar();
                                        if (n == 45) {
                                            this.addToString(n);
                                            if (this.readXmlComment()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    case 91: {
                                        n = this.getChar();
                                        this.addToString(n);
                                        if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                                            this.addToString(67);
                                            this.addToString(68);
                                            this.addToString(65);
                                            this.addToString(84);
                                            this.addToString(65);
                                            this.addToString(91);
                                            if (this.readCDATA()) break block8;
                                            return -1;
                                        }
                                        this.stringBufferTop = 0;
                                        this.string = null;
                                        this.parser.addError("msg.XML.bad.form");
                                        return -1;
                                    }
                                    default: {
                                        if (this.readEntity()) break block8;
                                        return -1;
                                    }
                                }
                            }
                            case 63: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.readPI()) break block8;
                                return -1;
                            }
                            case 47: {
                                n = this.getChar();
                                this.addToString(n);
                                if (this.xmlOpenTagsCount == 0) {
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                this.xmlIsTagContent = true;
                                --this.xmlOpenTagsCount;
                                break;
                            }
                            default: {
                                this.xmlIsTagContent = true;
                                ++this.xmlOpenTagsCount;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        this.ungetChar(n);
                        this.string = this.getStringFromBuffer();
                        return 149;
                    }
                    default: {
                        this.addToString(n);
                    }
                }
            }
            n = this.getChar();
        }
        this.tokenEnd = this.cursor;
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return -1;
    }

    private boolean readQuotedString(int n) throws IOException {
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            if (n2 == n) {
                return true;
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 45 && this.peekChar() == 45) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readCDATA() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 93 && this.peekChar() == 93) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int n = 1;
        int n2 = this.getChar();
        while (n2 != -1) {
            this.addToString(n2);
            switch (n2) {
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n != 0) break;
                    return true;
                }
            }
            n2 = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 63 && this.peekChar() == 62) {
                n = this.getChar();
                this.addToString(n);
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private String getStringFromBuffer() {
        this.tokenEnd = this.cursor;
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int n) {
        int n2 = this.stringBufferTop;
        int n3 = Character.charCount(n);
        if (n2 + n3 >= this.stringBuffer.length) {
            char[] cArray = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, cArray, 0, n2);
            this.stringBuffer = cArray;
        }
        if (n3 == 1) {
            this.stringBuffer[n2] = (char)n;
        } else {
            this.stringBuffer[n2] = Character.highSurrogate(n);
            this.stringBuffer[n2 + 1] = Character.lowSurrogate(n);
        }
        this.stringBufferTop = n2 + n3;
    }

    private boolean canUngetChar() {
        return this.ungetCursor == 0 || this.ungetBuffer[this.ungetCursor - 1] != 10;
    }

    private void ungetChar(int n) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = n;
        --this.cursor;
    }

    private boolean matchChar(int n) throws IOException {
        int n2 = this.getCharIgnoreLineEnd();
        if (n2 == n) {
            this.tokenEnd = this.cursor;
            return true;
        }
        this.ungetCharIgnoreLineEnd(n2);
        return false;
    }

    private int peekChar() throws IOException {
        int n = this.getChar();
        this.ungetChar(n);
        return n;
    }

    private int getChar() throws IOException {
        return this.getChar(true, false);
    }

    private int getChar(boolean bl) throws IOException {
        return this.getChar(bl, false);
    }

    private int getChar(boolean bl, boolean bl2) throws IOException {
        int n;
        block12: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceString != null) {
                    if (this.sourceCursor == this.sourceEnd) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    n = this.sourceString.codePointAt(this.sourceCursor);
                    this.sourceCursor += Character.charCount(n);
                } else {
                    if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                        this.hitEOF = true;
                        return -1;
                    }
                    ++this.cursor;
                    n = this.sourceBuffer[this.sourceCursor++];
                }
                if (!bl2 && this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && n == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    this.lineStart = this.sourceCursor - 1;
                    ++this.lineno;
                }
                if (n <= 127) {
                    if (n == 10 || n == 13) {
                        this.lineEndChar = n;
                        n = 10;
                    }
                    break block12;
                }
                if (n == 65279) {
                    return n;
                }
                if (!bl || !TokenStream.isJSFormatChar(n)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(n)) {
                this.lineEndChar = n;
                n = 10;
            }
        }
        return n;
    }

    private int getCharIgnoreLineEnd() throws IOException {
        return this.getChar(true, true);
    }

    private int getCharIgnoreLineEnd(boolean bl) throws IOException {
        return this.getChar(bl, true);
    }

    private void ungetCharIgnoreLineEnd(int n) {
        this.ungetBuffer[this.ungetCursor++] = n;
        --this.cursor;
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.getChar()) != -1 && n != 10) {
        }
        this.ungetChar(n);
        this.tokenEnd = this.cursor;
    }

    final int getOffset() {
        int n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            --n;
        }
        return n;
    }

    private final int charAt(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.sourceString != null) {
            if (n >= this.sourceEnd) {
                return -1;
            }
            return this.sourceString.charAt(n);
        }
        if (n >= this.sourceEnd) {
            int n2 = this.sourceCursor;
            try {
                if (!this.fillSourceBuffer()) {
                    return -1;
                }
            }
            catch (IOException iOException) {
                return -1;
            }
            n -= n2 - this.sourceCursor;
        }
        return this.sourceBuffer[n];
    }

    private final String substring(int n, int n2) {
        if (this.sourceString != null) {
            return this.sourceString.substring(n, n2);
        }
        int n3 = n2 - n;
        return new String(this.sourceBuffer, n, n3);
    }

    final String getLine() {
        int n = this.sourceCursor;
        if (this.lineEndChar >= 0) {
            if (this.lineEndChar == 10 && this.charAt(--n - 1) == 13) {
                --n;
            }
        } else {
            int n2;
            int n3 = n - this.lineStart;
            while ((n2 = this.charAt(this.lineStart + n3)) != -1 && !ScriptRuntime.isJSLineTerminator(n2)) {
                ++n3;
            }
            n = this.lineStart + n3;
        }
        return this.substring(this.lineStart, n);
    }

    final String getLine(int n, int[] nArray) {
        int n2;
        assert (n >= 0 && n <= this.cursor);
        assert (nArray.length == 2);
        int n3 = this.cursor + this.ungetCursor - n;
        int n4 = this.sourceCursor;
        if (n3 > n4) {
            return null;
        }
        int n5 = 0;
        int n6 = 0;
        while (n3 > 0) {
            assert (n4 > 0);
            n2 = this.charAt(n4 - 1);
            if (ScriptRuntime.isJSLineTerminator(n2)) {
                if (n2 == 10 && this.charAt(n4 - 2) == 13) {
                    --n3;
                    --n4;
                }
                ++n6;
                n5 = n4 - 1;
            }
            --n3;
            --n4;
        }
        n2 = 0;
        int n7 = 0;
        while (n4 > 0) {
            int n8 = this.charAt(n4 - 1);
            if (ScriptRuntime.isJSLineTerminator(n8)) {
                n2 = n4;
                break;
            }
            --n4;
            ++n7;
        }
        nArray[0] = this.lineno - n6 + (this.lineEndChar >= 0 ? 1 : 0);
        nArray[1] = n7;
        if (n6 == 0) {
            return this.getLine();
        }
        return this.substring(n2, n5);
    }

    private boolean fillSourceBuffer() throws IOException {
        int n;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0 && !this.isMarkingComment()) {
                System.arraycopy(this.sourceBuffer, this.lineStart, this.sourceBuffer, 0, this.sourceEnd - this.lineStart);
                this.sourceEnd -= this.lineStart;
                this.sourceCursor -= this.lineStart;
                this.lineStart = 0;
            } else {
                char[] cArray = new char[this.sourceBuffer.length * 2];
                System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceEnd);
                this.sourceBuffer = cArray;
            }
        }
        if ((n = this.sourceReader.read(this.sourceBuffer, this.sourceEnd, this.sourceBuffer.length - this.sourceEnd)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getTokenBeg() {
        return this.tokenBeg;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public int getTokenLength() {
        return this.tokenEnd - this.tokenBeg;
    }

    public Token.CommentType getCommentType() {
        return this.commentType;
    }

    private void markCommentStart() {
        this.markCommentStart("");
    }

    private void markCommentStart(String string) {
        if (this.parser.compilerEnv.isRecordingComments() && this.sourceReader != null) {
            this.commentPrefix = string;
            this.commentCursor = this.sourceCursor - 1;
        }
    }

    private boolean isMarkingComment() {
        return this.commentCursor != -1;
    }

    final String getAndResetCurrentComment() {
        if (this.sourceString != null) {
            if (this.isMarkingComment()) {
                Kit.codeBug();
            }
            return this.sourceString.substring(this.tokenBeg, this.tokenEnd);
        }
        if (!this.isMarkingComment()) {
            Kit.codeBug();
        }
        StringBuilder stringBuilder = new StringBuilder(this.commentPrefix);
        stringBuilder.append(this.sourceBuffer, this.commentCursor, this.getTokenLength() - this.commentPrefix.length());
        this.commentCursor = -1;
        return stringBuilder.toString();
    }

    private static String convertLastCharToHex(String string) {
        int n = string.length() - 1;
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
        stringBuilder.append("\\u");
        String string2 = Integer.toHexString(string.charAt(n));
        for (int i = 0; i < 4 - string2.length(); ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

