/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.SortedSet;
import java.util.TreeSet;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ScriptNode;

public class AstRoot
extends ScriptNode {
    private SortedSet<Comment> comments;

    public AstRoot() {
        this.type = 140;
    }

    public AstRoot(int n) {
        super(n);
        this.type = 140;
    }

    public SortedSet<Comment> getComments() {
        return this.comments;
    }

    public void setComments(SortedSet<Comment> sortedSet) {
        if (sortedSet == null) {
            this.comments = null;
        } else {
            if (this.comments != null) {
                this.comments.clear();
            }
            for (Comment comment : sortedSet) {
                this.addComment(comment);
            }
        }
    }

    public void addComment(Comment comment) {
        this.assertNotNull(comment);
        if (this.comments == null) {
            this.comments = new TreeSet<AstNode>(new AstNode.PositionComparator());
        }
        this.comments.add(comment);
        comment.setParent(this);
    }

    public void visitComments(NodeVisitor nodeVisitor) {
        if (this.comments != null) {
            for (Comment comment : this.comments) {
                nodeVisitor.visit(comment);
            }
        }
    }

    public void visitAll(NodeVisitor nodeVisitor) {
        this.visit(nodeVisitor);
        this.visitComments(nodeVisitor);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : this) {
            stringBuilder.append(((AstNode)node).toSource(n));
            if (node.getType() != 165) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String debugPrint() {
        AstNode.DebugPrintVisitor debugPrintVisitor = new AstNode.DebugPrintVisitor(new StringBuilder(1000));
        this.visitAll(debugPrintVisitor);
        return debugPrintVisitor.toString();
    }

    public void checkParentLinks() {
        this.visit(new NodeVisitor(){

            @Override
            public boolean visit(AstNode astNode) {
                int n = astNode.getType();
                if (n == 140) {
                    return true;
                }
                if (astNode.getParent() == null) {
                    throw new IllegalStateException("No parent for node: " + astNode + "\n" + astNode.toSource(0));
                }
                return true;
            }
        });
    }
}

