# frozen_string_literal: true

class RemoveIndexVulnerabilityReadsCommonFinderQueryWNamespaceId < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  disable_ddl_transaction!

  TABLE_NAME = :vulnerability_reads
  COLUMNS = %i[namespace_id state report_type severity vulnerability_id dismissal_reason]
  INDEX_NAME = 'index_vulnerability_reads_common_finder_query_w_namespace_id'

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, COLUMNS, order: { vulnerability_id: :desc }, name: INDEX_NAME
  end
end
