# frozen_string_literal: true

class CreateIdxVulnerabilityOccurencesOnPrimIdenId < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.1'

  NEW_INDEX_NAME = 'index_vulnerability_occurrences_prim_iden_id_and_vuln_id'
  TABLE_NAME = :vulnerability_occurrences

  # -- This index was created async previously, check https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131647
  def up
    add_concurrent_index( # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
      TABLE_NAME, [:primary_identifier_id, :vulnerability_id],
      name: NEW_INDEX_NAME
    )
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, NEW_INDEX_NAME
  end
end
