---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Manage your GitLab instance and configure features in the UI.
title: GitLab管理者エリア
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 製品: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

**管理者**エリアは、GitLab Self-Managedインスタンスの機能を管理および設定するためのWeb UIを提供します。管理者として**管理者**エリアにアクセスするには、次の手順に従います。

- GitLab 17.3以降: 左側のサイドバーの下部で、**管理者**を選択します。
- GitLab 16.7以降: 左側のサイドバーの下部で、**管理者エリア**を選択します。
- GitLab 16.1以降: 左側のサイドバーで、**検索または移動**を選択し、次に**管理者**を選択します。
- GitLab 16.0以前: 上部のバーで、**メインメニュー > 管理者**を選択します。

GitLabインスタンスで管理者モードを使用している場合、**管理者**を表示するには、[セッションの管理者モードを有効にする](settings/sign_in_restrictions.md#turn-on-admin-mode-for-your-session)必要があります。

{{< alert type="note" >}}

**管理者**エリアにアクセスできるのは、GitLab Self-ManagedまたはGitLab Dedicatedの管理者のみです。GitLab.comでは、**管理者**エリア機能は利用できません。

{{< /alert >}}

## プロジェクトを管理する

**管理者**エリアのプロジェクトページからGitLabインスタンス内のすべてのプロジェクトを管理するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > プロジェクト**を選択します。
1. **すべて**、**プライベート**、**内部**、または**公開**タブを選択すると、その条件に一致するプロジェクトのみが一覧表示されます。
1. （オプション）これらのフィルターと並べ替えのオプションを組み合わせて、目的のプロジェクトを見つけることができます。

   - **名前で絞り込む**を選択します。検索するプロジェクト名を入力すると、テキストの入力に応じてGitLabがプロジェクトをフィルタリングします。

   - **並べ替え順**を選択すると、プロジェクトを以下の条件で並べ替えることができます。

     - 更新日
     - 最終作成日
     - 名前
     - 最もお気に入りに登録
     - 最も古い作成日
     - 最も古い更新日
     - 最大のリポジトリ

   - **並べ替え順**を選択して、プロジェクトをフィルタリングします。

     - アーカイブしたプロジェクトを非表示（または表示）
     - アーカイブしたプロジェクトのみを表示
     - 誰でも所有
     - 自分が所有

   - ネームスペース内のプロジェクトをフィルタリングするには、**ネームスペース**を選択します。ネームスペースを絞り込むためのテキストを入力し、該当するものを選択します。

### プロジェクトを編集する

**管理者**エリアのプロジェクトページからプロジェクトの名前または説明を編集するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > プロジェクト**を選択します。
1. 編集するプロジェクトの横にある**編集**を選択します。
1. **プロジェクト名**または**プロジェクトの説明**を編集します。
1. **変更の保存**を選択します。

### プロジェクトを削除する

プロジェクトを削除するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > プロジェクト**を選択します。
1. 編集するプロジェクトの横にある**削除**を選択します。

## ユーザーを管理する

{{< history >}}

- GitLab 17.0でユーザーのフィルタリングが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/238183)されました。

{{< /history >}}

**管理者**エリアのユーザーページには、各ユーザーに関する次の情報が表示されます。

- ユーザー名
- メールアドレス
- プロジェクトメンバーシップ数
- グループメンバーシップ数
- アカウント作成日
- 最後のアクティビティの日付

**管理者**エリアのユーザーページからすべてのユーザーを管理するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > ユーザー**を選択します。
1. （オプション）並べ替え順（デフォルトはユーザー名）を変更するには、次の手順に従います。

   1. 並べ替えのドロップダウンリストを選択します。
   1. 目的の順序を選択します。

1. （オプション）ユーザー検索ボックスを使用して、次の条件でユーザーを検索およびフィルタリングします。

   - ユーザーの**アクセスレベル**
   - **2要素認証**が有効/無効
   - ユーザーの**状態**

1. （オプション）ユーザー検索フィールドにテキストを入力し、<kbd>Enter</kbd>キーを押します。この大文字と小文字を区別しないテキスト検索では、名前、ユーザー名、メールアドレスに部分一致が適用されます。

ユーザーを編集するには、ユーザーの行を見つけて**編集**を選択します。

### ユーザーを削除する

**管理者**エリアのユーザーページから、ユーザーを削除するか、ユーザーとそのコントリビュートを削除するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > ユーザー**を選択します。
1. 削除するユーザーを見つけます。その行で、**ユーザー管理**（{{< icon name="ellipsis_v">}}）を選択し、目的のオプションを選択します。

### ユーザーの代理

管理者は、他の管理者を含む他のユーザーの代理となることができます。これにより、GitLabでユーザーに表示される内容を確認し、ユーザーに代わってアクションを実行できます。

ユーザーの代理となるには、次の手順に従います。

- UIを使用する場合:
  1. 左側のサイドバーの下部で、**管理者**を選択します。
  1. 左側のサイドバーで、**概要 > ユーザー**を選択します。
  1. ユーザーのリストからユーザーを選択します。
  1. 右上にある**代理**を選択します。
- APIを使用する場合は、[代理トークン](../api/rest/authentication.md#impersonation-tokens)を使用します。

すべての代理アクティビティは、[監査イベントとしてキャプチャ](compliance/audit_event_reports.md#user-impersonation)されます。デフォルトでは、代理は有効になっています。GitLabの設定で[代理を無効](../api/rest/authentication.md#disable-impersonation)にすることもできます。

### ユーザーアイデンティティ

{{< history >}}

- GitLab 15.3で、ユーザーのSCIMアイデンティティの表示が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/294608)されました。

{{< /history >}}

認証プロバイダーを使用している場合、管理者はユーザーのアイデンティティを確認できます。このページでは、SCIMアイデンティティを含むユーザーのアイデンティティが表示されます。この情報を使用して、SCIM関連の問題を解決したり、アカウントに使用されているアイデンティティを確認したりできます。

これを行うには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > ユーザー**を選択します。
1. ユーザーのリストからユーザーを選択します。
1. **識別子**を選択します。

### ユーザー権限をエクスポートする

{{< details >}}

- プラン: Premium、Ultimate
- 製品: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ユーザー権限をエクスポートすると、エクスポートされた情報には、ユーザーがグループやプロジェクトに対して持つ直接的なメンバーシップが表示されます。これには次のデータが含まれます。ただし、最初の100,000人のユーザーに制限されています。

- ユーザー名
- メール
- タイプ
- パス
- アクセスレベル（[プロジェクト](../user/permissions.md#project-members-permissions)および[グループ](../user/permissions.md#group-members-permissions)）
- 最後のアクティビティの日付。この列に入力されるアクティビティのリストについては、[Users APIのドキュメント](../api/users.md#list-a-users-activity)を参照してください。

GitLabインスタンスにおけるすべてのアクティブユーザーのユーザー権限をエクスポートするには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > ユーザー**を選択します。
1. 右上で、**権限をCSV形式でエクスポート**（{{< icon name="export" >}}）を選択します。

### ユーザー統計

**ユーザー統計**ページには、ロールごとのユーザーアカウントの概要が表示されます。この統計は毎日計算されます。最後の更新以降に行われたユーザーの変更は反映されません。以下の合計も含まれます。

- 請求対象ユーザー
- ブロックされたユーザー
- 総ユーザー数

GitLabの請求は、[請求対象ユーザー](../subscriptions/self_managed/_index.md#billable-users)の数に基づいています。

### ユーザーにメールアドレスを追加する

メールアドレスをユーザーアカウントに手動で追加するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > ユーザー**を選択します。
1. ユーザーを見つけて選択します。
1. **編集**を選択します。
1. **メール**に、新しいメールアドレスを入力します。これにより、新しいメールアドレスがユーザーに追加され、以前のメールアドレスがセカンダリに設定されます。
1. **変更の保存**を選択します。

## ユーザーの世代

[世代](user_cohorts.md)タブには、新しいユーザーの月別の世代とその経時的なアクティビティが表示されます。

## ユーザーがトップレベルグループを作成できないようにする

デフォルトでは、ユーザーはトップレベルグループを作成できます。ユーザーがトップレベルグループを作成できないようにするには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > ユーザー**を選択します。
1. ユーザーを見つけて選択します。
1. **編集**を選択します。
1. **トップレベルグループを作成できる**チェックボックスをオフにします。
1. **変更の保存**を選択します。

どのロールが[別のグループのサブグループを作成](../user/group/subgroups/_index.md#change-who-can-create-subgroups)できるかを制限することも可能です。

## グループを管理する

GitLabインスタンス内のすべてのグループを管理するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > グループ**を選択します。このページには、グループの次の情報が表示されます。

   - 名前
   - 説明
   - サイズ
   - グループ内のプロジェクト数
   - メンバー数
   - プライバシーレベル: プライベート、内部、公開のいずれか

1. グループを管理するには、グループの行を見つけて**編集**または**削除**を選択します。
1. （オプション）並べ替え順を変更するには、並べ替えのドロップダウンリストを選択し、目的の順序を選択します。使用可能な並べ替えオプションは次のとおりです。

   - 作成日（デフォルト）
   - 更新日
   - ストレージサイズ。このオプションは、グループ内のすべてのプロジェクトのGitリポジトリとLarge File Storage（LFS）を含む、合計ストレージ使用量でグループを並べ替えます。詳細については、[使用量割り当て](../user/storage_usage_quotas.md)を参照してください。

1. （オプション）名前でグループを検索するには、検索フィールドに条件を入力します。グループ検索では大文字と小文字は区別されず、部分一致が適用されます。
1. （オプション）[新しいグループを作成](../user/group/_index.md#create-a-group)するには、**新しいグループ**を選択します。

## トピックを管理する

{{< history >}}

- GitLab 15.5でトピックのマージが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/366884)されました。

{{< /history >}}

[トピック](../user/project/project_topics.md)を使用して、プロジェクトを分類し、類似のプロジェクトを見つけることができます。

### すべてのトピックを表示する

GitLabインスタンス内のすべてのトピックを表示するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > トピック**を選択します。

このページにはトピックごとに、トピック名と、そのトピックでラベル付けされたプロジェクトの数が表示されます。

### トピックを検索する

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > トピック**を選択します。
1. 検索ボックスに検索条件を入力します。トピック検索では大文字と小文字は区別されず、部分一致が適用されます。

### トピックを作成する

トピックを作成するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > トピック**を選択します。
1. **新規トピック**を選択します。
1. **トピックslug（名前）**と**トピックタイトル**を入力します。
1. （オプション）**説明**を入力し、**トピックのアバター**を追加します。
1. **変更の保存**を選択します。

作成されたトピックが、**トピックを見る**ページに表示されます。

割り当てられたトピックは、そのプロジェクトにアクセスできるユーザーのみに表示されますが、GitLabインスタンスに存在するトピックは誰でも確認できます。トピック名に機密情報を含めないでください。

### トピックを編集する

トピックの名前、タイトル、説明、アバターはいつでも編集できます。トピックを編集するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > トピック**を選択します。
1. そのトピックの行で**編集**を選択します。
1. トピックslug（名前）、タイトル、説明、またはアバターを編集します。
1. **変更の保存**を選択します。

### トピックを削除する

トピックが不要になった場合は、完全に削除できます。トピックを削除するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > トピック**を選択します。
1. トピックを削除するには、そのトピックの行で**削除**を選択します。

### トピックをマージする

あるトピックに割り当てられているすべてのプロジェクトを、別のトピックに移動できます。その後、移動元のトピックは完全に削除されます。マージされたトピックが削除された後、復元することはできません。

トピックをマージするには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > トピック**を選択します。
1. **マージトピック**を選択します。
1. **ソーストピック**ドロップダウンリストから、マージして削除するトピックを選択します。
1. **ターゲットトピック**ドロップダウンリストから、ソーストピックをマージするトピックを選択します。
1. **マージ**を選択します。

## Gitalyサーバーを管理する

**管理者**エリアの**Gitalyサーバー**ページから、GitLabインスタンス内のすべてのGitalyサーバーを一覧表示できます。詳細については、[Gitaly](gitaly/_index.md)を参照してください。

**Gitalyサーバー**ページにアクセスするには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > Gitalyサーバー**を選択します。

このページには、各Gitalyサーバーに関する次の情報が含まれています。

| フィールド          | 説明 |
|----------------|-------------|
| ストレージ        | リポジトリストレージ |
| アドレス        | Gitalyサーバーがリッスンしているネットワークアドレス |
| サーバーバージョン | Gitalyバージョン |
| Gitのバージョン    | GitalyサーバーにインストールされているGitのバージョン |
| 最新     | Gitalyサーバーのバージョンが利用可能な最新バージョンであるかどうかを示します。緑色の点は、サーバーが最新であることを示します。 |

## 組織を管理する

{{< history >}}

- GitLab 16.10で`ui_for_organizations`[フラグ](feature_flags.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/419540)されました。デフォルトで無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

GitLab Self-Managedでは、デフォルトでこの機能は使用できません。管理者が`ui_for_organizations`[機能フラグを有効にする](feature_flags.md)と、この機能を使用できるようになります。GitLab.comとGitLab Dedicatedでは、この機能は使用できません。この機能は本番環境での使用には対応していません。

{{< /alert >}}

**管理者**エリアの組織ページには、デフォルトですべてのプロジェクトが、最終更新日時の降順に表示されます。各プロジェクトの次の情報が表示されます。

- 名前
- ネームスペース
- 説明
- サイズ（最大15分ごとに更新）

このページからGitLabインスタンス内のすべての組織を管理するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > 組織**を選択します。

## CI/CDセクション

### Runnerを管理する

{{< history >}}

- GitLab 15.8で**概要 > Runner**から**CI/CD > Runner**に[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/340859)しました。

{{< /history >}}

GitLabインスタンス内のすべてのRunnerを管理するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **CI/CD > Runner**を選択します。

各Runnerの次の情報が表示されます。

| 属性    | 説明 |
|--------------|-------------|
| ステータス       | Runnerのステータス。[GitLab 15.1以降](https://gitlab.com/gitlab-org/gitlab/-/issues/22224)では、**Ultimate**プランの場合、アップグレードステータスを利用できます。 |
| Runnerの詳細 | Runnerに関する情報。部分的なトークンと、Runnerの登録元のコンピューターに関する詳細が含まれます。 |
| バージョン      | GitLab Runnerのバージョン。 |
| ジョブ         | Runnerによって実行されたジョブの合計数。 |
| タグ         | Runnerに関連付けられているタグ。 |
| 最終コンタクト | RunnerがGitLabインスタンスに最後に接続したときのタイムスタンプ。 |

各Runnerを編集、一時停止、削除することもできます。

詳細については、[GitLab Runner](https://docs.gitlab.com/runner/)を参照してください。

#### Runnerを検索およびフィルタリングする

Runnerの説明を検索するには、次の手順に従います。

1. **検索または結果をフィルタリング**テキストボックスに、検索するRunnerの説明を入力します。
1. <kbd>Enter</kbd>キーを押します。

ステータス、タイプ、タグでRunnerをフィルタリングするには、次の手順に従います。

1. タブを選択するか、**検索または結果をフィルタリング**テキストボックスを選択します。
1. **タイプ**を選択するか、**ステータス**または**タグ**でフィルタリングします。
1. 検索条件を選択または入力します。

![ステータスでフィルタリングされたRunnerの属性。](img/index_runners_search_or_filter_v14_5.png)

#### Runnerを一括削除する

{{< history >}}

- GitLab 15.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/370241)されました。
- GitLab 15.5で[機能フラグが削除](https://gitlab.com/gitlab-org/gitlab/-/issues/353981)されました。

{{< /history >}}

複数のRunnerを同時に削除するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **概要 > Runner**を選択します。
1. 削除するRunnerの左側にあるチェックボックスをオンにします。ページ上のすべてのRunnerを選択するには、リストの上にあるチェックボックスをオンにします。
1. **選択した項目を削除**を選択します。

### ジョブを管理する

{{< history >}}

- GitLab 15.8で**概要 > ジョブ**から**CI/CD > ジョブ**に[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/386311)しました。

{{< /history >}}

GitLabインスタンス内のすべてのジョブを管理するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **CI/CD > ジョブ**を選択します。すべてのジョブが、ジョブIDの降順で一覧表示されます。
1. すべてのジョブを一覧表示するには、**すべて**タブを選択します。特定のステータスのジョブのみを一覧表示するには、**保留中**、**実行中**、または**完了**タブを選択します。

各ジョブの次の詳細が表示されます。

| フィールド    | 説明 |
|----------|-------------|
| ステータス   | ジョブのステータス。**成功**、**スキップ済み**、**失敗**のいずれか。              |
| ジョブ      | ジョブ、ブランチ、およびジョブを開始したコミットへの各リンクが含まれます。 |
| パイプライン | 特定のパイプラインへのリンクが含まれます。                               |
| プロジェクト  | ジョブが属するプロジェクトと組織の名前。        |
| Runner   | ジョブの実行に割り当てられたCI Runnerの名前。                      |
| ステージ    | ジョブが`.gitlab-ci.yml`ファイルで宣言されているステージ。              |
| 名前     | `.gitlab-ci.yml`ファイルで指定されたジョブの名前。                   |
| タイミング   | ジョブの所要時間、およびジョブが完了してからの経過時間。                |
| カバレッジ | テストカバレッジの割合。                                           |

## モニタリングセクション

次のトピックでは、**管理者**エリアの**モニタリング**セクションについて説明します。

### システム情報

{{< history >}}

- GitLab 15.2で相対時間のサポートが[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/341248)されました。「アップタイム」統計は「システムの起動日時」に名称変更されました。

{{< /history >}}

**システム情報**ページには、次の統計が表示されます。

| フィールド          | 説明                                       |
|:---------------|:--------------------------------------------------|
| CPU            | 利用可能なCPUコアの数                     |
| メモリ使用量   | 使用中のメモリと利用可能なメモリの合計         |
| ディスク使用量     | 使用中のディスク容量と利用可能なディスク容量の合計 |
| システムの起動日時 | GitLabをホストしているシステムが起動した日時。GitLab 15.1以前では、これはアップタイム統計でした。 |

これらの統計は、**システム情報**ページに移動するか、ブラウザでページを更新した場合にのみ更新されます。

### バックグラウンドジョブ

**バックグラウンドジョブ**ページには、Sidekiqダッシュボードが表示されます。Sidekiqは、GitLabがバックグラウンドプロセスを実行するために使用します。

Sidekiqダッシュボードには、以下の情報が含まれています。

- ジョブのステータスごとのタブ。
- バックグラウンドジョブの統計の内訳。
- **処理済み**ジョブと**失敗**ジョブのライブグラフ（ポーリングの間隔を選択可能）。
- **処理済み**ジョブと**失敗**ジョブの履歴グラフ（時間範囲を選択可能）。
- Redisの統計。以下の情報が含まれています。
  - バージョン番号
  - アップタイム（日単位）
  - 接続数
  - 現在のメモリ使用量（MB単位）
  - ピークメモリ使用量（MB単位）

### ログ

以下のログファイルの内容は、問題を解決するために役立ちます。各ログファイルの内容は、時系列順に表示されます。パフォーマンスの問題を最小限に抑えるため、各ログファイルの最大2,000行が表示されます。

| ログファイル                | 内容 |
|:------------------------|:---------|
| `application_json.log`  | GitLabユーザーアクティビティ |
| `git_json.log`          | GitLabとGitリポジトリ間の失敗したインタラクション |
| `production.log`        | Pumaから受信したリクエストと、それを処理するために実行されたアクション |
| `sidekiq.log`           | バックグラウンドジョブ |
| `repocheck.log`         | リポジトリのアクティビティ |
| `integrations_json.log` | GitLabと統合システム間のアクティビティ |
| `kubernetes.log`        | Kubernetesのアクティビティ |

これらのログファイルとその内容の詳細については、[ログシステム](logs/_index.md)を参照してください。

マルチノードシステムの管理者の混乱を防ぐため、**管理者**エリアのダッシュボードから**ログ**ビューが削除されました。このビューには、マルチノードセットアップの部分的な情報しか表示されません。マルチノードシステムの場合は、ElasticsearchやSplunkなどのサービスにログをインジェストしてください。

### 監査イベント

{{< details >}}

- プラン: Premium、Ultimate
- 製品: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

**監査イベント**ページには、GitLabサーバーに加えられた変更が一覧表示されます。この情報を使用して、すべての変更を制御、分析、追跡できます。

### 統計

ダッシュボードの**インスタンスの概要**セクションには、GitLabインスタンスの現在の統計が一覧表示されます。[Application statistics API](../api/statistics.md#get-details-on-current-application-statistics)を使用して、この情報を取得します。

これらの統計は、10,000未満の値については正確な数を示しています。値が10,000以上の場合は、[`TablesampleCountStrategy`](https://gitlab.com/gitlab-org/gitlab/-/blob/master/lib/gitlab/database/count/tablesample_count_strategy.rb?ref_type=heads#L16)および[`ReltuplesCountStrategy`](https://gitlab.com/gitlab-org/gitlab/-/blob/master/lib/gitlab/database/count/reltuples_count_strategy.rb?ref_type=heads)の戦略に基づいて計算され、おおよそのデータを示しています。
