---
stage: Create
group: Import
info: Any user with at least the Maintainer role can merge updates to this content. For details, see https://docs.gitlab.com/development/development_processes/#development-guidelines-review.
title: Proofread Translations
---

Most translations are contributed, reviewed, and accepted by the community. We
are very appreciative of the work done by translators and proofreaders!

## Proofreaders

<!-- vale gitlab_base.Spelling = NO -->

- Albanian
  - Proofreaders needed.
- Amharic
  - Proofreaders needed.
- Arabic
  - Proofreaders needed.
- Basque
  - Unai Tolosa - [GitLab](https://gitlab.com/utolosa002), [Crowdin](https://crowdin.com/profile/utolosa002)
- Belarusian
  - Anton Katsuba - [GitLab](https://gitlab.com/coinvariant), [Crowdin](https://crowdin.com/profile/aerialfiddle)
- Bosnian
  - Proofreaders needed.
- Bulgarian
  - Proofreaders needed.
- Catalan
  - Proofreaders needed.
- Chinese Simplified 简体中文
  - Zhiyuan Lu - [GitLab](https://gitlab.com/luzhiyuan.deer), [Crowdin](https://crowdin.com/profile/luzhiyuan.deer)
- Chinese Traditional 繁體中文
  - Hansel Wang - [GitLab](https://gitlab.com/airness), [Crowdin](https://crowdin.com/profile/airness)
- Chinese Traditional, Hong Kong 繁體中文 (香港)
  - Proofreaders needed.
- Croatian
  - Proofreaders needed.
- Czech
  - Proofreaders needed.
- Danish
  - scootergrisen - [GitLab](https://gitlab.com/scootergrisen), [Crowdin](https://crowdin.com/profile/scootergrisen)
- Dutch
  - Proofreaders needed.
- English (UK)
  - Proofreaders needed.
- Esperanto
  - Proofreaders needed.
- Estonian
  - Proofreaders needed.
- Farsi
  - Iman manati   [GitLab](https://gitlab.com/baratiiman3), [Crowdin](https://crowdin.com/profile/iman31)
- Filipino
  - Proofreaders needed.
- French
  - Xavier Delatour - [GitLab](https://gitlab.com/xdelatour), [Crowdin](https://crowdin.com/profile/xdelatour)
- Galician
  - Proofreaders needed.
- German
  - Vladislav Wanner - [GitLab](https://gitlab.com/RumBugen), [Crowdin](https://crowdin.com/profile/RumBugen)
  - Daniel Ziegenberg - [GitLab](https://gitlab.com/ziegenberg), [Crowdin](https://crowdin.com/profile/ziegenberg)
- Greek
  - Proofreaders needed.
- Hebrew
  - Yaron Shahrabani - [GitLab](https://gitlab.com/yarons), [Crowdin](https://crowdin.com/profile/YaronSh)
- Hindi
  - Proofreaders needed.
- Hungarian
  - Proofreaders needed.
- Indonesian
  - Rahayu Rafika - [GitLab](https://gitlab.com/Vkfikaa), [Crowdin](https://crowdin.com/profile/rahayurafika_12)
- Irish
  - Aindriú Mac Giolla Eoin -  [GitLab](https://gitlab.com/aindriu80), [Crowdin](https://crowdin.com/profile/aindriu80)
- Italian
  - Proofreaders needed.
- Japanese
  - Tomo Dote - [GitLab](https://gitlab.com/fu7mu4), [Crowdin](https://crowdin.com/profile/fu7mu4)
  - Tsukasa Komatsubara - [GitLab](https://gitlab.com/tkomatsubara), [Crowdin](https://crowdin.com/profile/tkomatsubara)
  - Noriko Akiyama - [GitLab](https://gitlab.com/nakiyama-ext), [Crowdin](https://crowdin.com/profile/norikoakiyama)
  - Naoko Shirakuni - [GitLab](https://gitlab.com/SNaoko), [Crowdin](https://crowdin.com/profile/tamongen)
  - Megumi Uchikawa - [GitLab](https://gitlab.com/muchikawa), [Crowdin](https://crowdin.com/profile/muchikawa)
- Korean
  - Sunjung Park - [GitLab](https://gitlab.com/sunjungp), [Crowdin](https://crowdin.com/profile/sunjungp)
  - Hwanyong Lee - [GitLab](https://gitlab.com/hwan_ajou), [Crowdin](https://crowdin.com/profile/grbear)
- Latvian
  - ℂ𝕠𝕠𝕠𝕝 - [GitLab](https://gitlab.com/Coool), [Crowdin](https://crowdin.com/profile/Coool)
- Mongolian
  - Proofreaders needed.
- Norwegian Bokmal
  - Imre Kristoffer Eilertsen - [GitLab](https://gitlab.com/DandelionSprout), [Crowdin](https://crowdin.com/profile/DandelionSprout)
- Polish
  - Proofreaders needed.
- Portuguese
  - Proofreaders needed.
- Portuguese, Brazilian
  - Eduardo Addad de Oliveira - [GitLab](https://gitlab.com/eduardoaddad), [Crowdin](https://crowdin.com/profile/eduardoaddad)
- Romanian
  - Proofreaders needed.
- Russian
  - Alexey Butkeev - [GitLab](https://gitlab.com/abutkeev), [Crowdin](https://crowdin.com/profile/abutkeev)
  - Dmitry Fedoroff - [GitLab](https://gitlab.com/DmitryFedoroff), [Crowdin](https://crowdin.com/profile/DmitryFedoroff)
  - Mark Minakou - [GitLab](https://gitlab.com/sandzhaj), [Crowdin](https://crowdin.com/profile/sandzhaj)
  - Andrey Komarov - [GitLab](https://gitlab.com/elkamarado), [Crowdin](https://crowdin.com/profile/kamarado)
- Serbian (Latin and Cyrillic)
  - Proofreaders needed.
- Sinhalese/Sinhala සිංහල
  - හෙළබස (HelaBasa) - [GitLab](https://gitlab.com/helabasa), [Crowdin](https://crowdin.com/profile/helabasa)
- Slovak
  - Proofreaders needed.
- Spanish
  - David Elizondo - [GitLab](https://gitlab.com/daelmo), [Crowdin](https://crowdin.com/profile/daelmo)
  - Pablo Reyes - [GitLab](https://gitlab.com/pabloryst9n), [Crowdin](https://crowdin.com/profile/pabloryst9n)
  - Gustavo Román - [GitLab](https://gitlab.com/GustavoStark), [Crowdin](https://crowdin.com/profile/gustavonewton)
- Swedish
  - Johannes Nilsson - [GitLab](https://gitlab.com/pixelregn), [Crowdin](https://crowdin.com/profile/pixelregn)
- Turkish
  - Proofreaders needed.
- Ukrainian
  - Andrew Vityuk - [GitLab](https://gitlab.com/3_1_3_u), [Crowdin](https://crowdin.com/profile/andruwa13)
- Welsh
  - Proofreaders needed.
<!-- vale gitlab_base.Spelling = YES -->

## Become a proofreader

Before requesting proofreader permissions in Crowdin, be sure you have a history of contributing
translations to the GitLab project.

1. Contribute translations to GitLab. See instructions for
   [translating GitLab](translation.md).

   Translating GitLab is a community effort that requires teamwork and attention to detail.
   Proofreaders play an important role helping new contributors, and ensuring the consistency and
   quality of translations. Your conduct and contributions as a translator should reflect this
   before requesting to be a proofreader.

1. Request proofreader permissions by opening a merge request to add yourself to the list of
   proofreaders.

   Open the [`proofreader.md` source file](https://gitlab.com/gitlab-org/gitlab/-/blob/master/doc/development/i18n/proofreader.md) and select **Edit**.

   Add your language in alphabetical order and add yourself to the list, including:

   - Name
   - Link to your GitLab profile
   - Link to your Crowdin profile

   In the merge request description, include links to any projects you have previously translated.

1. [GitLab team members](https://about.gitlab.com/company/team/),
   [core team members](https://about.gitlab.com/community/core-team/),
   [globalization and localization team members](https://handbook.gitlab.com/handbook/marketing/localization/),
   or current proofreaders fluent in the language consider your request to become a proofreader
   based on the merits of your previous translations.

   - If you request to become the first proofreader for a language and there are no GitLab or Core
     team members who speak that language, we request links to previous translation work in other
     communities or projects.
