---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Server-Side Request Forgery
---

## Description

The application is susceptible to Server-Side Request Forgery (SSRF), a high-risk vulnerability
that allows attackers to make unauthorized requests to internal and external resources. This
vulnerability arises when user-controlled input is not properly validated or sanitized before
being used in requests to resources, enabling attackers to manipulate these requests for
malicious purposes.

## Remediation

Avoid using user-supplied data for constructing requests. If there is a business need for this,
consider an allowlist approach and/or block requests to internal resources using firewall
rules or a robust request library with anti-SSRF support.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 918.1 | false | 918 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/918.html)
- [OWASP](https://owasp.org/www-community/attacks/Server_Side_Request_Forgery)
- [Server-Side Request Forgery Prevention Cheat Sheet](https://cheatsheetseries.owasp.org/cheatsheets/Server_Side_Request_Forgery_Prevention_Cheat_Sheet.html)
