# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    # This batched background migration is EE-only,
    # see ee/lib/ee/gitlab/background_migration/backfill_dismissal_reason_in_vulnerability_reads.rb for the actual
    # migration code.
    #
    # This batched background migration will backfill `dismissal_reason` field in `vulnerability_reads` table for
    # records with `state: 2` and `dismissal_reason: null`.
    class BackfillDismissalReasonInVulnerabilityReads < BatchedMigrationJob
      feature_category :vulnerability_management

      def perform; end
    end
  end
end

Gitlab::BackgroundMigration::BackfillDismissalReasonInVulnerabilityReads.prepend_mod
