# frozen_string_literal: true

module Babosa
  module Transliterator
    class Greek < Base
      APPROXIMATIONS = {
        "Α" => "A",
        "Ά" => "A",
        "α" => "a",
        "ά" => "a",
        "Β" => "V",
        "β" => "v",
        "Γ" => "G",
        "γ" => "g",
        "Δ" => "D",
        "δ" => "d",
        "Ε" => "E",
        "Έ" => "E",
        "ε" => "e",
        "έ" => "e",
        "Ζ" => "Z",
        "ζ" => "z",
        "Η" => "I",
        "Ή" => "i",
        "η" => "i",
        "ή" => "i",
        "Θ" => "TH",
        "θ" => "th",
        "Ι" => "I",
        "Ί" => "Ι",
        "Î" => "I",
        "ι" => "i",
        "ί" => "i",
        "ϊ" => "i",
        "ΐ" => "i",
        "Κ" => "K",
        "κ" => "k",
        "Λ" => "L",
        "λ" => "l",
        "Μ" => "M",
        "μ" => "m",
        "Ν" => "N",
        "ν" => "n",
        "Ξ" => "KS",
        "ξ" => "ks",
        "Ο" => "O",
        "Ό" => "O",
        "ο" => "o",
        "ό" => "o",
        "Π" => "P",
        "π" => "p",
        "Ρ" => "R",
        "ρ" => "r",
        "Σ" => "S",
        "σ" => "s",
        "ς" => "s",
        "Τ" => "T",
        "τ" => "t",
        "Υ" => "Y",
        "Ύ" => "Y",
        "υ" => "y",
        "ύ" => "y",
        "ϋ" => "y",
        "ΰ" => "y",
        "Φ" => "F",
        "φ" => "f",
        "Χ" => "X",
        "χ" => "x",
        "Ψ" => "PS",
        "ψ" => "ps",
        "Ω" => "O",
        "Ώ" => "O",
        "ω" => "o",
        "ώ" => "o"
      }.freeze
    end
  end
end
