/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.LDAPConstants;
import org.keycloak.models.RealmModel;
import org.keycloak.models.StorageProviderRealmModel;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;

public class MigrateTo1_3_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.3.0");

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateLDAPProviders(session, (RealmModel)realm));
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateLDAPProviders(session, realm);
    }

    private void migrateLDAPProviders(KeycloakSession session, RealmModel realm) {
        ((StorageProviderRealmModel)realm).getUserStorageProvidersStream().forEachOrdered(fedProvider -> {
            if (fedProvider.getProviderId().equals("ldap")) {
                ProviderFactory ldapFactory;
                String usernameLdapAttribute;
                List usersDn;
                MultivaluedHashMap config = (fedProvider = new UserStorageProviderModel((ComponentModel)fedProvider)).getConfig();
                if (config.get((Object)"searchScope") == null) {
                    config.putSingle((Object)"searchScope", (Object)String.valueOf(2));
                }
                if ((usersDn = (List)config.remove((Object)"userDnSuffix")) != null && !usersDn.isEmpty() && config.getFirst((Object)"usersDn") == null) {
                    config.put((Object)"usersDn", (Object)usersDn);
                }
                if ((usernameLdapAttribute = (String)config.getFirst((Object)"usernameLDAPAttribute")) != null && config.getFirst((Object)"rdnLDAPAttribute") == null) {
                    if (usernameLdapAttribute.equalsIgnoreCase("sAMAccountName")) {
                        config.putSingle((Object)"rdnLDAPAttribute", (Object)"cn");
                    } else {
                        config.putSingle((Object)"rdnLDAPAttribute", (Object)usernameLdapAttribute);
                    }
                }
                if (config.getFirst((Object)"uuidLDAPAttribute") == null) {
                    String uuidAttrName = LDAPConstants.getUuidAttributeName((String)((String)config.getFirst((Object)"vendor")));
                    config.putSingle((Object)"uuidLDAPAttribute", (Object)uuidAttrName);
                }
                realm.updateComponent((ComponentModel)fedProvider);
                if (realm.getComponentsStream(fedProvider.getId()).count() == 0L && (ldapFactory = session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, "ldap")) != null) {
                    ((ComponentFactory)ldapFactory).onCreate(session, realm, (ComponentModel)fedProvider);
                }
            }
        });
    }
}

